/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.arbaro.tree;

import java.io.PrintWriter;
import java.util.Enumeration;
import java.util.Vector;
import net.sourceforge.arbaro.export.Console;
import net.sourceforge.arbaro.export.Progress;
import net.sourceforge.arbaro.params.IntParam;
import net.sourceforge.arbaro.params.LevelParams;
import net.sourceforge.arbaro.params.Params;
import net.sourceforge.arbaro.transformation.Transformation;
import net.sourceforge.arbaro.tree.LeafCounter;
import net.sourceforge.arbaro.tree.Stem;
import net.sourceforge.arbaro.tree.StemCounter;
import net.sourceforge.arbaro.tree.StemImpl;
import net.sourceforge.arbaro.tree.Tree;
import net.sourceforge.arbaro.tree.TreeTraversal;

class TreeImpl
implements Tree {
    public Params params;
    int seed = 13;
    Progress progress;
    long stemCount;
    long leafCount;
    Vector trunks;
    double trunk_rotangle = 0.0;
    net.sourceforge.arbaro.transformation.Vector maxPoint;
    net.sourceforge.arbaro.transformation.Vector minPoint;
    long genProgress;

    public int getSeed() {
        return this.seed;
    }

    public long getStemCount() {
        return this.stemCount;
    }

    public long getLeafCount() {
        return this.leafCount;
    }

    public void setStemCount(long cnt) {
        this.stemCount = cnt;
    }

    public void setLeafCount(long cnt) {
        this.leafCount = cnt;
    }

    public net.sourceforge.arbaro.transformation.Vector getMaxPoint() {
        return this.maxPoint;
    }

    public net.sourceforge.arbaro.transformation.Vector getMinPoint() {
        return this.minPoint;
    }

    public double getHeight() {
        return this.maxPoint.getZ();
    }

    public double getWidth() {
        return Math.sqrt(Math.max(this.minPoint.getX() * this.minPoint.getX() + this.minPoint.getY() * this.minPoint.getY(), this.maxPoint.getX() * this.maxPoint.getX() + this.maxPoint.getY() * this.maxPoint.getY()));
    }

    public TreeImpl(int seed, Params params) {
        this.params = params;
        this.seed = seed;
        this.trunks = new Vector();
    }

    public TreeImpl(TreeImpl other) {
        this.params = new Params(other.params);
        this.trunks = new Vector();
    }

    public void clear() {
        this.trunks = new Vector();
    }

    public void make(Progress progress) {
        this.progress = progress;
        this.setupGenProgress();
        this.params.prepare(this.seed);
        this.maxPoint = new net.sourceforge.arbaro.transformation.Vector(-1.7976931348623157E308, -1.7976931348623157E308, -1.7976931348623157E308);
        this.minPoint = new net.sourceforge.arbaro.transformation.Vector(Double.MAX_VALUE, Double.MAX_VALUE, Double.MAX_VALUE);
        Console.verboseOutput("Tree species: " + this.params.Species + ", Seed: " + this.seed);
        Console.verboseOutput("making " + this.params.Species + "(" + this.seed + ") ");
        Transformation transf = new Transformation();
        LevelParams lpar = this.params.getLevelParams(0);
        int i = 0;
        while (i < lpar.nBranches) {
            Transformation trf = this.trunkDirection(transf, lpar);
            double angle = lpar.var(360.0);
            double dist = lpar.var(lpar.nBranchDist);
            trf = trf.translate(new net.sourceforge.arbaro.transformation.Vector(dist * Math.sin(angle), dist * Math.cos(angle), 0.0));
            StemImpl trunk = new StemImpl(this, null, 0, trf, 0.0);
            this.trunks.addElement(trunk);
            trunk.index = 0;
            trunk.make();
            ++i;
        }
        if (this.params.Leaves == 0) {
            this.setLeafCount(0L);
        } else {
            LeafCounter leafCounter = new LeafCounter();
            this.traverseTree(leafCounter);
            this.setLeafCount(leafCounter.getLeafCount());
        }
        StemCounter stemCounter = new StemCounter();
        this.traverseTree(stemCounter);
        this.setStemCount(stemCounter.getStemCount());
        Console.progressChar();
        progress.endPhase();
    }

    Transformation trunkDirection(Transformation trf, LevelParams lpar) {
        double rotangle;
        if (lpar.nRotate >= 0.0) {
            rotangle = this.trunk_rotangle = (this.trunk_rotangle + lpar.nRotate + lpar.var(lpar.nRotateV) + 360.0) % 360.0;
        } else {
            if (Math.abs(this.trunk_rotangle) != 1.0) {
                this.trunk_rotangle = 1.0;
            }
            this.trunk_rotangle = -this.trunk_rotangle;
            rotangle = this.trunk_rotangle * (180.0 + lpar.nRotate + lpar.var(lpar.nRotateV));
        }
        double downangle = lpar.nDownAngle + lpar.var(lpar.nDownAngleV);
        return trf.rotxz(downangle, rotangle);
    }

    public boolean traverseTree(TreeTraversal traversal) {
        if (traversal.enterTree(this)) {
            Enumeration stems = this.trunks.elements();
            while (stems.hasMoreElements()) {
                if (!((Stem)stems.nextElement()).traverseTree(traversal)) break;
            }
        }
        return traversal.leaveTree(this);
    }

    public void minMaxTest(net.sourceforge.arbaro.transformation.Vector pt) {
        this.maxPoint.setMaxCoord(pt);
        this.minPoint.setMinCoord(pt);
    }

    public void paramsToXML(PrintWriter out) {
        this.params.toXML(out);
    }

    public String getSpecies() {
        return this.params.getSpecies();
    }

    public int getLevels() {
        return this.params.Levels;
    }

    public String getLeafShape() {
        return this.params.LeafShape;
    }

    public double getLeafWidth() {
        return this.params.LeafScale * this.params.LeafScaleX / Math.sqrt(this.params.LeafQuality);
    }

    public double getLeafLength() {
        return this.params.LeafScale / Math.sqrt(this.params.LeafQuality);
    }

    public double getLeafStemLength() {
        return this.params.LeafStemLen;
    }

    public String getVertexInfo(int level) {
        return "vertices/section: " + this.params.getLevelParams((int)level).mesh_points + ", smooth: " + (this.params.smooth_mesh_level >= level ? "yes" : "no");
    }

    public void setupGenProgress() {
        if (this.progress != null) {
            long maxGenProgress = ((IntParam)this.params.getParam("0Branches")).intValue() * ((IntParam)this.params.getParam("0CurveRes")).intValue() * (((IntParam)this.params.getParam("1Branches")).intValue() + 1);
            this.progress.beginPhase("Creating tree structure", maxGenProgress);
        }
    }

    public synchronized void updateGenProgress() {
        try {
            long sum = 0L;
            int i = 0;
            while (i < this.trunks.size()) {
                StemImpl trunk = (StemImpl)this.trunks.elementAt(i);
                sum = trunk.substems != null ? (sum += (long)(trunk.segments.size() * (trunk.substems.size() + 1))) : (sum += (long)trunk.segments.size());
                ++i;
            }
            if (sum - this.genProgress > this.progress.getMaxProgress() / 100L) {
                this.genProgress = sum;
                this.progress.setProgress(this.genProgress);
            }
        }
        catch (Exception e) {
            System.err.println(e);
        }
    }
}

