/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.arbaro.tree;

import java.io.InputStream;
import java.io.PrintWriter;
import java.util.TreeMap;
import net.sourceforge.arbaro.export.Console;
import net.sourceforge.arbaro.export.Progress;
import net.sourceforge.arbaro.params.AbstractParam;
import net.sourceforge.arbaro.params.Params;
import net.sourceforge.arbaro.tree.Tree;
import net.sourceforge.arbaro.tree.TreeGenerator;

public class ShieldedTreeGenerator
implements TreeGenerator {
    TreeGenerator treeGenerator;

    public ShieldedTreeGenerator(TreeGenerator treeGenerator) {
        this.treeGenerator = treeGenerator;
    }

    protected void showException(Exception e) {
        Console.errorOutput("Error in tree generator:");
        Console.printException(e);
    }

    public void clearParams() {
        try {
            this.treeGenerator.clearParams();
        }
        catch (Exception e) {
            this.showException(e);
        }
    }

    public AbstractParam getParam(String param) {
        try {
            return this.treeGenerator.getParam(param);
        }
        catch (Exception e) {
            this.showException(e);
            return null;
        }
    }

    public TreeMap getParamGroup(int level, String group) {
        try {
            return this.treeGenerator.getParamGroup(level, group);
        }
        catch (Exception e) {
            this.showException(e);
            return null;
        }
    }

    public Params getParams() {
        try {
            return this.treeGenerator.getParams();
        }
        catch (Exception e) {
            this.showException(e);
            return null;
        }
    }

    public int getSeed() {
        try {
            return this.treeGenerator.getSeed();
        }
        catch (Exception e) {
            this.showException(e);
            return 13;
        }
    }

    public Tree makeTree(Progress progress) {
        try {
            return this.treeGenerator.makeTree(progress);
        }
        catch (Exception e) {
            this.showException(e);
            return null;
        }
    }

    public void readParamsFromCfg(InputStream is) {
        try {
            this.treeGenerator.readParamsFromCfg(is);
        }
        catch (Exception e) {
            this.showException(e);
        }
    }

    public void readParamsFromXML(InputStream is) {
        try {
            this.treeGenerator.readParamsFromXML(is);
        }
        catch (Exception e) {
            this.showException(e);
        }
    }

    public void setParam(String param, String value) {
        try {
            this.treeGenerator.setParam(param, value);
        }
        catch (Exception e) {
            this.showException(e);
        }
    }

    public void setSeed(int seed) {
        try {
            this.treeGenerator.setSeed(seed);
        }
        catch (Exception e) {
            this.showException(e);
        }
    }

    public void writeParamsToXML(PrintWriter out) {
        try {
            this.treeGenerator.writeParamsToXML(out);
        }
        catch (Exception e) {
            this.showException(e);
        }
    }
}

