/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.arbaro.params;

import java.io.InputStream;
import java.io.PrintWriter;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.TreeMap;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.EventListenerList;
import net.sourceforge.arbaro.export.Console;
import net.sourceforge.arbaro.params.AbstractParam;
import net.sourceforge.arbaro.params.CfgTreeParser;
import net.sourceforge.arbaro.params.FloatParam;
import net.sourceforge.arbaro.params.IntParam;
import net.sourceforge.arbaro.params.LeafShapeParam;
import net.sourceforge.arbaro.params.LevelParams;
import net.sourceforge.arbaro.params.ParamException;
import net.sourceforge.arbaro.params.Random;
import net.sourceforge.arbaro.params.ShapeParam;
import net.sourceforge.arbaro.params.StringParam;
import net.sourceforge.arbaro.params.XMLTreeParser;
import org.xml.sax.InputSource;

public class Params {
    public static final int CONICAL = 0;
    public static final int SPHERICAL = 1;
    public static final int HEMISPHERICAL = 2;
    public static final int CYLINDRICAL = 3;
    public static final int TAPERED_CYLINDRICAL = 4;
    public static final int FLAME = 5;
    public static final int INVERSE_CONICAL = 6;
    public static final int TEND_FLAME = 7;
    public static final int ENVELOPE = 8;
    public double leavesErrorValue;
    protected LevelParams[] levelParams;
    public Random random;
    Hashtable paramDB;
    public boolean preview = false;
    public boolean ignoreVParams;
    public int stopLevel;
    public String Species;
    public double LeafQuality;
    public double Smooth;
    public double mesh_quality;
    public int smooth_mesh_level;
    public int Levels;
    public double Ratio;
    public double RatioPower;
    public int Shape;
    public double BaseSize;
    public double Flare;
    public int Lobes;
    public double LobeDepth;
    public int Leaves;
    public String LeafShape;
    public double LeafScale;
    public double LeafScaleX;
    public double LeafStemLen;
    public double LeafBend;
    public int LeafDistrib;
    public double Scale;
    public double ScaleV;
    public double _0Scale;
    public double _0ScaleV;
    public double AttractionUp;
    public double PruneRatio;
    public double PrunePowerLow;
    public double PrunePowerHigh;
    public double PruneWidth;
    public double PruneWidthPeak;
    public int _0BaseSplits;
    public double scale_tree;
    protected ChangeEvent changeEvent = null;
    protected EventListenerList listenerList = new EventListenerList();
    int order;
    static /* synthetic */ Class class$0;

    public Params() {
        this.ignoreVParams = false;
        this.stopLevel = -1;
        this.Species = "default";
        this.LeafQuality = 1.0;
        this.Smooth = 0.5;
        this.paramDB = new Hashtable();
        this.levelParams = new LevelParams[4];
        int l = 0;
        while (l < 4) {
            this.levelParams[l] = new LevelParams(l, this.paramDB);
            ++l;
        }
        this.registerParams();
    }

    public Params(Params other) {
        this.ignoreVParams = other.ignoreVParams;
        this.stopLevel = other.stopLevel;
        this.Species = other.Species;
        this.Smooth = other.Smooth;
        this.paramDB = new Hashtable();
        this.levelParams = new LevelParams[4];
        int l = 0;
        while (l < 4) {
            this.levelParams[l] = new LevelParams(l, this.paramDB);
            ++l;
        }
        this.registerParams();
        Enumeration e = this.paramDB.elements();
        while (e.hasMoreElements()) {
            AbstractParam p = (AbstractParam)e.nextElement();
            try {
                AbstractParam otherParam = other.getParam(p.name);
                if (otherParam.empty()) continue;
                p.setValue(otherParam.getValue());
            }
            catch (ParamException err) {
                Console.errorOutput("Error copying params: " + err.getMessage());
            }
        }
    }

    public LevelParams getLevelParams(int stemlevel) {
        return this.levelParams[Math.min(stemlevel, 3)];
    }

    public void setSpecies(String sp) {
        this.Species = sp;
        this.fireStateChanged();
    }

    public String getSpecies() {
        return this.Species;
    }

    private void writeParamXML(PrintWriter w, String name, int value) {
        w.println("    <param name='" + name + "' value='" + value + "'/>");
    }

    private void writeParamXML(PrintWriter w, String name, double value) {
        w.println("    <param name='" + name + "' value='" + value + "'/>");
    }

    private void writeParamXML(PrintWriter w, String name, String value) {
        w.println("    <param name='" + name + "' value='" + value + "'/>");
    }

    public void toXML(PrintWriter w) {
        this.fromDB();
        w.println("<?xml version='1.0' ?>");
        w.println();
        w.println("<arbaro>");
        w.println("  <species name='" + this.Species + "'>");
        w.println("    <!-- general params -->");
        this.writeParamXML(w, "Shape", this.Shape);
        this.writeParamXML(w, "Levels", this.Levels);
        this.writeParamXML(w, "Scale", this.Scale);
        this.writeParamXML(w, "ScaleV", this.ScaleV);
        this.writeParamXML(w, "BaseSize", this.BaseSize);
        this.writeParamXML(w, "Ratio", this.Ratio);
        this.writeParamXML(w, "RatioPower", this.RatioPower);
        this.writeParamXML(w, "Flare", this.Flare);
        this.writeParamXML(w, "Lobes", this.Lobes);
        this.writeParamXML(w, "LobeDepth", this.LobeDepth);
        this.writeParamXML(w, "Smooth", this.Smooth);
        this.writeParamXML(w, "Leaves", this.Leaves);
        this.writeParamXML(w, "LeafShape", this.LeafShape);
        this.writeParamXML(w, "LeafScale", this.LeafScale);
        this.writeParamXML(w, "LeafScaleX", this.LeafScaleX);
        this.writeParamXML(w, "LeafQuality", this.LeafQuality);
        this.writeParamXML(w, "LeafStemLen", this.LeafStemLen);
        this.writeParamXML(w, "LeafDistrib", this.LeafDistrib);
        this.writeParamXML(w, "LeafBend", this.LeafBend);
        this.writeParamXML(w, "AttractionUp", this.AttractionUp);
        this.writeParamXML(w, "PruneRatio", this.PruneRatio);
        this.writeParamXML(w, "PrunePowerLow", this.PrunePowerLow);
        this.writeParamXML(w, "PrunePowerHigh", this.PrunePowerHigh);
        this.writeParamXML(w, "PruneWidth", this.PruneWidth);
        this.writeParamXML(w, "PruneWidthPeak", this.PruneWidthPeak);
        this.writeParamXML(w, "0Scale", this._0Scale);
        this.writeParamXML(w, "0ScaleV", this._0ScaleV);
        this.writeParamXML(w, "0BaseSplits", this._0BaseSplits);
        int i = 0;
        while (i <= Math.min(this.Levels, 3)) {
            this.levelParams[i].toXML(w, i == this.Levels);
            ++i;
        }
        w.println("  </species>");
        w.println("</arbaro>");
        w.flush();
    }

    public void clearParams() {
        Enumeration e = this.paramDB.elements();
        while (e.hasMoreElements()) {
            ((AbstractParam)e.nextElement()).clear();
        }
    }

    private int getIntParam(String name) throws ParamException {
        IntParam par = (IntParam)this.paramDB.get(name);
        if (par != null) {
            return par.intValue();
        }
        throw new ParamException("bug: param " + name + " not found!");
    }

    private double getDblParam(String name) {
        FloatParam par = (FloatParam)this.paramDB.get(name);
        if (par != null) {
            return par.doubleValue();
        }
        throw new ParamException("bug: param " + name + " not found!");
    }

    private String getStrParam(String name) throws ParamException {
        StringParam par = (StringParam)this.paramDB.get(name);
        if (par != null) {
            return par.getValue();
        }
        throw new ParamException("bug: param " + name + " not found!");
    }

    void fromDB() {
        this.LeafQuality = this.getDblParam("LeafQuality");
        this.Smooth = this.getDblParam("Smooth");
        this.Levels = this.getIntParam("Levels");
        this.Ratio = this.getDblParam("Ratio");
        this.RatioPower = this.getDblParam("RatioPower");
        this.Shape = this.getIntParam("Shape");
        this.BaseSize = this.getDblParam("BaseSize");
        this.Flare = this.getDblParam("Flare");
        this.Lobes = this.getIntParam("Lobes");
        this.LobeDepth = this.getDblParam("LobeDepth");
        this.Leaves = this.getIntParam("Leaves");
        this.LeafShape = this.getStrParam("LeafShape");
        this.LeafScale = this.getDblParam("LeafScale");
        this.LeafScaleX = this.getDblParam("LeafScaleX");
        this.LeafStemLen = this.getDblParam("LeafStemLen");
        this.LeafDistrib = this.getIntParam("LeafDistrib");
        this.LeafBend = this.getDblParam("LeafBend");
        this.Scale = this.getDblParam("Scale");
        this.ScaleV = this.getDblParam("ScaleV");
        this._0Scale = this.getDblParam("0Scale");
        this._0ScaleV = this.getDblParam("0ScaleV");
        this.AttractionUp = this.getDblParam("AttractionUp");
        this.PruneRatio = this.getDblParam("PruneRatio");
        this.PrunePowerLow = this.getDblParam("PrunePowerLow");
        this.PrunePowerHigh = this.getDblParam("PrunePowerHigh");
        this.PruneWidth = this.getDblParam("PruneWidth");
        this.PruneWidthPeak = this.getDblParam("PruneWidthPeak");
        this._0BaseSplits = this.getIntParam("0BaseSplits");
        this.Species = this.getStrParam("Species");
        int i = 0;
        while (i <= Math.min(this.Levels, 3)) {
            this.levelParams[i].fromDB(i == this.Levels);
            ++i;
        }
    }

    public void prepare(int seed) throws ParamException {
        LevelParams lp;
        this.fromDB();
        if (this.ignoreVParams) {
            this.ScaleV = 0.0;
            int i = 1;
            while (i < 4) {
                lp = this.levelParams[i];
                lp.nCurveV = 0.0;
                lp.nLengthV = 0.0;
                lp.nSplitAngleV = 0.0;
                lp.nRotateV = 0.0;
                if (lp.nDownAngle > 0.0) {
                    lp.nDownAngle = 0.0;
                }
                ++i;
            }
        }
        int l = 0;
        while (l < Math.min(this.Levels, 4)) {
            lp = this.levelParams[l];
            if (lp.nSegSplits > 0.0 && lp.nSplitAngle == 0.0) {
                throw new ParamException("nSplitAngle may not be 0.");
            }
            ++l;
        }
        long l2 = this.levelParams[0].initRandom(seed);
        int i = 1;
        while (i < 4) {
            l2 = this.levelParams[i].initRandom(l2);
            ++i;
        }
        this.random = new Random(seed);
        this.smooth_mesh_level = this.Smooth <= 0.2 ? -1 : (int)((double)this.Levels * this.Smooth);
        this.mesh_quality = this.Smooth;
        this.levelParams[0].mesh_points = 4;
        this.levelParams[1].mesh_points = 3;
        this.levelParams[2].mesh_points = 2;
        this.levelParams[3].mesh_points = 1;
        if (this.Lobes > 0) {
            this.levelParams[0].mesh_points = (int)((double)this.Lobes * Math.pow(2.0, (int)(1.0 + 2.5 * this.mesh_quality)));
            this.levelParams[0].mesh_points = Math.max(this.levelParams[0].mesh_points, (int)(4.0 * (1.0 + 2.0 * this.mesh_quality)));
        }
        i = 1;
        while (i < 4) {
            this.levelParams[i].mesh_points = Math.max(3, (int)((double)this.levelParams[i].mesh_points * (1.0 + 1.5 * this.mesh_quality)));
            ++i;
        }
        if (this.stopLevel >= 0 && this.stopLevel <= this.Levels) {
            this.Levels = this.stopLevel;
            this.Leaves = 0;
        }
        this.scale_tree = this.Scale + this.levelParams[0].random.uniform(-this.ScaleV, this.ScaleV);
    }

    public double getShapeRatio(double ratio) {
        return this.getShapeRatio(ratio, this.Shape);
    }

    public double getShapeRatio(double ratio, int shape) {
        switch (shape) {
            case 0: {
                return ratio;
            }
            case 1: {
                return 0.2 + 0.8 * Math.sin(Math.PI * ratio);
            }
            case 2: {
                return 0.2 + 0.8 * Math.sin(1.5707963267948966 * ratio);
            }
            case 3: {
                return 1.0;
            }
            case 4: {
                return 0.5 + 0.5 * ratio;
            }
            case 5: {
                return ratio <= 0.7 ? ratio / 0.7 : (1.0 - ratio) / 0.3;
            }
            case 6: {
                return 1.0 - 0.8 * ratio;
            }
            case 7: {
                return ratio <= 0.7 ? 0.5 + 0.5 * ratio / 0.7 : 0.5 + 0.5 * (1.0 - ratio) / 0.3;
            }
            case 8: {
                if (ratio < 0.0 || ratio > 1.0) {
                    return 0.0;
                }
                if (ratio < 1.0 - this.PruneWidthPeak) {
                    return Math.pow(ratio / (1.0 - this.PruneWidthPeak), this.PrunePowerHigh);
                }
                return Math.pow((1.0 - ratio) / (1.0 - this.PruneWidthPeak), this.PrunePowerLow);
            }
        }
        return 0.0;
    }

    public void setParam(String name, String value) throws ParamException {
        AbstractParam p = (AbstractParam)this.paramDB.get(name);
        if (p == null) {
            throw new ParamException("Unknown parameter " + name + "!");
        }
        p.setValue(value);
    }

    public TreeMap getParamGroup(int level, String group) {
        TreeMap<Integer, AbstractParam> result = new TreeMap<Integer, AbstractParam>();
        Enumeration e = this.paramDB.elements();
        while (e.hasMoreElements()) {
            AbstractParam p = (AbstractParam)e.nextElement();
            if (p.getLevel() != level || !p.getGroup().equals(group)) continue;
            result.put(new Integer(p.getOrder()), p);
        }
        return result;
    }

    private void intParam(String name, int min, int max, int deflt, String group, String short_desc, String long_desc) {
        this.paramDB.put(name, new IntParam(name, min, max, deflt, group, -999, this.order++, short_desc, long_desc));
    }

    private void shapeParam(String name, int min, int max, int deflt, String group, String short_desc, String long_desc) {
        this.paramDB.put(name, new ShapeParam(name, min, max, deflt, group, -999, this.order++, short_desc, long_desc));
    }

    private void int4Param(String name, int min, int max, int deflt0, int deflt1, int deflt2, int deflt3, String group, String short_desc, String long_desc) {
        int[] deflt = new int[]{deflt0, deflt1, deflt2, deflt3};
        ++this.order;
        int i = 0;
        while (i < 4) {
            String fullname = i + name.substring(1);
            this.paramDB.put(fullname, new IntParam(fullname, min, max, deflt[i], group, i, this.order, short_desc, long_desc));
            ++i;
        }
    }

    private void dblParam(String name, double min, double max, double deflt, String group, String short_desc, String long_desc) {
        this.paramDB.put(name, new FloatParam(name, min, max, deflt, group, -999, this.order++, short_desc, long_desc));
    }

    private void dbl4Param(String name, double min, double max, double deflt0, double deflt1, double deflt2, double deflt3, String group, String short_desc, String long_desc) {
        double[] deflt = new double[]{deflt0, deflt1, deflt2, deflt3};
        ++this.order;
        int i = 0;
        while (i < 4) {
            String fullname = i + name.substring(1);
            this.paramDB.put(fullname, new FloatParam(fullname, min, max, deflt[i], group, i, this.order, short_desc, long_desc));
            ++i;
        }
    }

    private void lshParam(String name, String deflt, String group, String short_desc, String long_desc) {
        this.paramDB.put(name, new LeafShapeParam(name, deflt, group, -999, this.order++, short_desc, long_desc));
    }

    private void strParam(String name, String deflt, String group, String short_desc, String long_desc) {
        this.paramDB.put(name, new StringParam(name, deflt, group, -999, this.order++, short_desc, long_desc));
    }

    private void registerParams() {
        this.order = 1;
        this.strParam("Species", "default", "SHAPE", "the tree's species", "<strong>Species</strong> is the kind of tree.<br>\nIt is used for declarations in the output file.<br>\n");
        this.shapeParam("Shape", 0, 8, 0, "SHAPE", "general tree shape id", "The <strong>Shape</strong> can be one of:<ul>\n<li>0 - conical</li>\n<li>1 - spherical</li>\n<li>2 - hemispherical</li>\n<li>3 - cylindrical</li>\n<li>4 - tapered cylindrical</li>\n<li>5 - flame</li>\n<li>6 - inverse conical</li>\n<li>7 - tend flame</li>\n<li>8 - envelope - uses pruning envelope<br>\n(see PruneWidth, PruneWidthPeak, PrunePowerLow, PrunePowerHigh)</li></ul>\n");
        this.intParam("Levels", 0, 9, 3, "SHAPE", "levels of recursion", "<strong>Levels</strong> are the levels of recursion when creating the\nstems of the tree.<ul>\n<li>Levels=1 means the tree consist only of the (may be splitting) trunk</li>\n<li>Levels=2 the tree consist of the trunk with one level of branches</li>\n<li>Levels>4 seldom necessary, the parameters of the forth level are used\nfor all higher levels.</li></ul>\nLeaves are considered to be one level above the last stem level.<br>\nand uses it's down and rotation angles.\n");
        this.dblParam("Scale", 1.0E-6, Double.POSITIVE_INFINITY, 10.0, "SHAPE", "average tree size in meters", "<strong>Scale</strong> is the average tree size in meters.<br>\nWith Scale = 10.0 and ScaleV = 2.0 trees of this species\nreach from 8.0 to 12.0 meters.<br>\nNote, that the trunk length can be different from the tree size.\n(See 0Length and 0LengthV)\n");
        this.dblParam("ScaleV", 0.0, Double.POSITIVE_INFINITY, 0.0, "SHAPE", "variation of tree size in meters", "<strong>ScaleV</strong> is the variation range of the tree size in meters.<br>\nScale = 10.0, ScaleV = 2.0 means trees of this species\nreach from 8.0 to 12.0 meters.\n(See Scale)\n");
        this.dblParam("BaseSize", 0.0, 1.0, 0.25, "SHAPE", "fractional branchless area at tree base", "<strong>BaseSize</strong> is the fractional branchless part of the trunk. E.g.\n<ul><li>BaseSize=&nbsp;&nbsp;0</code> means branches begin on the bottom of the tree,</li>\n<li>BaseSize=0.5</code> means half of the trunk is branchless,</li>\n<li>BaseSize=1.0</code> branches grow out from the peak of the trunk only.</li></ul>\n");
        this.intParam("0BaseSplits", 0, Integer.MAX_VALUE, 0, "SHAPE", "stem splits at base of trunk", "<strong>BaseSplits</strong> are the stem splits at the top of the first trunk segment.<br>\nSo with BaseSplits=2 you get a trunk splitting into three parts. Other then<br>\nwith 0SegSplits the clones are evenly distributed over<br>\nthe 360&deg;. So, if you want to use splitting, you should<br>\nuse BaseSplits for the first splitting to get a circular<br>\nstem distribution (seen from top).<br>\n");
        this.dblParam("Ratio", 1.0E-6, Double.POSITIVE_INFINITY, 0.05, "TRUNK", "trunk radius/length ratio", "<strong>Ratio</strong> is the radius/length ratio of the trunk.<br>\nRatio=0.05 means the trunk is 1/20 as thick as it is long,<br>\nt.e. a 10m long trunk has a base radius of 50cm.<br>\nNote, that the real base radius could be greater, when Flare<br>\nand/or Lobes are used. (See Flare, Lobes, LobesDepth, RatioPower)\n");
        this.dblParam("RatioPower", Double.NEGATIVE_INFINITY, Double.POSITIVE_INFINITY, 1.0, "SHAPE", "radius reduction", "<strong>RatioPower</strong> is a reduction value for the radius of the\nsubstems.\n<ul><li>RatioPower=1.0  means the radius decreases linearly with\ndecreasing stem length</li>\n<li>RatioPower=2.0  means it decreases with the second power</li>\n<li>RatioPower=0.0  means radius is the same as parent radius\n(t.e. it doesn't depend of the length)</li>\n<li>RatioPower=-1.0 means the shorter the stem the thicker it is\n(radius = parent radius * 1 / length)</li></ul>\nNote, that the radius of a stem cannot be greater then the parent radius at the stem offset.<br>\nSo with negative RatioPower you cannot create stems thicker than it's parent.<br>\nInstead you can use it to make stems thinner, which are longer than it's parent.<br>\n(See Ratio)\n");
        this.dblParam("Flare", -1.0, Double.POSITIVE_INFINITY, 0.5, "TRUNK", "exponential expansion at base of tree", "<strong>Flare</strong> makes the trunk base thicker.<ul>\n<li>Flare = 0.0 means base radius is used at trunk base</li>\n<li>Flare = 1.0 means trunk base is twice as thick as it's base radius\n(See Ratio)</li></ul>\nNote, that using Lobes make the trunk base thicker too.\n(See Lobes, LobeDepth)\n");
        this.intParam("Lobes", 0, Integer.MAX_VALUE, 0, "TRUNK", "sinusoidal cross-section variation", "With <strong>Lobes</strong> you define how much lobes (this are variations in it's<br>\ncross-section) the trunk will have. This isn't supported for<br>\ncones output, but for mesh only.<br>\n(See LobeDepth too)\n");
        this.dblParam("LobeDepth", 0.0, Double.POSITIVE_INFINITY, 0.0, "TRUNK", "amplitude of cross-section variation", "<strong>LobeDepth</strong> defines, how deep the lobes of the trunk will be.<br>\nThis is the amplitude of the sinusoidal cross-section variations.<br>\n(See Lobes)\n");
        this.intParam("Leaves", Integer.MIN_VALUE, Integer.MAX_VALUE, 0, "LEAVES", "number of leaves per stem", "<strong>Leaves</strong> gives the maximal number of leaves per stem.<br>\nLeaves grow only from stems of the last level. The actual number of leaves on a stem,<br>\ndepending on the stem offset and length, can be smaller than Leaves.<br>\nWhen Leaves is negative, the leaves grow in a fan at\nthe end of the stem.\n");
        this.lshParam("LeafShape", "0", "LEAVES", "leaf shape id", "<strong>LeafShape</strong> is the shape of the leaf (\"0\" means oval shape).<br>\nThe length and width of the leaf are given by LeafScale and LeafScaleX.<br>\nWhen creating a mesh at the moment you can use the following values:<ul>\n<li>\"disc\" - a surface consisting of 6 triangles approximating an oval shape</li>\n<li>\"sphere\" - an ikosaeder approximating a shperical shape,<br>\nuseful for making knots or seeds instead of leaves, or for high quality needles</li>\n<li>\"disc1\", \"disc2\", ... - a surface consisting of 1, 2, ... triangles approximating an oval shape<br>\nlower values are useful for low quality needles or leaves, to reduce mesh size,<br>\nvalues between 6 and 10 are quite good for big, round leaves.</li>\n<li>any other - same like disc</li></ul>\nWhen using primitives output, the possible values of LeafShape references<br>\nthe declarations in arbaro.inc. At the moment there are:<ul>\n<li>\"disc\" the standard oval form of a leaf, defined<br>\nas a unit circle of radius 0.5m. The real<br>\nlength and width are given by the LeafScale parameters.</li>\n<li>\"sphere\" a spherical form, you can use to<br>\nsimulate seeds on herbs or knots on branches like in the<br>\ndesert bush. You can use the sphere shape for needles too,<br>\nthus they are visible from all sides</li>\n<li>\"palm\" a palm leaf, this are two disc halfs put together<br>\nwith an angle between them. So they are visible<br>\nalso from the side and the light effects are<br>\nmore typically, especialy for fan palms seen from small distances.</li>\n<li>any other - add your own leaf shape to the file arbaro.inc</li></ul>\n");
        this.dblParam("LeafScale", 1.0E-6, Double.POSITIVE_INFINITY, 0.2, "LEAVES", "leaf length", "<strong>LeafScale</strong> is the length of the leaf in meters.<br>\nThe unit leaf is scaled in z-direction (y-direction in Povray)\nby this factor. (See LeafShape, LeafScaleX)\n");
        this.dblParam("LeafScaleX", 1.0E-6, Double.POSITIVE_INFINITY, 0.5, "LEAVES", "fractional leaf width", "<strong>LeafScaleX</strong> is the fractional width of the leaf relativly to it's length. So<ul>\n<li>LeafScaleX=0.5 means the leaf is half as wide as long</li>\n<li>LeafScaleX=1.0 means the leaf is like a circle</li></ul>\nThe unit leaf is scaled by LeafScale*LeafScaleX in x- and\ny-direction (x- and z-direction in Povray).<br>\nSo the spherical leaf is transformed to a needle 5cm long and<br>\n1mm wide by LeafScale=0.05 and LeafScaleX=0.02.\n");
        this.dblParam("LeafBend", 0.0, 1.0, 0.3, "LEAVES", "leaf orientation toward light", "With <strong>LeafBend</strong> you can influence, how much leaves are oriented<br>\noutside and upwards.<br>Values near 0.5 are good. For low values the leaves<br>\nare oriented to the stem, for high value to the light.<br>\nFor trees with long leaves like palms you should use lower values.\n");
        this.dblParam("LeafStemLen", Double.NEGATIVE_INFINITY, Double.POSITIVE_INFINITY, 0.5, "LEAVES", "fractional leaf stem length", "<strong>LeafStemLen</strong is the length of the (virtual) leaf stem.<br>\nIt's not drawn, so this is the distance between the stem<br>\naxis and the leaf. For normal trees with many nearly circular<br>\nleaves the default value of 0.5 (meaning the stem has half of the length<br>\nof the leaf) is quite good. For other trees like palms with long leaves<br>\nor some herbs you need a LeafStemLen near 0. Negative stem length is<br>\nallowed for special cases.");
        this.intParam("LeafDistrib", 0, 8, 4, "LEAVES", "leaf distribution", "<strong>LeafDistrib</strong> determines how leaves are distributed over<br>\nthe branches of the last but one stem level. It takes the same<br>\nvalues like Shape, meaning 3 = even distribution, 0 = most leaves<br>\noutside. Default is 4 (some inside, more outside).");
        this.dblParam("LeafQuality", 1.0E-6, 1.0, 1.0, "QUALITY", "leaf quality/leaf count reduction", "With a <strong>LeafQuality</strong> less then 1.0 you can reduce the number of leaves<br>\nto improve rendering speed and memory usage. The leaves are scaled<br>\nwith the same amount to get the same coverage.<br>\nFor trees in the background of the scene you will use a reduced<br>\nLeafQuality around 0.9. Very small values would cause strange results.<br>\n(See LeafScale)");
        this.dblParam("Smooth", 0.0, 1.0, 0.5, "QUALITY", "smooth value for mesh creation", "Higher <strong>Smooth</strong> values creates meshes with more vertices and<br>\nadds normal vectors to them for some or all branching levels.<br>\nNormally you would specify this value on the command line or in<br>\nthe rendering dialog, but for some species a special default<br>\nsmooth value could be best. E.g. for shave-grass a low smooth value<br>\nis preferable, because this herb has angular stems.");
        this.dblParam("AttractionUp", Double.NEGATIVE_INFINITY, Double.POSITIVE_INFINITY, 0.0, "SHAPE", "upward/downward growth tendency", "<strong>AttractionUp</strong> is the tendency of stems with level>=2 to grow upwards<br>\n(downwards for negative values).<br>\nA value of 1.0 for a horizontal stem means the last segment should point upwards.<br>\nGreater values means earlier reaching of upward direction. Values of 10 and greater<br>\ncould cause overcorrection resulting in a snaking oscillation.<br>\nAs an example see the weeping willow, which has a negative AttractionUp value.\n");
        this.dblParam("PruneRatio", 0.0, 1.0, 0.0, "PRUNING", "fractional effect of pruning", "A <strong>PruneRatio</strong> of 1.0 means all branches are inside<br>\nthe envelope. 0.0 means no pruning.\n");
        this.dblParam("PruneWidth", 0.0, 1.0, 0.5, "PRUNING", "width of envelope peak", "<strong>PruneWidth</strong> is the fractional width of the pruning envelope at the<br>\npeak. A value of 0.5 means the tree is half as wide as high.<br>\nThis parameter is used for the shape \"envelope\" too, even if PruneRatio is off.\n");
        this.dblParam("PruneWidthPeak", 0.0, 1.0, 0.5, "PRUNING", "position of envelope peak", "<strong>PruneWidthPeak</strong> is the fractional height of the envelope peak.<br>\nA value of 0.5 means upper part and lower part of the envelope have the same height.<br>\nThis parameter is used for the shape \"envelope\" too, even if PruneRatio is off.\n");
        this.dblParam("PrunePowerLow", 0.0, Double.POSITIVE_INFINITY, 0.5, "PRUNING", "curvature of envelope", "<strong>PrunePowerLow</strong> describes the envelope curve below the peak.<br>\nA value of 1 means linear decreasing. Higher values means concave,<br>\nlower values convex curve.<br>\nThis parameter is used for the shape \"envelope\" too, even if PruneRatio is off.\n");
        this.dblParam("PrunePowerHigh", 0.0, Double.POSITIVE_INFINITY, 0.5, "PRUNING", "curvature of envelope", "<strong>PrunePowerHigh</strong> describes the envelope curve above the peak.<br>\nA value of 1 means linear decreasing. Higher values means concave,<br>\nlower values convex curve.<br>\nThis parameter is used for the shape \"envelope\" too, even if PruneRatio is off.\n");
        this.dblParam("0Scale", 1.0E-6, Double.POSITIVE_INFINITY, 1.0, "TRUNK", "extra trunk scaling", "<strong>0Scale</strong> and 0ScaleV makes the trunk thicker.<br>\nThis parameters exists for the level 0 only. From the Weber/Penn paper it is<br>\nnot clear, why there are two trunk scaling parameters<br> \n0Scale and Ratio. See Ratio, 0ScaleV, Scale, ScaleV.<br>\nIn this implementation 0Scale does not influence the trunk base radius<br>\nbut is applied finally to the stem radius formular. Thus the<br>\ntrunk radius could be influenced independently from the<br>\nRatio/RatioPower parameters and the periodic tapering (0Taper > 2.0)<br>\ncould be scaled, so that the sections are elongated spheres.\n");
        this.dblParam("0ScaleV", 0.0, Double.POSITIVE_INFINITY, 0.0, "TRUNK", "variation for extra trunk scaling", "0Scale and <strong>0ScaleV</strong> makes the trunk thicker. This parameters<br>\nexists for the level 0 only. From the Weber/Penn paper it is<br>\nnot clear, why there are two trunk scaling parameters<br>\n0Scale and Ratio. See Ratio, 0ScaleV, Scale, ScaleV.<br>\nIn this implementation 0ScaleV is used to perturb the<br>\nmesh of the trunk. But use with care, because the mesh<br>\ncould got fissures when using too big values.<br>\n");
        this.dbl4Param("nLength", 1.0E-7, Double.POSITIVE_INFINITY, 1.0, 0.5, 0.5, 0.5, "LENTAPER", "fractional trunk scaling", "<strong>0Length</strong> and 0LengthV give the fractional length of the<br>\ntrunk. So with Scale=10 and 0Length=0.8 the length of the<br>\ntrunk will be 8m. Dont' confuse the height of the tree with<br>\nthe length of the trunk here.<br><br>\n<strong>nLength</strong> and nLengthV define the fractional length of a stem<br>\nrelating to the length of theire parent.<br>\n");
        this.dbl4Param("nLengthV", 0.0, Double.POSITIVE_INFINITY, 0.0, 0.0, 0.0, 0.0, "LENTAPER", "variation of fractional trunk scaling", "<strong>nLengthV</strong> is the variation of the length given by nLength.<br>\n");
        this.dbl4Param("nTaper", 0.0, 2.99999999, 1.0, 1.0, 1.0, 1.0, "LENTAPER", "cross-section scaling", "<strong>nTaper</strong> is the tapering of the stem along its length.<ul>\n<li>0 - non-tapering cylinder</li>\n<li>1 - taper to a point (cone)</li>\n<li>2 - taper to a spherical end</li>\n<li>3 - periodic tapering (concatenated spheres)</li></ul>\nYou can use fractional values, to get intermediate results.<br>\n");
        this.dbl4Param("nSegSplits", 0.0, Double.POSITIVE_INFINITY, 0.0, 0.0, 0.0, 0.0, "SPLITTING", "stem splits per segment", "<strong>nSegSplits</strong> determines how much splits per segment occures.<br><br>\nNormally you would use a value between 0.0 and 1.0. A value of<br>\n0.5 means a split at every second segment. If you use splitting<br>\nfor the trunk you should use 0BaseSplits for the first split, <br>\notherwise the tree will tend to one side.");
        this.dbl4Param("nSplitAngle", 0.0, 180.0, 0.0, 0.0, 0.0, 0.0, "SPLITTING", "splitting angle", "<strong>nSplitAngle</strong> is the vertical splitting angle. A horizontal diverging<br>\nangle will be added too, but this one you cannot influence with parameters.<br>\nThe declination of the splitting branches won't exceed the splitting angle.<br>\n");
        this.dbl4Param("nSplitAngleV", 0.0, 180.0, 0.0, 0.0, 0.0, 0.0, "SPLITTING", "splitting angle variation", "<strong>nSplitAngleV</strong> is the variation of the splitting angle. See nSplitAngle.<br>\n");
        this.int4Param("nCurveRes", 1, Integer.MAX_VALUE, 3, 3, 1, 1, "CURVATURE", "curvature resolution", "<strong>nCurveRes</strong> determines how many segments the branches consist of.<br><br>\nNormally you will use higher values for the first levels, and low<br>\nvalues for the higher levels.<br>\n");
        this.dbl4Param("nCurve", Double.NEGATIVE_INFINITY, Double.POSITIVE_INFINITY, 0.0, 0.0, 0.0, 0.0, "CURVATURE", "curving angle", "<strong>nCurve</strong> is the angle the branches are declined over theire whole length.<br>\nIf nCurveBack is used, the curving angle is distributed only over the<br>\nfirst half of the stem.<br>\n");
        this.dbl4Param("nCurveV", -90.0, Double.POSITIVE_INFINITY, 0.0, 0.0, 0.0, 0.0, "CURVATURE", "curving angle variation", "<strong>nCurveV</strong> is the variation of the curving angle. See nCurve, nCurveBack.<br>\nA negative value means helical curvature<br>\n");
        this.dbl4Param("nCurveBack", Double.NEGATIVE_INFINITY, Double.POSITIVE_INFINITY, 0.0, 0.0, 0.0, 0.0, "CURVATURE", "curving angle upper stem half", "Using <strong>nCurveBack</strong> you can give the stem an S-like shape.<br>\nThe first half of the stem the nCurve value is applied.<br>\nThe second half the nCurveBack value.<br><br>\nIt's also possible to give both parametera the same sign to<br>\nget different curving over the stem length, instead of a S-shape<br>\n");
        this.dbl4Param("nDownAngle", -179.9999999, 179.999999, 0.0, 30.0, 30.0, 30.0, "BRANCHING", "angle from parent", "<strong>nDownAngle</strong> is the angle between a stem and it's parent.<br>\n");
        this.dbl4Param("nDownAngleV", -179.9999999, 179.9999999, 0.0, 0.0, 0.0, 0.0, "BRANCHING", "down angle variation", "<strong>nDownAngleV</strong> is the variation of the downangle. See nDownAngle.<br>\nUsing a negative value, the nDownAngleV is variated over the<br>\nlength of the stem, so that the lower branches have a bigger<br>\ndownangle then the higher branches.<br>\n");
        this.dbl4Param("nRotate", -360.0, 360.0, 0.0, 120.0, 120.0, 120.0, "BRANCHING", "spiraling angle", "<strong>nRotate</strong> is the angle, the branches are rotating around the parent<br>\nIf nRotate is negative the branches are located on alternating<br>\nsides of the parent.<br>\n");
        this.dbl4Param("nRotateV", -360.0, 360.0, 0.0, 0.0, 0.0, 0.0, "BRANCHING", "spiraling angle variation", "<strong>nRotateV</strong> is the variation of nRotate.<br>\n");
        this.int4Param("nBranches", 0, Integer.MAX_VALUE, 1, 10, 5, 5, "BRANCHING", "number of branches", "<strong>nBranches</strong> is the maximal number of branches on a parent stem.<br>\nThe number of branches are reduced proportional to the<br>\nrelative length of theire parent.<br>\n");
        this.dbl4Param("nBranchDist", 0.0, 1.0, 0.0, 1.0, 1.0, 1.0, "BRANCHING", "branch distribution along the segment", "<strong>nBranchDist</strong> is an additional parameter of Arbaro. It influences the<br>\ndistribution of branches over a segment of the parent stem.<br>\nWith 1.0 you get evenly distribution of branches like in the<br>\noriginal model. With 0.0 all branches grow from the segments<br>\nbase like for conifers.<br>\n");
    }

    public void readFromCfg(InputStream is) {
        CfgTreeParser parser = new CfgTreeParser();
        try {
            parser.parse(is, this);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public void readFromXML(InputStream is) {
        try {
            XMLTreeParser parser = new XMLTreeParser();
            parser.parse(new InputSource(is), this);
        }
        catch (Exception e) {
            throw new ParamException(e.getMessage());
        }
    }

    public AbstractParam getParam(String parname) {
        return (AbstractParam)this.paramDB.get(parname);
    }

    public void addChangeListener(ChangeListener l) {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("javax.swing.event.ChangeListener");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        this.listenerList.add(clazz, l);
    }

    public void removeChangeListener(ChangeListener l) {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("javax.swing.event.ChangeListener");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        this.listenerList.remove(clazz, l);
    }

    protected void fireStateChanged() {
        Object[] listeners = this.listenerList.getListenerList();
        int i = listeners.length - 2;
        while (i >= 0) {
            Object object = listeners[i];
            Class<?> clazz = class$0;
            if (clazz == null) {
                try {
                    clazz = Class.forName("javax.swing.event.ChangeListener");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            if (object == clazz) {
                if (this.changeEvent == null) {
                    this.changeEvent = new ChangeEvent(this);
                }
                ((ChangeListener)listeners[i + 1]).stateChanged(this.changeEvent);
            }
            i -= 2;
        }
    }

    public void enableDisable() {
        boolean enable = ((IntParam)this.getParam("Levels")).intValue() > 1;
        this.getParam("RatioPower").setEnabled(enable);
        this.getParam("Leaves").setEnabled(enable);
        enable = ((IntParam)this.getParam("Leaves")).intValue() != 0 && ((IntParam)this.getParam("Levels")).intValue() > 1;
        this.getParam("LeafShape").setEnabled(enable);
        this.getParam("LeafScale").setEnabled(enable);
        this.getParam("LeafScaleX").setEnabled(enable);
        this.getParam("LeafBend").setEnabled(enable);
        this.getParam("LeafDistrib").setEnabled(enable);
        this.getParam("LeafQuality").setEnabled(enable);
        this.getParam("LeafStemLen").setEnabled(enable);
        enable = ((IntParam)this.getParam("Shape")).intValue() == 8 || ((FloatParam)this.getParam("PruneRatio")).doubleValue() > 0.0;
        this.getParam("PrunePowerHigh").setEnabled(enable);
        this.getParam("PrunePowerLow").setEnabled(enable);
        this.getParam("PruneWidth").setEnabled(enable);
        this.getParam("PruneWidthPeak").setEnabled(enable);
        enable = ((IntParam)this.getParam("Lobes")).intValue() > 0;
        this.getParam("LobeDepth").setEnabled(enable);
        enable = ((IntParam)this.getParam("Levels")).intValue() > 2;
        this.getParam("AttractionUp").setEnabled(enable);
        int i = 0;
        while (i < 4) {
            enable = i < ((IntParam)this.getParam("Levels")).intValue();
            this.getParam(i + "Length").setEnabled(enable);
            this.getParam(i + "LengthV").setEnabled(enable);
            this.getParam(i + "Taper").setEnabled(enable);
            this.getParam(i + "Curve").setEnabled(enable);
            this.getParam(i + "CurveV").setEnabled(enable);
            this.getParam(i + "CurveRes").setEnabled(enable);
            this.getParam(i + "CurveBack").setEnabled(enable);
            this.getParam(i + "SegSplits").setEnabled(enable);
            this.getParam(i + "SplitAngle").setEnabled(enable);
            this.getParam(i + "SplitAngleV").setEnabled(enable);
            this.getParam(i + "BranchDist").setEnabled(enable);
            this.getParam(i + "Branches").setEnabled(enable);
            enable = enable || ((IntParam)this.getParam("Leaves")).intValue() != 0 && i == ((IntParam)this.getParam("Levels")).intValue();
            this.getParam(i + "DownAngle").setEnabled(enable);
            this.getParam(i + "DownAngleV").setEnabled(enable);
            this.getParam(i + "Rotate").setEnabled(enable);
            this.getParam(i + "RotateV").setEnabled(enable);
            ++i;
        }
        i = 0;
        while (i < ((IntParam)this.getParam("Levels")).intValue() && i < 4) {
            enable = ((FloatParam)this.getParam(i + "SegSplits")).doubleValue() > 0.0 || i == 0 && ((IntParam)this.getParam("0BaseSplits")).intValue() > 0;
            this.getParam(i + "SplitAngle").setEnabled(enable);
            this.getParam(i + "SplitAngleV").setEnabled(enable);
            enable = ((IntParam)this.getParam(i + "CurveRes")).intValue() > 1;
            this.getParam(i + "Curve").setEnabled(enable);
            this.getParam(i + "CurveV").setEnabled(enable);
            this.getParam(i + "CurveBack").setEnabled(enable);
            ++i;
        }
    }
}

