/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.arbaro.mesh;

import java.util.Enumeration;
import java.util.NoSuchElementException;
import java.util.Vector;
import net.sourceforge.arbaro.mesh.MeshPart;

public class Mesh
extends Vector {
    private static final long serialVersionUID = 1L;
    final boolean debugMesh = false;
    public int[] firstMeshPart;

    public Mesh(int levels) {
        this.firstMeshPart = new int[levels];
        int i = 0;
        while (i < levels) {
            this.firstMeshPart[i] = -1;
            ++i;
        }
    }

    public void addMeshpart(MeshPart meshpart) {
        this.addElement(meshpart);
        if (this.firstMeshPart[meshpart.stem.getLevel()] < 0) {
            this.firstMeshPart[meshpart.stem.getLevel()] = this.size() - 1;
        }
    }

    public Enumeration allVertices(boolean UVVertices) {
        if (UVVertices) {
            return new UVVertexEnumerator();
        }
        return new VertexEnumerator();
    }

    public Enumeration allFaces(int startIndex, boolean UVFaces, int stemLevel) {
        return new FaceEnumerator(this, startIndex, UVFaces, stemLevel);
    }

    public Enumeration allParts(int stemLevel) {
        return new PartEnumerator(stemLevel);
    }

    public int vertexCount() {
        int cnt = 0;
        int i = 0;
        while (i < this.size()) {
            cnt += ((MeshPart)this.elementAt(i)).vertexCount();
            ++i;
        }
        return cnt;
    }

    public int faceCount() {
        int cnt = 0;
        int i = 0;
        while (i < this.size()) {
            cnt += ((MeshPart)this.elementAt(i)).faceCount();
            ++i;
        }
        return cnt;
    }

    public int uvCount() {
        int cnt = 0;
        int i = 0;
        while (i < this.firstMeshPart.length) {
            cnt += ((MeshPart)this.elementAt(this.firstMeshPart[i])).uvCount();
            ++i;
        }
        return cnt;
    }

    public int firstUVIndex(int level) {
        int cnt = 0;
        int i = 0;
        while (i < level) {
            cnt += ((MeshPart)this.elementAt(this.firstMeshPart[i])).uvCount();
            ++i;
        }
        return cnt;
    }

    private class VertexEnumerator
    implements Enumeration {
        private Enumeration parts;
        private Enumeration partVertices;

        public VertexEnumerator() {
            this.parts = Mesh.this.elements();
            this.partVertices = ((MeshPart)this.parts.nextElement()).allVertices(false);
        }

        public boolean hasMoreElements() {
            if (!this.partVertices.hasMoreElements() && this.parts.hasMoreElements()) {
                this.partVertices = ((MeshPart)this.parts.nextElement()).allVertices(false);
            }
            return this.partVertices.hasMoreElements();
        }

        public Object nextElement() {
            if (!this.partVertices.hasMoreElements() && this.parts.hasMoreElements()) {
                this.partVertices = ((MeshPart)this.parts.nextElement()).allVertices(false);
            }
            return this.partVertices.nextElement();
        }
    }

    private class UVVertexEnumerator
    implements Enumeration {
        private int level = 0;
        private Enumeration partVertices;

        public UVVertexEnumerator() {
            this.partVertices = ((MeshPart)Mesh.this.elementAt(Mesh.this.firstMeshPart[this.level])).allVertices(true);
        }

        public boolean hasMoreElements() {
            if (!this.partVertices.hasMoreElements() && ++this.level < Mesh.this.firstMeshPart.length && Mesh.this.firstMeshPart[this.level] > 0) {
                this.partVertices = ((MeshPart)Mesh.this.elementAt(Mesh.this.firstMeshPart[this.level])).allVertices(true);
            }
            return this.partVertices.hasMoreElements();
        }

        public Object nextElement() {
            if (!this.partVertices.hasMoreElements() && ++this.level < Mesh.this.firstMeshPart.length && Mesh.this.firstMeshPart[this.level] > 0) {
                this.partVertices = ((MeshPart)Mesh.this.elementAt(Mesh.this.firstMeshPart[this.level])).allVertices(true);
            }
            return this.partVertices.nextElement();
        }
    }

    private class PartEnumerator
    implements Enumeration {
        private int level;
        private Enumeration parts;
        private MeshPart part;

        public PartEnumerator(int stemLevel) {
            this.level = stemLevel;
            this.parts = Mesh.this.elements();
            this.nextPart();
        }

        private void nextPart() {
            if (this.parts.hasMoreElements()) {
                this.part = (MeshPart)this.parts.nextElement();
                if (this.level >= 0) {
                    while (this.part.stem.getLevel() != this.level) {
                        if (this.parts.hasMoreElements()) {
                            this.part = (MeshPart)this.parts.nextElement();
                            continue;
                        }
                        this.part = null;
                        return;
                    }
                }
            } else {
                this.part = null;
            }
        }

        public boolean hasMoreElements() {
            return this.part != null;
        }

        public Object nextElement() {
            if (this.part != null) {
                MeshPart result = this.part;
                this.nextPart();
                return result;
            }
            throw new NoSuchElementException();
        }
    }

    private class FaceEnumerator
    implements Enumeration {
        private Enumeration parts;
        private Enumeration partFaces;
        private MeshPart part;
        private boolean UVFaces;
        private int startIndex;
        private int level;
        private Mesh mesh;

        public FaceEnumerator(Mesh mesh2, int startInx, boolean uv, int stemLevel) {
            this.UVFaces = uv;
            this.startIndex = startInx;
            this.level = stemLevel;
            this.parts = Mesh.this.allParts(this.level);
            this.mesh = mesh2;
            this.nextPart(true);
        }

        private void nextPart(boolean firstPart) {
            if (this.UVFaces) {
                this.part = (MeshPart)this.parts.nextElement();
                this.startIndex = Mesh.this.firstUVIndex(this.part.stem.getLevel());
            } else {
                if (!firstPart) {
                    this.startIndex += this.part.vertexCount();
                }
                this.part = (MeshPart)this.parts.nextElement();
            }
            this.partFaces = this.part.allFaces(this.mesh, this.startIndex, this.UVFaces);
        }

        public boolean hasMoreElements() {
            if (!this.partFaces.hasMoreElements() && this.parts.hasMoreElements()) {
                this.nextPart(false);
            }
            return this.partFaces.hasMoreElements();
        }

        public Object nextElement() {
            if (!this.partFaces.hasMoreElements() && this.parts.hasMoreElements()) {
                this.nextPart(false);
            }
            return this.partFaces.nextElement();
        }
    }
}

