/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.arbaro.mesh;

import net.sourceforge.arbaro.mesh.Face;
import net.sourceforge.arbaro.mesh.LeafShape;
import net.sourceforge.arbaro.mesh.Vertex;

class DiscShape
extends LeafShape {
    public DiscShape(int triangleCount, double len, double wid, double stem_len, boolean quads) {
        super(len, wid, stem_len, quads);
        this.vertices = new Vertex[triangleCount + 2];
        this.faces = quads ? new Face[triangleCount / 2 + triangleCount % 2] : new Face[triangleCount];
        this.setCirclePoints();
        this.setFaces();
    }

    void setCirclePoints() {
        int cnt = this.vertices.length;
        int i = 0;
        while (i < cnt) {
            double angle = (double)i * 2.0 * Math.PI / (double)cnt;
            double x = Math.sin(angle);
            double z = Math.cos(angle);
            if (angle < Math.PI) {
                x -= this.leaffunc(angle);
            } else if (angle > Math.PI) {
                x += this.leaffunc(Math.PI * 2 - angle);
            }
            this.setPoint(i, 0.5 * x, 0.0, 0.5 * z + 0.5);
            ++i;
        }
    }

    double leaffunc(double angle) {
        return this.leaffuncaux(angle) - angle * this.leaffuncaux(Math.PI) / Math.PI;
    }

    double leaffuncaux(double x) {
        return 0.8 * Math.log(x + 1.0) / Math.log(1.2) - 1.0 * Math.sin(x);
    }

    void setFaces() {
        int left = 0;
        int right = this.vertices.length - 1;
        int i = 0;
        while (i < this.faces.length) {
            if (this.useQuads) {
                if (left + 1 < right - 1) {
                    this.faces[i] = new Face(left, left + 1, right - 1, right);
                    ++left;
                    --right;
                } else {
                    this.faces[i] = new Face(left, left + 1, right);
                    ++left;
                }
            } else if (i % 2 == 0) {
                this.faces[i] = new Face(left, left + 1, right);
                ++left;
            } else {
                this.faces[i] = new Face(left, right - 1, right);
                --right;
            }
            ++i;
        }
    }
}

