/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.arbaro.gui;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.RenderingHints;
import java.awt.geom.AffineTransform;
import java.awt.geom.Point2D;
import java.util.Enumeration;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import net.sourceforge.arbaro.export.Console;
import net.sourceforge.arbaro.gui.Config;
import net.sourceforge.arbaro.gui.PreviewTree;
import net.sourceforge.arbaro.gui.TreePreview;
import net.sourceforge.arbaro.mesh.Face;
import net.sourceforge.arbaro.mesh.LeafMesh;
import net.sourceforge.arbaro.mesh.MeshPart;
import net.sourceforge.arbaro.mesh.MeshSection;
import net.sourceforge.arbaro.params.Params;
import net.sourceforge.arbaro.transformation.Transformation;
import net.sourceforge.arbaro.transformation.Vector;
import net.sourceforge.arbaro.tree.DefaultTreeTraversal;
import net.sourceforge.arbaro.tree.Leaf;
import net.sourceforge.arbaro.tree.Stem;
import net.sourceforge.arbaro.tree.StemSection;
import net.sourceforge.arbaro.tree.Tree;
import net.sourceforge.arbaro.tree.TreeTraversal;

public class TreePreview
extends JComponent {
    private static final long serialVersionUID = 1L;
    PreviewTree previewTree;
    int perspective;
    Config config;
    boolean draft = false;
    static final int PERSPECTIVE_FRONT = 0;
    static final int PERSPECTIVE_TOP = 90;
    static final Color thisLevelColor = new Color(0.3f, 0.2f, 0.2f);
    static final Color otherLevelColor = new Color(0.6f, 0.6f, 0.6f);
    static final Color leafColor = new Color(0.1f, 0.6f, 0.1f);
    static final Color bgClr = new Color(250, 250, 245);
    AffineTransform transform;
    Transformation rotation;
    Vector origin = new Vector(0.0, 0.0, 0.0);

    public TreePreview(PreviewTree prvTree, int perspect, Config config) {
        this.config = config;
        this.setMinimumSize(new Dimension(100, 100));
        this.setBorder(BorderFactory.createEmptyBorder(2, 2, 2, 2));
        this.setOpaque(true);
        this.setBackground(Color.WHITE);
        this.previewTree = prvTree;
        this.perspective = perspect;
        this.initRotation();
        this.previewTree.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent e) {
                TreePreview.this.repaint();
            }
        });
    }

    public void paint(Graphics g) {
        if (this.previewTree.getMesh() == null) {
            try {
                this.previewTree.remake(false);
            }
            catch (Exception e) {
                Console.printException(e);
            }
        }
        Graphics2D g2 = (Graphics2D)g;
        RenderingHints rh = this.config.getProperty("preview.antialias", "on").equals("on") ? new RenderingHints(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON) : new RenderingHints(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_OFF);
        g2.addRenderingHints(rh);
        try {
            g.clearRect(0, 0, this.getWidth(), this.getHeight());
            g.setColor(bgClr);
            if (this.perspective == 0) {
                g.fillRect(0, 0, this.getWidth() - 1, this.getHeight());
            } else {
                g.fillRect(0, 0, this.getWidth(), this.getHeight() - 1);
            }
            this.initTransform();
            if (this.draft) {
                this.previewTree.traverseTree(new StemDrawer(g));
            } else {
                this.drawMesh(g);
                Params params = this.previewTree.getParams();
                this.previewTree.traverseTree(new LeafDrawer(g, params, this.previewTree));
            }
        }
        catch (Exception e) {
            Console.errorOutput(e.toString());
        }
    }

    public void setDraft(boolean d) {
        this.draft = d;
    }

    protected void initRotation() {
        this.rotation = new Transformation();
        if (this.perspective == 90) {
            this.rotation = this.rotation.rotx(90.0);
        }
    }

    public void setRotation(double zangle) {
        this.initRotation();
        this.rotation = this.rotation.rotz(zangle);
        this.repaint();
    }

    public void setOrigin(Vector orig) {
        this.origin = orig;
    }

    private void initTransform() throws Exception {
        this.transform = new AffineTransform();
        double dw = 1.0;
        double minw = 0.0;
        double dh = 0.0;
        double minh = 0.0;
        int margin = 5;
        int showLevel = this.previewTree.getShowLevel();
        if (showLevel < 1) {
            this.setOrigin(new Vector());
            if (this.perspective == 0) {
                dw = this.previewTree.getWidth() * 2.0;
                dh = this.previewTree.getHeight();
                minh = 0.0;
                minw = -dw / 2.0;
            } else {
                dw = this.previewTree.getWidth() * 2.0;
                minw = -dw / 2.0;
            }
        } else {
            Stem aStem = null;
            class FindAStem
            extends DefaultTreeTraversal {
                Stem found;
                int level;
                final /* synthetic */ TreePreview this$0;

                public FindAStem(TreePreview treePreview, int level) {
                    this.this$0 = treePreview;
                    this.found = null;
                    this.level = level;
                }

                public Stem getFound() {
                    return this.found;
                }

                public boolean enterStem(Stem stem) {
                    if (this.found == null && stem.getLevel() < this.level) {
                        return true;
                    }
                    if (this.found != null || stem.getLevel() > this.level) {
                        return false;
                    }
                    if (stem.getLevel() == this.level) {
                        this.found = stem;
                    }
                    return true;
                }

                public boolean leaveTree(Tree tree) {
                    return this.found != null;
                }
            }
            FindAStem stemFinder = new FindAStem(this, showLevel - 1);
            if (this.previewTree.traverseTree(stemFinder)) {
                aStem = stemFinder.getFound();
            }
            if (aStem != null) {
                Vector diag = aStem.getMaxPoint().sub(aStem.getMinPoint());
                Vector orig = aStem.getTransformation().getT();
                this.setOrigin(new Vector(orig.getX(), orig.getY(), 0.0));
                Vector max = aStem.getMaxPoint();
                Vector min = aStem.getMinPoint();
                double x = Math.max(Math.abs(min.getX() - orig.getX()), Math.abs(max.getX() - orig.getX()));
                double y = Math.max(Math.abs(min.getY() - orig.getY()), Math.abs(max.getY() - orig.getY()));
                dw = Math.sqrt(x * x + y * y) * 2.0;
                minw = -dw / 2.0;
                dh = diag.getZ();
                minh = min.getZ();
            }
        }
        if (this.perspective == 0) {
            double scale = Math.min((double)(this.getHeight() - 10) / dh, (double)(this.getWidth() - 10) / dw);
            this.transform.translate(this.getWidth() / 2, this.getHeight() / 2);
            this.transform.scale(scale, -scale);
            this.transform.translate(-minw - dw / 2.0, -minh - dh / 2.0);
        } else {
            double scale = Math.min((double)(this.getHeight() - 10) / dw, (double)(this.getWidth() - 10) / dw);
            this.transform.translate(this.getWidth() / 2, this.getHeight() / 2);
            this.transform.scale(scale, -scale);
            this.transform.translate(-minw - dw / 2.0, -minw - dw / 2.0);
        }
        Point p = new Point();
        this.transform.transform(new Point2D.Double(0.0, 0.0), p);
    }

    private void drawMesh(Graphics g) {
        try {
            Enumeration parts = this.previewTree.getMesh().elements();
            while (parts.hasMoreElements()) {
                MeshPart m = (MeshPart)parts.nextElement();
                if (m.getLevel() == this.previewTree.getShowLevel()) {
                    g.setColor(thisLevelColor);
                } else {
                    g.setColor(otherLevelColor);
                }
                this.drawMeshPart(g, m);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void drawMeshPart(Graphics g, MeshPart m) {
        if (m.size() > 0) {
            MeshSection s = (MeshSection)m.elementAt(1);
            while (s.next != null) {
                int i;
                if (s.size() >= s.next.size()) {
                    i = 0;
                    while (i < s.size()) {
                        this.drawLine(g, s.here(i), s.up(i));
                        this.drawLine(g, s.here(i), s.right(i));
                        ++i;
                    }
                    s = s.next;
                    continue;
                }
                s = s.next;
                i = 0;
                while (i < s.size()) {
                    this.drawLine(g, s.here(i), s.down(i));
                    this.drawLine(g, s.here(i), s.right(i));
                    ++i;
                }
            }
        }
    }

    void drawLine(Graphics g, Vector p, Vector q) {
        Vector u = this.rotation.apply(p.sub(this.origin));
        Vector v = this.rotation.apply(q.sub(this.origin));
        Point2D.Double from = new Point2D.Double(u.getX(), u.getZ());
        Point2D.Double to = new Point2D.Double(v.getX(), v.getZ());
        Point ifrom = new Point();
        Point ito = new Point();
        this.transform.transform(from, ifrom);
        this.transform.transform(to, ito);
        g.drawLine(ifrom.x, ifrom.y, ito.x, ito.y);
    }

    private class LeafDrawer
    implements TreeTraversal {
        LeafMesh m;
        Graphics g;

        public LeafDrawer(Graphics g, Params params, PreviewTree pTree) {
            this.g = g;
            this.m = pTree.getLeafMesh();
            g.setColor(leafColor);
        }

        public boolean enterTree(Tree tree) {
            return true;
        }

        public boolean leaveTree(Tree tree) {
            return true;
        }

        public boolean enterStem(Stem stem) {
            return true;
        }

        public boolean leaveStem(Stem stem) {
            return true;
        }

        public boolean visitLeaf(Leaf leaf) {
            if (this.m.isFlat()) {
                Vector p = leaf.getTransformation().apply(this.m.shapeVertexAt((int)(this.m.getShapeVertexCount() - 1)).point);
                int i = 0;
                while (i < this.m.getShapeVertexCount()) {
                    Vector q = leaf.getTransformation().apply(this.m.shapeVertexAt((int)i).point);
                    TreePreview.this.drawLine(this.g, p, q);
                    p = q;
                    ++i;
                }
            } else {
                int i = 0;
                while (i < this.m.getShapeFaceCount()) {
                    Face f = this.m.shapeFaceAt(i);
                    Vector p = leaf.getTransformation().apply(this.m.shapeVertexAt((int)((int)f.points[0])).point);
                    Vector q = leaf.getTransformation().apply(this.m.shapeVertexAt((int)((int)f.points[1])).point);
                    Vector r = leaf.getTransformation().apply(this.m.shapeVertexAt((int)((int)f.points[2])).point);
                    TreePreview.this.drawLine(this.g, p, q);
                    TreePreview.this.drawLine(this.g, p, r);
                    TreePreview.this.drawLine(this.g, r, q);
                    ++i;
                }
            }
            return true;
        }
    }

    private class StemDrawer
    implements TreeTraversal {
        Stem stem;
        Graphics g;

        public StemDrawer(Graphics g) {
            this.g = g;
            g.setColor(otherLevelColor);
        }

        public boolean enterTree(Tree tree) {
            return true;
        }

        public boolean leaveTree(Tree tree) {
            return true;
        }

        public boolean enterStem(Stem stem) {
            Enumeration sections = stem.sections();
            if (sections.hasMoreElements()) {
                StemSection from = (StemSection)sections.nextElement();
                while (sections.hasMoreElements()) {
                    StemSection to = (StemSection)sections.nextElement();
                    TreePreview.this.drawLine(this.g, from.getPosition(), to.getPosition());
                    from = to;
                }
            }
            return true;
        }

        public boolean leaveStem(Stem stem) {
            return true;
        }

        public boolean visitLeaf(Leaf l) {
            return true;
        }
    }
}

