/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.arbaro.gui;

import java.io.PrintWriter;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.EventListenerList;
import net.sourceforge.arbaro.export.Progress;
import net.sourceforge.arbaro.mesh.LeafMesh;
import net.sourceforge.arbaro.mesh.Mesh;
import net.sourceforge.arbaro.mesh.MeshGenerator;
import net.sourceforge.arbaro.mesh.MeshGeneratorFactory;
import net.sourceforge.arbaro.params.IntParam;
import net.sourceforge.arbaro.params.Params;
import net.sourceforge.arbaro.transformation.Vector;
import net.sourceforge.arbaro.tree.Tree;
import net.sourceforge.arbaro.tree.TreeGenerator;
import net.sourceforge.arbaro.tree.TreeGeneratorFactory;
import net.sourceforge.arbaro.tree.TreeTraversal;

public final class PreviewTree
implements Tree {
    int showLevel = 1;
    Params originalParams;
    Mesh mesh;
    LeafMesh leafMesh;
    MeshGenerator meshGenerator;
    Tree tree;
    protected ChangeEvent changeEvent = null;
    protected EventListenerList listenerList = new EventListenerList();
    static /* synthetic */ Class class$0;

    public PreviewTree(Params params) {
        this.originalParams = params;
    }

    public Params getParams() {
        return this.originalParams;
    }

    public void setParams(Params params) {
        this.originalParams = params;
    }

    public boolean traverseTree(TreeTraversal traversal) {
        return this.tree.traverseTree(traversal);
    }

    public long getStemCount() {
        return this.tree.getStemCount();
    }

    public long getLeafCount() {
        return this.tree.getLeafCount();
    }

    public Vector getMaxPoint() {
        return this.tree.getMaxPoint();
    }

    public Vector getMinPoint() {
        return this.tree.getMinPoint();
    }

    public int getSeed() {
        return this.tree.getSeed();
    }

    public double getHeight() {
        return this.tree.getHeight();
    }

    public double getWidth() {
        return this.tree.getWidth();
    }

    public void paramsToXML(PrintWriter w) {
        throw new UnsupportedOperationException("Not implemented.");
    }

    public String getSpecies() {
        return this.tree.getSpecies();
    }

    public int getLevels() {
        return this.tree.getLevels();
    }

    public String getLeafShape() {
        return this.tree.getLeafShape();
    }

    public double getLeafWidth() {
        return this.tree.getLeafWidth();
    }

    public double getLeafLength() {
        return this.tree.getLeafLength();
    }

    public double getLeafStemLength() {
        return this.tree.getLeafStemLength();
    }

    public String getVertexInfo(int level) {
        return this.tree.getVertexInfo(level);
    }

    public void setShowLevel(int l) {
        int Levels = ((IntParam)this.originalParams.getParam("Levels")).intValue();
        this.showLevel = l > Levels ? Levels : l;
    }

    public int getShowLevel() {
        return this.showLevel;
    }

    public void remake(boolean doFireStateChanged) {
        Params params = new Params(this.originalParams);
        params.preview = true;
        int Levels = ((IntParam)this.originalParams.getParam("Levels")).intValue();
        if (Levels > this.showLevel + 1) {
            params.setParam("Levels", "" + (this.showLevel + 1));
            params.setParam("Leaves", "0");
        }
        int i = 0;
        while (i < this.showLevel) {
            params.setParam(i + "Branches", "1");
            params.setParam(i + "DownAngleV", "0");
            ++i;
        }
        Progress progress = new Progress();
        TreeGenerator treeGenerator = TreeGeneratorFactory.createShieldedTreeGenerator(params);
        this.tree = treeGenerator.makeTree(progress);
        MeshGenerator meshGenerator = MeshGeneratorFactory.createShieldedMeshGenerator(true);
        this.mesh = meshGenerator.createStemMesh(this.tree, progress);
        this.leafMesh = meshGenerator.createLeafMesh(this.tree, true);
        if (doFireStateChanged) {
            this.fireStateChanged();
        }
    }

    public Mesh getMesh() {
        return this.mesh;
    }

    public LeafMesh getLeafMesh() {
        return this.leafMesh;
    }

    public void addChangeListener(ChangeListener l) {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("javax.swing.event.ChangeListener");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        this.listenerList.add(clazz, l);
    }

    public void removeChangeListener(ChangeListener l) {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("javax.swing.event.ChangeListener");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        this.listenerList.remove(clazz, l);
    }

    protected void fireStateChanged() {
        Object[] listeners = this.listenerList.getListenerList();
        int i = listeners.length - 2;
        while (i >= 0) {
            Object object = listeners[i];
            Class<?> clazz = class$0;
            if (clazz == null) {
                try {
                    clazz = Class.forName("javax.swing.event.ChangeListener");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            if (object == clazz) {
                if (this.changeEvent == null) {
                    this.changeEvent = new ChangeEvent(this);
                }
                ((ChangeListener)listeners[i + 1]).stateChanged(this.changeEvent);
            }
            i -= 2;
        }
    }
}

