/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.arbaro.gui;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.net.URL;
import java.util.Iterator;
import java.util.TreeMap;
import javax.swing.AbstractCellEditor;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.ListCellRenderer;
import javax.swing.ListSelectionModel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableColumn;
import net.sourceforge.arbaro.params.AbstractParam;
import net.sourceforge.arbaro.params.IntParam;
import net.sourceforge.arbaro.params.LeafShapeParam;
import net.sourceforge.arbaro.params.Params;
import net.sourceforge.arbaro.params.ShapeParam;

public final class ParamValueTable
extends JPanel {
    private static final long serialVersionUID = 1L;
    JTable table;
    HelpInfo helpInfo;
    Params par;
    String groupName;
    int groupLevel;
    ParamTableModel tableModel;
    static final Color bgClr = new Color(250, 250, 240);
    ChangeEvent changeEvent;
    static /* synthetic */ Class class$0;

    public ParamValueTable(Params params) {
        super(new BorderLayout());
        this.setBorder(BorderFactory.createEmptyBorder());
        this.setBackground(bgClr);
        this.par = params;
        this.tableModel = new ParamTableModel();
        this.table = new JTable(this.tableModel);
        this.table.setBackground(bgClr);
        this.table.setRowHeight((int)((double)this.table.getRowHeight() * 1.3));
        TableColumn paramColumn = this.table.getColumnModel().getColumn(0);
        paramColumn.setHeaderValue("Parameter");
        TableColumn valueColumn = this.table.getColumnModel().getColumn(1);
        valueColumn.setHeaderValue("Value");
        valueColumn.setCellEditor(new CellEditor());
        valueColumn.setCellRenderer(new CellRenderer());
        this.add((Component)this.table, "North");
        this.table.setSelectionMode(0);
        ListSelectionModel rowSM = this.table.getSelectionModel();
        rowSM.addListSelectionListener(new ListSelectionListener(){

            public void valueChanged(ListSelectionEvent e) {
                if (e.getValueIsAdjusting()) {
                    return;
                }
                ListSelectionModel lsm = (ListSelectionModel)e.getSource();
                if (lsm.isSelectionEmpty()) {
                    ParamValueTable.this.helpInfo.setText("");
                    ParamValueTable.this.helpInfo.setLongText("");
                } else {
                    int selectedRow = lsm.getMinSelectionIndex();
                    AbstractParam param = (AbstractParam)ParamValueTable.this.tableModel.getValueAt(selectedRow, 1);
                    ParamValueTable.this.helpInfo.setText("<html><a href=\"longDesc\">" + param.getName() + "</a>: " + param.getShortDesc() + "</html>");
                    ParamValueTable.this.helpInfo.setLongText("<html>" + param.getLongDesc() + "</html>");
                }
            }
        });
        this.helpInfo = new HelpInfo();
        this.helpInfo.addMouseListener(new MouseAdapter(){

            public void mousePressed(MouseEvent e) {
                ((HelpInfo)e.getSource()).showLongText();
            }
        });
        this.add((Component)this.helpInfo, "Center");
    }

    public void showGroup(String group, int level) {
        if (this.table.isEditing()) {
            this.table.getCellEditor().stopCellEditing();
        }
        this.groupName = group;
        this.groupLevel = level;
        this.tableModel.fireTableDataChanged();
    }

    public void stopEditing() {
        if (this.table.isEditing()) {
            this.table.getCellEditor().stopCellEditing();
        }
    }

    public void showError(Exception e) {
        this.helpInfo.showError(e.getMessage());
    }

    public void noError() {
        this.helpInfo.noError();
    }

    public void addChangeListener(ChangeListener l) {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("javax.swing.event.ChangeListener");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        this.listenerList.add(clazz, l);
    }

    public void removeChangeListener(ChangeListener l) {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("javax.swing.event.ChangeListener");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        this.listenerList.remove(clazz, l);
    }

    protected void fireStateChanged() {
        Object[] listeners = this.listenerList.getListenerList();
        int i = listeners.length - 2;
        while (i >= 0) {
            Object object = listeners[i];
            Class<?> clazz = class$0;
            if (clazz == null) {
                try {
                    clazz = Class.forName("javax.swing.event.ChangeListener");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            if (object == clazz) {
                if (this.changeEvent == null) {
                    this.changeEvent = new ChangeEvent(this);
                }
                ((ChangeListener)listeners[i + 1]).stateChanged(this.changeEvent);
            }
            i -= 2;
        }
    }

    class LeafShapeBox
    extends JComboBox {
        private static final long serialVersionUID = 1L;

        public LeafShapeBox() {
            this.setEditable(true);
            String[] items = LeafShapeParam.values();
            int i = 0;
            while (i < items.length) {
                this.addItem(items[i]);
                ++i;
            }
        }

        public void setValue(AbstractParam p) {
            int i = 0;
            while (i < this.getItemCount()) {
                if (this.getItemAt(i).equals(p.getValue())) {
                    this.setSelectedIndex(i);
                    return;
                }
                ++i;
            }
        }

        public String getValue() {
            return (String)this.getSelectedItem();
        }
    }

    class ShapeBox
    extends JComboBox {
        private static final long serialVersionUID = 1L;
        ImageIcon[] shapeIcons;
        static /* synthetic */ Class class$0;

        protected ImageIcon createImageIcon(String path, String description) {
            URL imgURL;
            Class<?> clazz = class$0;
            if (clazz == null) {
                try {
                    clazz = class$0 = Class.forName("net.sourceforge.arbaro.gui.ParamValueTable$ShapeBox");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            if ((imgURL = clazz.getResource(path)) != null) {
                return new ImageIcon(imgURL, description);
            }
            System.err.println("Couldn't find file: " + path);
            return null;
        }

        public ShapeBox() {
            ShapeRenderer sr = new ShapeRenderer();
            this.setRenderer(sr);
            String[] items = ShapeParam.values();
            this.shapeIcons = new ImageIcon[items.length];
            int i = 0;
            while (i < items.length) {
                this.shapeIcons[i] = this.createImageIcon("images/shape" + i + ".png", items[i]);
                this.addItem("" + i);
                ++i;
            }
        }

        public void setValue(AbstractParam p) {
            this.setSelectedIndex(((IntParam)p).intValue());
        }

        public String getValue() {
            return "" + this.getSelectedIndex();
        }

        class ShapeRenderer
        extends JLabel
        implements ListCellRenderer {
            private static final long serialVersionUID = 1L;

            public ShapeRenderer() {
                this.setOpaque(true);
            }

            public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
                int myIndex = Integer.parseInt(value.toString());
                if (isSelected) {
                    this.setBackground(list.getSelectionBackground());
                    this.setForeground(list.getSelectionForeground());
                } else {
                    this.setBackground(list.getBackground());
                    this.setForeground(list.getForeground());
                }
                ImageIcon icon = ShapeBox.this.shapeIcons[myIndex];
                this.setIcon(icon);
                this.setText(icon.getDescription());
                return this;
            }
        }
    }

    class CellEditor
    extends AbstractCellEditor
    implements TableCellEditor {
        private static final long serialVersionUID = 1L;
        AbstractParam param;
        JTextField paramField = new JTextField();
        ShapeBox shapeBox;
        LeafShapeBox leafShapeBox;
        JComponent editor;

        void editingStopped() {
            this.fireEditingStopped();
        }

        public CellEditor() {
            this.shapeBox = new ShapeBox();
            this.shapeBox.addActionListener(new ActionListener(this){
                final /* synthetic */ CellEditor this$1;
                {
                    this.this$1 = cellEditor;
                }

                public void actionPerformed(ActionEvent e) {
                    this.this$1.editingStopped();
                }
            });
            this.leafShapeBox = new LeafShapeBox();
            this.leafShapeBox.addActionListener(new ActionListener(this){
                final /* synthetic */ CellEditor this$1;
                {
                    this.this$1 = cellEditor;
                }

                public void actionPerformed(ActionEvent e) {
                    this.this$1.editingStopped();
                }
            });
        }

        public Object getCellEditorValue() {
            try {
                if (this.editor == this.shapeBox) {
                    this.param.setValue(this.shapeBox.getValue());
                } else if (this.editor == this.leafShapeBox) {
                    this.param.setValue(this.leafShapeBox.getValue());
                } else {
                    this.param.setValue(this.paramField.getText());
                }
            }
            catch (Exception err) {
                System.err.println(err);
                ParamValueTable.this.showError(err);
            }
            return this.param;
        }

        public Component getTableCellEditorComponent(JTable table, Object value, boolean isSelected, int row, int column) {
            this.param = (AbstractParam)value;
            if (this.param.getName().equals("Shape")) {
                this.shapeBox.setValue(this.param);
                this.editor = this.shapeBox;
            } else if (this.param.getName().equals("LeafShape")) {
                this.leafShapeBox.setValue(this.param);
                this.editor = this.leafShapeBox;
            } else {
                this.paramField.setText(this.param.toString());
                this.paramField.selectAll();
                this.editor = this.paramField;
            }
            return this.editor;
        }
    }

    class CellRenderer
    extends DefaultTableCellRenderer {
        private static final long serialVersionUID = 1L;
        static /* synthetic */ Class class$0;
        static /* synthetic */ Class class$1;
        static /* synthetic */ Class class$2;

        public void setValue(Object value) {
            Class<?> clazz = value.getClass();
            Class<?> clazz2 = class$0;
            if (clazz2 == null) {
                try {
                    clazz2 = class$0 = Class.forName("net.sourceforge.arbaro.params.ShapeParam");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            if (clazz == clazz2) {
                this.setHorizontalAlignment(2);
                this.setText(((ShapeParam)value).intValue() + " - " + value.toString());
            } else {
                Class<?> clazz3 = value.getClass();
                Class<?> clazz4 = class$1;
                if (clazz4 == null) {
                    try {
                        clazz4 = class$1 = Class.forName("net.sourceforge.arbaro.params.LeafShapeParam");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                if (clazz3 == clazz4) {
                    this.setHorizontalAlignment(2);
                    this.setText(value.toString());
                } else {
                    Class<?> clazz5 = value.getClass();
                    Class<?> clazz6 = class$2;
                    if (clazz6 == null) {
                        try {
                            clazz6 = class$2 = Class.forName("net.sourceforge.arbaro.params.StringParam");
                        }
                        catch (ClassNotFoundException classNotFoundException) {
                            throw new NoClassDefFoundError(classNotFoundException.getMessage());
                        }
                    }
                    if (clazz5 == clazz6) {
                        this.setHorizontalAlignment(2);
                        this.setText(value.toString());
                    } else {
                        this.setHorizontalAlignment(4);
                        this.setText(value.toString());
                    }
                }
            }
            this.setEnabled(((AbstractParam)value).getEnabled());
        }
    }

    class ParamTableModel
    extends AbstractTableModel {
        private static final long serialVersionUID = 1L;
        static /* synthetic */ Class class$0;

        ParamTableModel() {
        }

        public int getColumnCount() {
            return 2;
        }

        public int getRowCount() {
            TreeMap params = ParamValueTable.this.par.getParamGroup(ParamValueTable.this.groupLevel, ParamValueTable.this.groupName);
            return params.size();
        }

        public Object getValueAt(int row, int col) {
            TreeMap params = ParamValueTable.this.par.getParamGroup(ParamValueTable.this.groupLevel, ParamValueTable.this.groupName);
            int r = 0;
            Iterator e = params.values().iterator();
            while (e.hasNext()) {
                AbstractParam p = (AbstractParam)e.next();
                if (row != r++) continue;
                if (col == 0) {
                    return p.getName();
                }
                return p;
            }
            return "";
        }

        public void setValueAt(Object value, int row, int col) {
            ParamValueTable.this.noError();
            try {
                ParamValueTable.this.tableModel.fireTableDataChanged();
                ParamValueTable.this.fireStateChanged();
            }
            catch (Exception e) {
                Class<?> clazz = e.getClass();
                Class<?> clazz2 = class$0;
                if (clazz2 == null) {
                    try {
                        clazz2 = class$0 = Class.forName("net.sourceforge.arbaro.params.ParamException");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                if (clazz == clazz2) {
                    System.err.println(e);
                    ParamValueTable.this.showError(e);
                }
                System.err.println(e);
                e.printStackTrace();
            }
        }

        public boolean isCellEditable(int row, int col) {
            return col == 1 && ((AbstractParam)this.getValueAt(row, col)).getEnabled();
        }
    }

    class HelpInfo
    extends JLabel {
        private static final long serialVersionUID = 1L;
        String longText;
        boolean errorShowing = false;

        public HelpInfo() {
            this.setFont(this.getFont().deriveFont(0, 12.0f));
            this.setBorder(BorderFactory.createEmptyBorder(10, 5, 5, 5));
        }

        public void setLongText(String text) {
            if (!this.errorShowing) {
                this.longText = text;
            }
        }

        public void showLongText() {
            if (!this.errorShowing) {
                JLabel msg = new JLabel(this.longText.replace('\n', ' '));
                JOptionPane.showMessageDialog(this, msg, "Parameter description", 1);
            }
        }

        public void showError(String err) {
            this.setText("<html><font color='red'>" + err + "</font></html>");
            this.errorShowing = true;
        }

        public void noError() {
            this.errorShowing = false;
        }

        public void setText(String str) {
            if (!this.errorShowing) {
                super.setText(str);
            }
        }
    }
}

