/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.arbaro.gui;

import java.awt.Color;
import javax.swing.JTree;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeCellRenderer;
import javax.swing.tree.TreePath;
import net.sourceforge.arbaro.gui.GroupNode;

public final class ParamGroupsView
extends JTree {
    private static final long serialVersionUID = 1L;
    static DefaultMutableTreeNode root = new DefaultMutableTreeNode("root");
    static final Color bgClr = new Color(250, 250, 240);
    ChangeEvent changeEvent;
    static /* synthetic */ Class class$0;

    public ParamGroupsView() {
        super(root);
        this.createNodes();
        this.setBackground(bgClr);
        this.setRootVisible(false);
        this.setShowsRootHandles(true);
        this.setExpandsSelectedPaths(true);
        this.getSelectionModel().setSelectionMode(1);
        DefaultTreeCellRenderer renderer = new DefaultTreeCellRenderer();
        renderer.setLeafIcon(null);
        renderer.setOpenIcon(null);
        renderer.setClosedIcon(null);
        renderer.setBackground(bgClr);
        renderer.setBackgroundNonSelectionColor(bgClr);
        this.setCellRenderer(renderer);
        this.addTreeSelectionListener(new TreeSelectionListener(){

            public void valueChanged(TreeSelectionEvent e) {
                DefaultMutableTreeNode node = (DefaultMutableTreeNode)ParamGroupsView.this.getLastSelectedPathComponent();
                if (node == null) {
                    return;
                }
                ParamGroupsView.this.fireStateChanged();
            }
        });
    }

    public String getGroupName() throws Exception {
        DefaultMutableTreeNode node = (DefaultMutableTreeNode)this.getLastSelectedPathComponent();
        if (!node.isRoot()) {
            return ((GroupNode)node).getGroupName();
        }
        throw new Exception("no group selected");
    }

    public int getGroupLevel() throws Exception {
        DefaultMutableTreeNode node = (DefaultMutableTreeNode)this.getLastSelectedPathComponent();
        if (!node.isRoot()) {
            return ((GroupNode)node).getGroupLevel();
        }
        throw new Exception("no group selected");
    }

    private void createNodes() {
        GroupNode general = new GroupNode("", "General", -999);
        root.add(general);
        GroupNode firstGroup = this.addGroup(general, "SHAPE", "Tree shape", -999);
        this.addGroup(general, "TRUNK", "Trunk radius", -999);
        this.addGroup(general, "LEAVES", "Leaves", -999);
        this.addGroup(general, "PRUNING", "Pruning/Envelope", -999);
        this.addGroup(general, "QUALITY", "Quality", -999);
        int i = 0;
        while (i < 4) {
            String lName = "Level " + i;
            if (i == 0) {
                lName = String.valueOf(lName) + " (trunk)";
            }
            GroupNode level = new GroupNode("", lName, i);
            root.add(level);
            this.addGroup(level, "LENTAPER", "Length and taper", i);
            this.addGroup(level, "CURVATURE", "Curvature", i);
            this.addGroup(level, "SPLITTING", "Splitting", i);
            this.addGroup(level, "BRANCHING", "Branching", i);
            ++i;
        }
        this.setSelectionPath(new TreePath(firstGroup.getPath()));
    }

    private GroupNode addGroup(DefaultMutableTreeNode parent, String groupName, String groupLabel, int groupLevel) {
        GroupNode groupNode = new GroupNode(groupName, groupLabel, groupLevel);
        parent.add(groupNode);
        return groupNode;
    }

    public void addChangeListener(ChangeListener l) {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("javax.swing.event.ChangeListener");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        this.listenerList.add(clazz, l);
    }

    public void removeChangeListener(ChangeListener l) {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("javax.swing.event.ChangeListener");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        this.listenerList.remove(clazz, l);
    }

    protected void fireStateChanged() {
        Object[] listeners = this.listenerList.getListenerList();
        int i = listeners.length - 2;
        while (i >= 0) {
            Object object = listeners[i];
            Class<?> clazz = class$0;
            if (clazz == null) {
                try {
                    clazz = Class.forName("javax.swing.event.ChangeListener");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            if (object == clazz) {
                if (this.changeEvent == null) {
                    this.changeEvent = new ChangeEvent(this);
                }
                ((ChangeListener)listeners[i + 1]).stateChanged(this.changeEvent);
            }
            i -= 2;
        }
    }
}

