/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.arbaro.gui;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.io.File;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;
import javax.swing.JTextField;
import javax.swing.Timer;
import net.sourceforge.arbaro.export.Console;
import net.sourceforge.arbaro.export.ExporterFactory;
import net.sourceforge.arbaro.gui.Config;
import net.sourceforge.arbaro.gui.Progressbar;
import net.sourceforge.arbaro.gui.ShieldedGUITreeGenerator;
import net.sourceforge.arbaro.gui.ShowException;
import net.sourceforge.arbaro.gui.TreeCreationTask;
import net.sourceforge.arbaro.params.Params;
import net.sourceforge.arbaro.tree.TreeGeneratorFactory;

public class ExportDialog {
    static final int INTERVAL = 500;
    JFrame frame;
    Config config;
    boolean render;
    JPanel mainPanel;
    Progressbar progressbar;
    Params params;
    int seed;
    File treefile = null;
    JFileChooser fileChooser;
    JFileChooser sceneFileChooser;
    JFileChooser renderFileChooser;
    JTabbedPane tabbedPane;
    JComboBox formatBox;
    JCheckBox sceneCheckbox;
    JCheckBox renderCheckbox;
    JCheckBox uvStemsCheckbox;
    JCheckBox uvLeavesCheckbox;
    JTextField seedField = new JTextField(6);
    JTextField smoothField = new JTextField(6);
    JTextField fileField;
    JTextField sceneFileField;
    JTextField renderFileField;
    JTextField widthField = new JTextField(6);
    JTextField heightField = new JTextField(6);
    JButton selectSceneFile;
    JButton selectRenderFile;
    Timer timer;
    TreeCreationTask treeCreationTask;
    JButton startButton;
    JButton cancelButton;
    String fileSep = System.getProperty("file.separator");

    public ExportDialog(JFrame parent, int seed, Params params, Config cfg, boolean render) {
        this.params = params;
        this.config = cfg;
        this.render = render;
        this.seed = seed;
        this.frame = new JFrame("Create and export tree");
        this.frame.setIconImage(parent.getIconImage());
        this.fileChooser = new JFileChooser();
        this.fileChooser.setCurrentDirectory(new File(ExporterFactory.getOutputPath()));
        this.sceneFileChooser = new JFileChooser();
        this.sceneFileChooser.setCurrentDirectory(new File(ExporterFactory.getOutputPath()));
        this.renderFileChooser = new JFileChooser();
        this.renderFileChooser.setCurrentDirectory(new File(ExporterFactory.getOutputPath()));
        this.timer = new Timer(500, new TimerListener());
        this.treeCreationTask = new TreeCreationTask(this.frame, this.config);
        this.createGUI();
        this.frame.setVisible(true);
    }

    void createGUI() {
        this.tabbedPane = new JTabbedPane();
        JPanel exportPanel = this.createExportPanel();
        this.tabbedPane.addTab("Export", null, exportPanel, "Export options");
        this.tabbedPane.setMnemonicAt(0, 49);
        JPanel renderPanel = this.createRenderPanel();
        this.tabbedPane.addTab("Render", null, renderPanel, "Render options");
        this.tabbedPane.setMnemonicAt(0, 50);
        if (this.render) {
            this.tabbedPane.setSelectedIndex(1);
        }
        this.formatSettings(this.formatBox.getSelectedIndex());
        this.startButton = new JButton("Start");
        this.startButton.addActionListener(new StartButtonListener());
        this.cancelButton = new JButton("Close");
        this.cancelButton.addActionListener(new CancelButtonListener());
        JPanel buttons = new JPanel();
        buttons.add(this.startButton);
        buttons.add(this.cancelButton);
        JPanel panel = new JPanel();
        panel.setLayout(new BorderLayout());
        panel.add((Component)this.tabbedPane, "Center");
        panel.add((Component)buttons, "South");
        Container contentPane = this.frame.getContentPane();
        contentPane.add((Component)panel, "Center");
        this.progressbar = new Progressbar();
        this.progressbar.setVisible(false);
        contentPane.add((Component)this.progressbar, "Last");
        this.frame.pack();
    }

    void formatSettings(int outputFormat) {
        switch (outputFormat) {
            case 0: {
                this.fileField.setText(String.valueOf(this.fileChooser.getCurrentDirectory().getPath()) + this.fileSep + this.params.Species + ".inc");
                this.sceneCheckbox.setEnabled(true);
                this.renderCheckbox.setEnabled(true);
                this.smoothField.setEnabled(true);
                this.tabbedPane.setEnabledAt(1, true);
                this.uvStemsCheckbox.setEnabled(true);
                this.uvLeavesCheckbox.setEnabled(true);
                break;
            }
            case 1: {
                this.fileField.setText(String.valueOf(this.fileChooser.getCurrentDirectory().getPath()) + this.fileSep + this.params.Species + ".inc");
                this.sceneCheckbox.setEnabled(true);
                this.renderCheckbox.setEnabled(true);
                this.smoothField.setEnabled(false);
                this.tabbedPane.setEnabledAt(1, true);
                this.uvStemsCheckbox.setEnabled(false);
                this.uvLeavesCheckbox.setEnabled(false);
                break;
            }
            case 2: {
                this.fileField.setText(String.valueOf(this.fileChooser.getCurrentDirectory().getPath()) + this.fileSep + this.params.Species + ".dxf");
                this.sceneCheckbox.setSelected(false);
                this.sceneCheckbox.setEnabled(false);
                this.renderCheckbox.setSelected(false);
                this.renderCheckbox.setEnabled(false);
                this.smoothField.setEnabled(true);
                this.tabbedPane.setEnabledAt(1, false);
                this.uvStemsCheckbox.setEnabled(false);
                this.uvLeavesCheckbox.setEnabled(false);
                break;
            }
            case 3: {
                this.fileField.setText(String.valueOf(this.fileChooser.getCurrentDirectory().getPath()) + this.fileSep + this.params.Species + ".obj");
                this.sceneCheckbox.setSelected(false);
                this.sceneCheckbox.setEnabled(false);
                this.renderCheckbox.setSelected(false);
                this.renderCheckbox.setEnabled(false);
                this.smoothField.setEnabled(true);
                this.tabbedPane.setEnabledAt(1, false);
                this.uvStemsCheckbox.setEnabled(true);
                this.uvLeavesCheckbox.setEnabled(true);
            }
        }
    }

    JPanel createExportPanel() {
        JPanel panel = new JPanel();
        GridBagLayout grid = new GridBagLayout();
        panel.setLayout(grid);
        panel.setBorder(BorderFactory.createEmptyBorder(30, 30, 30, 30));
        GridBagConstraints clabel = new GridBagConstraints();
        clabel.gridx = 0;
        clabel.anchor = 17;
        GridBagConstraints ctext = new GridBagConstraints();
        ctext.gridx = 1;
        ctext.ipady = 4;
        ctext.anchor = 17;
        ctext.insets = new Insets(1, 5, 1, 5);
        GridBagConstraints cbutton = new GridBagConstraints();
        cbutton.gridx = 2;
        cbutton.anchor = 17;
        int line = -1;
        clabel.gridy = ++line;
        JLabel label = new JLabel("Export format:");
        grid.setConstraints(label, clabel);
        panel.add(label);
        ctext.gridy = line;
        this.formatBox = new JComboBox<String>(ExporterFactory.getExportFormats());
        int format = Integer.parseInt(this.config.getProperty("export.format", "0"));
        if (this.render) {
            int i = this.formatBox.getItemCount() - 1;
            while (i >= 2) {
                this.formatBox.removeItemAt(i);
                --i;
            }
            if (format >= 2) {
                format = 0;
            }
        }
        this.formatBox.setEditable(false);
        this.formatBox.setSelectedIndex(format);
        this.formatBox.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent event) {
                ExportDialog.this.formatSettings(ExportDialog.this.formatBox.getSelectedIndex());
            }
        });
        grid.setConstraints(this.formatBox, ctext);
        panel.add(this.formatBox);
        clabel.gridy = ++line;
        label = new JLabel("Export to file:");
        grid.setConstraints(label, clabel);
        panel.add(label);
        ctext.gridy = line;
        this.fileField = new JTextField(30);
        this.fileField.setText(String.valueOf(this.fileChooser.getCurrentDirectory().getPath()) + this.fileSep + this.params.Species + ".inc");
        this.fileField.setMinimumSize(new Dimension(250, 19));
        grid.setConstraints(this.fileField, ctext);
        panel.add(this.fileField);
        cbutton.gridy = line++;
        JButton selectFile = new JButton("Choose...");
        selectFile.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent event) {
                int returnVal = ExportDialog.this.fileChooser.showSaveDialog(ExportDialog.this.frame);
                if (returnVal == 0) {
                    ExportDialog.this.fileField.setText(ExportDialog.this.fileChooser.getSelectedFile().getPath());
                }
            }
        });
        grid.setConstraints(selectFile, cbutton);
        panel.add(selectFile);
        clabel.gridy = line;
        label = new JLabel("UV-coordinates:");
        grid.setConstraints(label, clabel);
        panel.add(label);
        ctext.gridy = line++;
        this.uvStemsCheckbox = new JCheckBox("for Stems");
        this.uvStemsCheckbox.setSelected(ExporterFactory.getOutputStemUVs());
        this.uvLeavesCheckbox = new JCheckBox("for Leaves");
        this.uvLeavesCheckbox.setSelected(ExporterFactory.getOutputLeafUVs());
        JPanel uv = new JPanel();
        uv.add(this.uvStemsCheckbox);
        uv.add(this.uvLeavesCheckbox);
        grid.setConstraints(uv, ctext);
        panel.add(uv);
        clabel.gridy = line;
        this.sceneCheckbox = new JCheckBox("POV Scene file:");
        this.sceneCheckbox.setSelected(this.render);
        this.sceneCheckbox.addItemListener(new ItemListener(){

            public void itemStateChanged(ItemEvent e) {
                ExportDialog.this.sceneFileField.setEnabled(e.getStateChange() == 1);
                ExportDialog.this.selectSceneFile.setEnabled(e.getStateChange() == 1);
                ExportDialog.this.renderCheckbox.setSelected(e.getStateChange() == 1);
            }
        });
        grid.setConstraints(this.sceneCheckbox, clabel);
        panel.add(this.sceneCheckbox);
        ctext.gridy = line;
        this.sceneFileField = new JTextField(30);
        this.sceneFileField.setEnabled(this.sceneCheckbox.isSelected());
        this.sceneFileField.setText(String.valueOf(this.sceneFileChooser.getCurrentDirectory().getPath()) + this.fileSep + this.params.Species + ".pov");
        this.sceneFileField.setMinimumSize(new Dimension(250, 19));
        grid.setConstraints(this.sceneFileField, ctext);
        panel.add(this.sceneFileField);
        cbutton.gridy = line++;
        this.selectSceneFile = new JButton("Choose...");
        this.selectSceneFile.setEnabled(this.sceneCheckbox.isSelected());
        this.selectSceneFile.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent event) {
                int returnVal = ExportDialog.this.sceneFileChooser.showSaveDialog(ExportDialog.this.frame);
                if (returnVal == 0) {
                    ExportDialog.this.sceneFileField.setText(ExportDialog.this.sceneFileChooser.getSelectedFile().getPath());
                }
            }
        });
        grid.setConstraints(this.selectSceneFile, cbutton);
        panel.add(this.selectSceneFile);
        clabel.gridy = line;
        label = new JLabel("Seed:");
        grid.setConstraints(label, clabel);
        panel.add(label);
        ctext.gridy = line++;
        this.seedField.setText("" + this.seed);
        this.seedField.setMinimumSize(new Dimension(80, 19));
        grid.setConstraints(this.seedField, ctext);
        panel.add(this.seedField);
        clabel.gridy = line;
        label = new JLabel("Smooth value:");
        grid.setConstraints(label, clabel);
        panel.add(label);
        ctext.gridy = line;
        this.smoothField.setText(this.params.getParam("Smooth").toString());
        this.smoothField.setMinimumSize(new Dimension(80, 19));
        grid.setConstraints(this.smoothField, ctext);
        panel.add(this.smoothField);
        return panel;
    }

    JPanel createRenderPanel() {
        JPanel panel = new JPanel();
        GridBagLayout grid = new GridBagLayout();
        panel.setLayout(grid);
        panel.setBorder(BorderFactory.createEmptyBorder(30, 30, 30, 30));
        GridBagConstraints clabel = new GridBagConstraints();
        clabel.gridx = 0;
        clabel.anchor = 17;
        GridBagConstraints ctext = new GridBagConstraints();
        ctext.gridx = 1;
        ctext.ipady = 4;
        ctext.anchor = 17;
        ctext.insets = new Insets(1, 5, 1, 5);
        GridBagConstraints cbutton = new GridBagConstraints();
        cbutton.gridx = 2;
        cbutton.anchor = 17;
        int line = -1;
        clabel.gridy = ++line;
        this.renderCheckbox = new JCheckBox("Render scene to:");
        this.renderCheckbox.setSelected(this.render);
        this.renderCheckbox.addItemListener(new ItemListener(){

            public void itemStateChanged(ItemEvent e) {
                ExportDialog.this.renderFileField.setEnabled(e.getStateChange() == 1);
                ExportDialog.this.selectRenderFile.setEnabled(e.getStateChange() == 1);
            }
        });
        grid.setConstraints(this.renderCheckbox, clabel);
        panel.add(this.renderCheckbox);
        ctext.gridy = line;
        this.renderFileField = new JTextField(30);
        this.renderFileField.setEnabled(this.renderCheckbox.isSelected());
        this.renderFileField.setText(String.valueOf(this.renderFileChooser.getCurrentDirectory().getPath()) + this.fileSep + this.params.Species + ".png");
        this.renderFileField.setMinimumSize(new Dimension(250, 19));
        grid.setConstraints(this.renderFileField, ctext);
        panel.add(this.renderFileField);
        cbutton.gridy = line++;
        this.selectRenderFile = new JButton("Choose...");
        this.selectRenderFile.setEnabled(this.renderCheckbox.isSelected());
        this.selectRenderFile.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent event) {
                int returnVal = ExportDialog.this.renderFileChooser.showSaveDialog(ExportDialog.this.frame);
                if (returnVal == 0) {
                    ExportDialog.this.renderFileField.setText(ExportDialog.this.renderFileChooser.getSelectedFile().getPath());
                }
            }
        });
        grid.setConstraints(this.selectRenderFile, cbutton);
        panel.add(this.selectRenderFile);
        clabel.gridy = line;
        JLabel label = new JLabel("Image width:");
        grid.setConstraints(label, clabel);
        panel.add(label);
        ctext.gridy = line++;
        this.widthField.setText("" + ExporterFactory.getRenderW());
        this.widthField.setMinimumSize(new Dimension(80, 19));
        grid.setConstraints(this.widthField, ctext);
        panel.add(this.widthField);
        clabel.gridy = line;
        label = new JLabel("Image height:");
        grid.setConstraints(label, clabel);
        panel.add(label);
        ctext.gridy = line;
        this.heightField.setText("" + ExporterFactory.getRenderH());
        this.heightField.setMinimumSize(new Dimension(80, 19));
        grid.setConstraints(this.heightField, ctext);
        panel.add(this.heightField);
        return panel;
    }

    class StartButtonListener
    implements ActionListener {
        StartButtonListener() {
        }

        public void actionPerformed(ActionEvent e) {
            ShieldedGUITreeGenerator treeGenerator = new ShieldedGUITreeGenerator(ExportDialog.this.frame, TreeGeneratorFactory.createTreeGenerator(ExportDialog.this.params));
            try {
                treeGenerator.setSeed(Integer.parseInt(ExportDialog.this.seedField.getText()));
                treeGenerator.setParam("Smooth", ExportDialog.this.smoothField.getText());
                ExporterFactory.setRenderW(Integer.parseInt(ExportDialog.this.widthField.getText()));
                ExporterFactory.setRenderH(Integer.parseInt(ExportDialog.this.heightField.getText()));
                ExporterFactory.setExportFormat(ExportDialog.this.formatBox.getSelectedIndex());
                ExporterFactory.setOutputStemUVs(ExportDialog.this.uvStemsCheckbox.isSelected());
                ExporterFactory.setOutputLeafUVs(ExportDialog.this.uvLeavesCheckbox.isSelected());
            }
            catch (Exception exc) {
                Console.printException(exc);
                ShowException.msgBox(ExportDialog.this.frame, "Export initialization error", exc);
            }
            ExportDialog.this.progressbar.setVisible(true);
            ExportDialog.this.startButton.setEnabled(false);
            ExportDialog.this.cancelButton.setText("Cancel");
            System.err.println("start creating tree and writing to " + ExportDialog.this.fileField.getText());
            File incfile = new File(ExportDialog.this.fileField.getText());
            File povfile = null;
            if (ExportDialog.this.sceneCheckbox.isSelected()) {
                povfile = new File(ExportDialog.this.sceneFileField.getText());
            }
            String imgFilename = null;
            if (ExportDialog.this.renderCheckbox.isSelected()) {
                imgFilename = ExportDialog.this.renderFileField.getText();
            }
            ExportDialog.this.treeCreationTask.start(treeGenerator, incfile, povfile, imgFilename);
            ExportDialog.this.timer.start();
        }
    }

    class CancelButtonListener
    implements ActionListener {
        CancelButtonListener() {
        }

        public void actionPerformed(ActionEvent e) {
            if (ExportDialog.this.treeCreationTask.notActive()) {
                ExportDialog.this.frame.dispose();
            } else {
                ExportDialog.this.treeCreationTask.stop();
                Toolkit.getDefaultToolkit().beep();
                ExportDialog.this.timer.stop();
                ExportDialog.this.startButton.setEnabled(true);
                ExportDialog.this.startButton.setText("Restart");
                ExportDialog.this.cancelButton.setText("Close");
                ExportDialog.this.progressbar.setVisible(false);
            }
        }
    }

    class TimerListener
    implements ActionListener {
        TimerListener() {
        }

        public void actionPerformed(ActionEvent event) {
            if (ExportDialog.this.treeCreationTask.notActive()) {
                ExportDialog.this.treeCreationTask.stop();
                ExportDialog.this.progressbar.setProgress(100);
                ExportDialog.this.progressbar.setNote("Ready");
                Toolkit.getDefaultToolkit().beep();
                ExportDialog.this.timer.stop();
                ExportDialog.this.startButton.setEnabled(true);
                ExportDialog.this.startButton.setText("Restart");
                ExportDialog.this.cancelButton.setText("Close");
            } else {
                ExportDialog.this.progressbar.setProgress(ExportDialog.this.treeCreationTask.getProgress());
                ExportDialog.this.progressbar.setNote(ExportDialog.this.treeCreationTask.getProgressMsg());
            }
        }
    }
}

