/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.arbaro.export;

import net.sourceforge.arbaro.export.AbstractExporter;
import net.sourceforge.arbaro.export.POVMeshLeafWriterBase;
import net.sourceforge.arbaro.mesh.Face;
import net.sourceforge.arbaro.mesh.LeafMesh;
import net.sourceforge.arbaro.tree.Leaf;

class POVMeshLeafUVFaceWriter
extends POVMeshLeafWriterBase {
    public POVMeshLeafUVFaceWriter(AbstractExporter exporter, LeafMesh leafMesh, long leafVertexOffset) {
        super(exporter, leafMesh, leafVertexOffset);
    }

    public boolean visitLeaf(Leaf l) {
        String indent = "    ";
        int i = 0;
        while (i < this.leafMesh.getShapeFaceCount()) {
            Face face = this.leafMesh.shapeFaceAt(i);
            this.w.print("<" + face.points[0] + "," + face.points[1] + "," + face.points[2] + ">");
            if (i < this.leafMesh.getShapeFaceCount() - 1) {
                this.w.print(",");
            }
            if (i % 6 == 4) {
                this.w.println();
                this.w.print(String.valueOf(indent) + "          ");
            }
            ++i;
        }
        this.w.println();
        this.exporter.incProgressCount(500);
        return true;
    }
}

