/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.arbaro.export;

import net.sourceforge.arbaro.export.AbstractExporter;
import net.sourceforge.arbaro.export.OBJLeafWriterBase;
import net.sourceforge.arbaro.mesh.LeafMesh;
import net.sourceforge.arbaro.transformation.Vector;
import net.sourceforge.arbaro.tree.Leaf;
import net.sourceforge.arbaro.tree.Tree;

class OBJLeafVertexWriter
extends OBJLeafWriterBase {
    String type;
    long vertexProgressCount = 0L;

    public OBJLeafVertexWriter(Tree tree, AbstractExporter exporter, LeafMesh leafMesh, int leafVertexOffset, String type) {
        super(tree, leafMesh, exporter, leafVertexOffset);
        this.type = type;
    }

    public boolean visitLeaf(Leaf l) {
        int i = 0;
        while (i < this.leafMesh.getShapeVertexCount()) {
            if (this.type == "v") {
                this.writeVertex(l.getTransformation().apply(this.leafMesh.shapeVertexAt((int)i).point), this.type);
            } else {
                this.writeVertex(l.getTransformation().apply(this.leafMesh.shapeVertexAt((int)i).normal), this.type);
            }
            ++i;
        }
        this.exporter.incProgressCount(500);
        return true;
    }

    private void writeVertex(Vector v, String type) {
        this.w.println(String.valueOf(type) + " " + fmt.format(v.getX()) + " " + fmt.format(v.getZ()) + " " + fmt.format(v.getY()));
    }
}

