/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.arbaro.export;

import net.sourceforge.arbaro.export.AbstractExporter;
import net.sourceforge.arbaro.export.DXFWriter;
import net.sourceforge.arbaro.export.Progress;
import net.sourceforge.arbaro.mesh.Face;
import net.sourceforge.arbaro.mesh.LeafMesh;
import net.sourceforge.arbaro.mesh.MeshGenerator;
import net.sourceforge.arbaro.mesh.VFace;
import net.sourceforge.arbaro.transformation.Vector;
import net.sourceforge.arbaro.tree.DefaultTreeTraversal;
import net.sourceforge.arbaro.tree.Leaf;
import net.sourceforge.arbaro.tree.Tree;

class DXFLeafWriter
extends DefaultTreeTraversal {
    LeafMesh leafMesh;
    VFace vFace;
    String layer;
    DXFWriter writer;
    AbstractExporter exporter;
    Progress progress;
    MeshGenerator meshGenerator;

    public DXFLeafWriter(AbstractExporter exporter, MeshGenerator meshGenerator, String layer) {
        this.layer = layer;
        this.exporter = exporter;
        this.writer = new DXFWriter(exporter.getWriter());
        this.vFace = new VFace(new Vector(), new Vector(), new Vector());
        this.meshGenerator = meshGenerator;
    }

    public boolean enterTree(Tree tree) {
        this.leafMesh = this.meshGenerator.createLeafMesh(tree, false);
        return true;
    }

    public boolean visitLeaf(Leaf leaf) {
        int i = 0;
        while (i < this.leafMesh.getShapeFaceCount()) {
            Face face = this.leafMesh.shapeFaceAt(i);
            int k = 0;
            while (k < 3) {
                this.vFace.points[k] = leaf.getTransformation().apply(this.leafMesh.shapeVertexAt((int)((int)face.points[k])).point);
                ++k;
            }
            this.writer.writeFace(this.vFace, this.layer);
            ++i;
        }
        this.exporter.incProgressCount(500);
        return true;
    }
}

