/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.arbaro.export;

import java.io.PrintWriter;
import java.text.NumberFormat;
import java.util.Enumeration;
import net.sourceforge.arbaro.export.AbstractExporter;
import net.sourceforge.arbaro.params.FloatFormat;
import net.sourceforge.arbaro.params.Params;
import net.sourceforge.arbaro.transformation.Vector;
import net.sourceforge.arbaro.tree.Leaf;
import net.sourceforge.arbaro.tree.Stem;
import net.sourceforge.arbaro.tree.StemSection;
import net.sourceforge.arbaro.tree.Tree;
import net.sourceforge.arbaro.tree.TreeTraversal;

class POVConeStemWriter
implements TreeTraversal {
    Tree tree;
    AbstractExporter exporter;
    PrintWriter w;
    Params params;
    int level;

    public POVConeStemWriter(AbstractExporter exporter, int level) {
        this.exporter = exporter;
        this.w = exporter.getWriter();
        this.level = level;
    }

    public boolean enterStem(Stem stem) {
        if (this.level >= 0 && stem.getLevel() < this.level) {
            return true;
        }
        if (this.level >= 0 && stem.getLevel() > this.level) {
            return false;
        }
        String indent = this.whitespace(stem.getLevel() * 2 + 4);
        NumberFormat fmt = FloatFormat.getInstance();
        Enumeration sections = stem.sections();
        if (sections.hasMoreElements()) {
            StemSection from = (StemSection)sections.nextElement();
            StemSection to = null;
            while (sections.hasMoreElements()) {
                to = (StemSection)sections.nextElement();
                this.w.println(String.valueOf(indent) + "cone   { " + this.vectorStr(from.getPosition()) + ", " + fmt.format(from.getRadius()) + ", " + this.vectorStr(to.getPosition()) + ", " + fmt.format(to.getRadius()) + " }");
                if (!from.getZ().equals(to.getPosition().sub(from.getPosition()).normalize())) {
                    this.w.println(String.valueOf(indent) + "sphere { " + this.vectorStr(from.getPosition()) + ", " + fmt.format(from.getRadius() - 1.0E-4) + " }");
                }
                from = to;
            }
        }
        this.exporter.incProgressCount(100);
        return true;
    }

    private String vectorStr(Vector v) {
        NumberFormat fmt = FloatFormat.getInstance();
        return "<" + fmt.format(v.getX()) + "," + fmt.format(v.getZ()) + "," + fmt.format(v.getY()) + ">";
    }

    private String whitespace(int len) {
        char[] ws = new char[len];
        int i = 0;
        while (i < len) {
            ws[i] = 32;
            ++i;
        }
        return new String(ws);
    }

    public boolean enterTree(Tree tree) {
        this.tree = tree;
        return true;
    }

    public boolean leaveStem(Stem stem) {
        return true;
    }

    public boolean leaveTree(Tree tree) {
        this.w.flush();
        return true;
    }

    public boolean visitLeaf(Leaf leaf) {
        return false;
    }
}

