/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.arbaro.tree;

import java.util.Enumeration;
import java.util.NoSuchElementException;
import java.util.Vector;
import net.sourceforge.arbaro.export.Console;
import net.sourceforge.arbaro.params.LevelParams;
import net.sourceforge.arbaro.params.Params;
import net.sourceforge.arbaro.transformation.Transformation;
import net.sourceforge.arbaro.tree.Leaf;
import net.sourceforge.arbaro.tree.LeafImpl;
import net.sourceforge.arbaro.tree.SegmentImpl;
import net.sourceforge.arbaro.tree.Stem;
import net.sourceforge.arbaro.tree.TreeImpl;
import net.sourceforge.arbaro.tree.TreeTraversal;

class StemImpl
implements Stem {
    TreeImpl tree;
    Params par;
    LevelParams lpar;
    StemImpl parent;
    StemImpl clonedFrom = null;
    Transformation transf;
    net.sourceforge.arbaro.transformation.Vector minPoint;
    net.sourceforge.arbaro.transformation.Vector maxPoint;
    static final double MIN_STEM_LEN = 5.0E-4;
    static final double MIN_STEM_RADIUS = 5.0E-5;
    public int stemlevel;
    double offset;
    Vector segments;
    Vector clones;
    Vector substems;
    Vector leaves;
    double length;
    double segmentLength;
    int segmentCount;
    double baseRadius;
    double lengthChildMax;
    double substemsPerSegment;
    double substemRotangle;
    double leavesPerSegment;
    double splitCorrection;
    boolean pruneTest;
    int index;
    Vector cloneIndex;

    public Transformation getTransformation() {
        return this.transf;
    }

    public net.sourceforge.arbaro.transformation.Vector getMinPoint() {
        return this.minPoint;
    }

    public net.sourceforge.arbaro.transformation.Vector getMaxPoint() {
        return this.maxPoint;
    }

    public double getLength() {
        return this.length;
    }

    public Enumeration sections() {
        return new SectionsEnumerator(this);
    }

    public Enumeration stemSegments() {
        return this.segments.elements();
    }

    public Enumeration stemLeaves() {
        return this.leaves.elements();
    }

    public StemImpl(TreeImpl tr, StemImpl growsOutOf, int stlev, Transformation trf, double offs) {
        this.tree = tr;
        this.stemlevel = stlev;
        this.transf = trf;
        this.offset = offs;
        if (growsOutOf != null) {
            if (growsOutOf.stemlevel < this.stemlevel) {
                this.parent = growsOutOf;
            } else {
                this.clonedFrom = growsOutOf;
                this.parent = growsOutOf.parent;
            }
        }
        this.par = this.tree.params;
        this.lpar = this.par.getLevelParams(this.stemlevel);
        this.segments = new Vector(this.lpar.nCurveRes);
        if (this.lpar.nSegSplits > 0.0 || this.par._0BaseSplits > 0) {
            this.clones = new Vector();
        }
        if (this.stemlevel < this.par.Levels - 1) {
            LevelParams lpar_1 = this.par.getLevelParams(this.lpar.level + 1);
            this.substems = new Vector(lpar_1.nBranches);
        }
        if (this.stemlevel == this.par.Levels - 1 && this.par.Leaves != 0) {
            this.leaves = new Vector(Math.abs(this.par.Leaves));
        }
        this.leavesPerSegment = 0.0;
        this.splitCorrection = 0.0;
        this.index = 0;
        this.cloneIndex = new Vector();
        this.pruneTest = false;
        this.maxPoint = new net.sourceforge.arbaro.transformation.Vector(-1.7976931348623157E308, -1.7976931348623157E308, -1.7976931348623157E308);
        this.minPoint = new net.sourceforge.arbaro.transformation.Vector(Double.MAX_VALUE, Double.MAX_VALUE, Double.MAX_VALUE);
    }

    void TRF(String where, Transformation trf) {
        this.DBG(String.valueOf(where) + ": " + trf.toString());
    }

    public void DBG(String dbgstr) {
        Console.debugOutput(String.valueOf(this.getTreePosition()) + ":" + dbgstr);
    }

    public String getTreePosition() {
        StemImpl stem = this;
        int lev = this.stemlevel;
        String pos = "";
        while (lev >= 0) {
            if (stem.cloneIndex.size() > 0) {
                String clonestr = "";
                int i = 0;
                while (i < stem.cloneIndex.size()) {
                    clonestr = String.valueOf(clonestr) + "c" + ((Integer)stem.cloneIndex.elementAt(i)).toString();
                    ++i;
                }
                pos = stem.index + clonestr + "." + pos;
            } else {
                pos = stem.index + "." + pos;
            }
            if (lev > 0) {
                stem = stem.parent;
            }
            --lev;
        }
        if (pos.charAt(pos.length() - 1) == '.') {
            pos = pos.substring(0, pos.length() - 1);
        }
        return pos;
    }

    public int getLevel() {
        return this.stemlevel;
    }

    public double getBaseRadius() {
        return ((SegmentImpl)this.segments.elementAt((int)0)).rad1;
    }

    public double getPeakRadius() {
        return ((SegmentImpl)this.segments.elementAt((int)(this.segments.size() - 1))).rad2;
    }

    StemImpl clone(Transformation trf, int start_segm) {
        StemImpl clone = new StemImpl(this.tree, this, this.stemlevel, trf, this.offset);
        clone.segmentLength = this.segmentLength;
        clone.segmentCount = this.segmentCount;
        clone.length = this.length;
        clone.baseRadius = this.baseRadius;
        clone.splitCorrection = this.splitCorrection;
        clone.pruneTest = this.pruneTest;
        clone.index = this.index;
        clone.cloneIndex.addAll(this.cloneIndex);
        clone.cloneIndex.addElement(new Integer(this.clones.size()));
        if (!this.pruneTest) {
            clone.lengthChildMax = this.lengthChildMax;
            clone.substemsPerSegment = this.substemsPerSegment;
            clone.substemRotangle = this.substemRotangle + 180.0;
            clone.leavesPerSegment = this.leavesPerSegment;
        }
        return clone;
    }

    public boolean make() {
        this.segmentCount = this.lpar.nCurveRes;
        this.length = this.stemLength();
        this.segmentLength = this.length / (double)this.lpar.nCurveRes;
        this.baseRadius = this.stemBaseRadius();
        if (this.stemlevel == 0) {
            double baseWidth = Math.max(this.baseRadius, this.stemRadius(0.0));
            this.minMaxTest(new net.sourceforge.arbaro.transformation.Vector(baseWidth, baseWidth, 0.0));
        }
        if (Console.debug()) {
            this.DBG("Stem.make(): len: " + this.length + " sgm_cnt: " + this.segmentCount + " base_rad: " + this.baseRadius);
        }
        if (this.stemlevel > 0 && this.par.PruneRatio > 0.0) {
            this.pruning();
        }
        if (this.length > 5.0E-4 && this.baseRadius > 5.0E-5) {
            this.prepareSubstemParams();
            this.makeSegments(0, this.segmentCount);
            return true;
        }
        this.DBG("length " + this.length + " (after pruning?) to small - stem not created");
        return false;
    }

    void pruning() {
        this.lpar.saveState();
        double splitcorr = this.splitCorrection;
        double origlen = this.length;
        this.pruneTest = true;
        int segm = this.makeSegments(0, this.segmentCount);
        while (segm >= 0 && this.length > 0.001 * this.par.scale_tree) {
            this.lpar.restoreState();
            this.splitCorrection = splitcorr;
            if (this.clones != null) {
                this.clones.clear();
            }
            this.segments.clear();
            double minlen = this.length / 2.0;
            double maxlen = this.length - origlen / 15.0;
            this.length = Math.min(Math.max(this.segmentLength * (double)segm, minlen), maxlen);
            this.segmentLength = this.length / (double)this.lpar.nCurveRes;
            this.baseRadius = this.stemBaseRadius();
            if (this.length > 5.0E-4 && this.baseRadius < 5.0E-5) {
                Console.errorOutput("WARNING: stem radius (" + this.baseRadius + ") too small for stem " + this.getTreePosition());
            }
            if (!(this.length > 5.0E-4)) continue;
            segm = this.makeSegments(0, this.segmentCount);
        }
        this.length = origlen - (origlen - this.length) * this.par.PruneRatio;
        this.lpar.restoreState();
        this.splitCorrection = splitcorr;
        if (this.clones != null) {
            this.clones.clear();
        }
        this.segments.clear();
        this.pruneTest = false;
    }

    double stemLength() {
        if (this.stemlevel == 0) {
            return (this.lpar.nLength + this.lpar.var(this.lpar.nLengthV)) * this.par.scale_tree;
        }
        if (this.stemlevel == 1) {
            double parlen = this.parent.length;
            double baselen = this.par.BaseSize * this.par.scale_tree;
            double ratio = (parlen - this.offset) / (parlen - baselen);
            if (Console.debug()) {
                this.DBG("Stem.stem_length(): parlen: " + parlen + " offset: " + this.offset + " baselen: " + baselen + " ratio: " + ratio);
            }
            return parlen * this.parent.lengthChildMax * this.par.getShapeRatio(ratio);
        }
        return this.parent.lengthChildMax * (this.parent.length - 0.6 * this.offset);
    }

    int makeSegments(int start_seg, int end_seg) {
        if (this.stemlevel == 1) {
            this.tree.updateGenProgress();
        }
        if (!this.pruneTest) {
            if (this.stemlevel == 0) {
                Console.progressChar('=');
            } else if (this.stemlevel == 1 && start_seg == 0) {
                Console.progressChar('/');
            } else if (this.stemlevel == 2 && start_seg == 0) {
                Console.progressChar();
            }
        }
        Transformation trf = this.transf;
        int s = start_seg;
        while (s < end_seg) {
            int segm;
            if (this.stemlevel == 0) {
                this.tree.updateGenProgress();
            }
            if (!this.pruneTest && this.stemlevel == 0) {
                Console.progressChar('|');
            }
            trf = this.newDirection(trf, s);
            if (Console.debug()) {
                this.TRF("Stem.make_segments(): after new_direction ", trf);
            }
            double rad1 = this.stemRadius((double)s * this.segmentLength);
            double rad2 = this.stemRadius((double)(s + 1) * this.segmentLength);
            SegmentImpl segment = new SegmentImpl(this, s, trf, rad1, rad2);
            segment.make();
            this.segments.addElement(segment);
            if (!this.pruneTest && this.lpar.level < this.par.Levels - 1) {
                this.makeSubstems(segment);
            }
            if (!this.pruneTest && this.lpar.level == this.par.Levels - 1 && this.par.Leaves != 0) {
                this.makeLeaves(segment);
            }
            trf = trf.translate(trf.getZ().mul(this.segmentLength));
            if (this.pruneTest && !this.isInsideEnvelope(trf.getT())) {
                return s;
            }
            if (s < end_seg - 1 && (segm = this.makeClones(trf, s)) >= 0) {
                return segm;
            }
            ++s;
        }
        return -1;
    }

    boolean isInsideEnvelope(net.sourceforge.arbaro.transformation.Vector vector) {
        double ratio;
        double r = Math.sqrt(vector.getX() * vector.getX() + vector.getY() * vector.getY());
        return r / this.par.scale_tree < this.par.PruneWidth * this.par.getShapeRatio(ratio = (this.par.scale_tree - vector.getZ()) / (this.par.scale_tree * (1.0 - this.par.BaseSize)), 8);
    }

    Transformation newDirection(Transformation trf, int nsegm) {
        if (nsegm == 0) {
            return trf;
        }
        if (Console.debug()) {
            this.TRF("Stem.new_direction() before curving", trf);
        }
        double delta = this.lpar.nCurveBack == 0.0 ? this.lpar.nCurve / (double)this.lpar.nCurveRes : (nsegm < (this.lpar.nCurveRes + 1) / 2 ? this.lpar.nCurve * 2.0 / (double)this.lpar.nCurveRes : this.lpar.nCurveBack * 2.0 / (double)this.lpar.nCurveRes);
        delta += this.splitCorrection;
        if (Console.debug()) {
            this.DBG("Stem.new_direction(): delta: " + delta);
        }
        trf = trf.rotx(delta);
        if (this.lpar.nCurveV > 0.0) {
            delta = this.lpar.var(this.lpar.nCurveV) / (double)this.lpar.nCurveRes;
            double rho = 180.0 + this.lpar.var(180.0);
            trf = trf.rotaxisz(delta, rho);
        }
        this.TRF("Stem.new_direction() after curving", trf);
        if (this.par.AttractionUp != 0.0 && this.stemlevel >= 2) {
            double declination = Math.acos(trf.getZ().getZ());
            double curve_up = this.par.AttractionUp * Math.abs(declination * Math.sin(declination)) / (double)this.lpar.nCurveRes;
            net.sourceforge.arbaro.transformation.Vector z = trf.getZ();
            trf = trf.rotaxis(-curve_up * 180.0 / Math.PI, new net.sourceforge.arbaro.transformation.Vector(-z.getY(), z.getX(), 0.0));
        }
        return trf;
    }

    double stemBaseRadius() {
        if (this.stemlevel == 0) {
            return this.length * this.par.Ratio;
        }
        double max_radius = this.parent.stemRadius(this.offset);
        double radius = this.parent.baseRadius * Math.pow(this.length / this.parent.length, this.par.RatioPower);
        return Math.min(radius, max_radius);
    }

    public double stemRadius(double h) {
        if (Console.debug()) {
            this.DBG("Stem.stem_radius(" + h + ") base_rad:" + this.baseRadius);
        }
        double angle = 0.0;
        double Z = Math.min(h / this.length, 1.0);
        double taper = this.lpar.nTaper;
        double unit_taper = 0.0;
        if (taper <= 1.0) {
            unit_taper = taper;
        } else if (taper <= 2.0) {
            unit_taper = 2.0 - taper;
        }
        double radius = this.baseRadius * (1.0 - unit_taper * Z);
        if (taper > 1.0) {
            double Z2 = (1.0 - Z) * this.length;
            double depth = taper < 2.0 || Z2 < radius ? 1.0 : taper - 2.0;
            double Z3 = taper < 2.0 ? Z2 : Math.abs(Z2 - 2.0 * radius * (double)((int)(Z2 / 2.0 / radius + 0.5)));
            if (taper > 2.0 || Z3 < radius) {
                radius = (1.0 - depth) * radius + depth * Math.sqrt(radius * radius - (Z3 - radius) * (Z3 - radius));
            }
        }
        if (this.stemlevel == 0) {
            if (this.par.Flare != 0.0) {
                double y = Math.max(0.0, 1.0 - 8.0 * Z);
                double flare = 1.0 + this.par.Flare * (Math.pow(100.0, y) - 1.0) / 100.0;
                this.DBG("Stem.stem_radius(): Flare: " + flare + " h: " + h + " Z: " + Z);
                radius *= flare;
            }
            if (this.par.Lobes > 0 && angle != 0.0) {
                radius *= 1.0 + this.par.LobeDepth * Math.sin((double)this.par.Lobes * angle * Math.PI / 180.0);
            }
            radius *= this.par._0Scale;
        }
        this.DBG("Stem.stem_radius(" + h + ") = " + radius);
        return radius;
    }

    void prepareSubstemParams() {
        LevelParams lpar_1 = this.par.getLevelParams(this.stemlevel + 1);
        this.lengthChildMax = lpar_1.nLength + lpar_1.var(lpar_1.nLengthV);
        double stems_max = lpar_1.nBranches;
        if (this.stemlevel == 0) {
            double substem_cnt = stems_max;
            this.substemsPerSegment = substem_cnt / (double)this.segmentCount / (1.0 - this.par.BaseSize);
            if (Console.debug()) {
                this.DBG("Stem.prepare_substem_params(): stems_max: " + substem_cnt + " substems_per_segment: " + this.substemsPerSegment);
            }
        } else if (this.par.preview) {
            double substem_cnt = stems_max;
            this.substemsPerSegment = substem_cnt / (double)this.segmentCount;
        } else if (this.stemlevel == 1) {
            double substem_cnt = (int)(stems_max * (0.2 + 0.8 * this.length / this.parent.length / this.parent.lengthChildMax));
            this.substemsPerSegment = substem_cnt / (double)this.segmentCount;
            this.DBG("Stem.prepare_substem_params(): substem_cnt: " + substem_cnt + " substems_per_segment: " + this.substemsPerSegment);
        } else {
            double substem_cnt = (int)(stems_max * (1.0 - 0.5 * this.offset / this.parent.length));
            this.substemsPerSegment = substem_cnt / (double)this.segmentCount;
        }
        this.substemRotangle = 0.0;
        if (this.lpar.level == this.par.Levels - 1) {
            this.leavesPerSegment = this.leavesPerBranch() / (double)this.segmentCount;
        }
    }

    double leavesPerBranch() {
        if (this.par.Leaves == 0) {
            return 0.0;
        }
        if (this.stemlevel == 0) {
            System.err.println("WARNING: trunk cannot have leaves, no leaves are created");
            return 0.0;
        }
        return (double)Math.abs(this.par.Leaves) * this.par.getShapeRatio(this.offset / this.parent.length, this.par.LeafDistrib) * this.par.LeafQuality;
    }

    void makeSubstems(SegmentImpl segment) {
        double offs;
        double subst_per_segm;
        LevelParams lpar_1 = this.par.getLevelParams(this.stemlevel + 1);
        if (Console.debug()) {
            this.DBG("Stem.make_substems(): substems_per_segment " + this.substemsPerSegment);
        }
        if (this.stemlevel > 0) {
            subst_per_segm = this.substemsPerSegment;
            offs = segment.index == 0 ? this.parent.stemRadius(this.offset) / this.segmentLength : 0.0;
        } else if ((double)segment.index * this.segmentLength > this.par.BaseSize * this.length) {
            subst_per_segm = this.substemsPerSegment;
            offs = 0.0;
        } else {
            if ((double)(segment.index + 1) * this.segmentLength <= this.par.BaseSize * this.length) {
                return;
            }
            offs = (this.par.BaseSize * this.length - (double)segment.index * this.segmentLength) / this.segmentLength;
            subst_per_segm = this.substemsPerSegment * (1.0 - offs);
        }
        int substems_eff = (int)(subst_per_segm + this.lpar.substemErrorValue + 0.5);
        this.lpar.substemErrorValue -= (double)substems_eff - subst_per_segm;
        if (substems_eff <= 0) {
            return;
        }
        this.DBG("Stem.make_substems(): substems_eff: " + substems_eff);
        double dist = (1.0 - offs) / (double)substems_eff * lpar_1.nBranchDist;
        double distv = dist * 0.25;
        this.DBG("Stem.make_substems(): offs: " + offs + " dist: " + dist + " distv: " + distv);
        int s = 0;
        while (s < substems_eff) {
            double where = offs + dist / 2.0 + (double)s * dist + lpar_1.var(distv);
            double offset = ((double)segment.index + where) * this.segmentLength;
            this.DBG("Stem.make_substems(): offset: " + offset + " segminx: " + segment.index + " where: " + where + " seglen: " + this.segmentLength);
            Transformation trf = this.substemDirection(segment.transf, offset);
            trf = segment.substemPosition(trf, where);
            StemImpl substem = new StemImpl(this.tree, this, this.stemlevel + 1, trf, offset);
            substem.index = this.substems.size();
            this.DBG("Stem.make_substems(): make new substem");
            if (substem.make()) {
                this.substems.addElement(substem);
            }
            ++s;
        }
    }

    Transformation substemDirection(Transformation trf, double offset) {
        double downangle;
        double rotangle;
        LevelParams lpar_1 = this.par.getLevelParams(this.stemlevel + 1);
        if (lpar_1.nRotate >= 0.0) {
            rotangle = this.substemRotangle = (this.substemRotangle + lpar_1.nRotate + lpar_1.var(lpar_1.nRotateV) + 360.0) % 360.0;
        } else {
            if (Math.abs(this.substemRotangle) != 1.0) {
                this.substemRotangle = 1.0;
            }
            this.substemRotangle = -this.substemRotangle;
            rotangle = this.substemRotangle * (180.0 + lpar_1.nRotate + lpar_1.var(lpar_1.nRotateV));
        }
        if (lpar_1.nDownAngleV >= 0.0) {
            downangle = lpar_1.nDownAngle + lpar_1.var(lpar_1.nDownAngleV);
        } else {
            double len = this.stemlevel == 0 ? this.length * (1.0 - this.par.BaseSize) : this.length;
            downangle = lpar_1.nDownAngle + lpar_1.nDownAngleV * (1.0 - 2.0 * this.par.getShapeRatio((this.length - offset) / len, 0));
        }
        if (Console.debug()) {
            this.DBG("Stem.substem_direction(): down: " + downangle + " rot: " + rotangle);
        }
        return trf.rotxz(downangle, rotangle);
    }

    void makeLeaves(SegmentImpl segment) {
        block7: {
            block6: {
                if (this.par.Leaves <= 0) break block6;
                double leaves_eff = (int)(this.leavesPerSegment + this.par.leavesErrorValue + 0.5);
                this.par.leavesErrorValue -= leaves_eff - this.leavesPerSegment;
                if (leaves_eff <= 0.0) {
                    return;
                }
                double offs = segment.index == 0 ? this.parent.stemRadius(this.offset) / this.segmentLength : 0.0;
                double dist = (1.0 - offs) / leaves_eff;
                int s = 0;
                while ((double)s < leaves_eff) {
                    double where = offs + dist / 2.0 + (double)s * dist + this.lpar.var(dist / 2.0);
                    double loffs = ((double)segment.index + where) * this.segmentLength;
                    Transformation trf = this.substemDirection(segment.transf, loffs);
                    trf = trf.translate(segment.transf.getZ().mul(where * this.segmentLength));
                    LeafImpl leaf = new LeafImpl(trf);
                    leaf.make(this.par);
                    this.leaves.addElement(leaf);
                    ++s;
                }
                break block7;
            }
            if (this.par.Leaves >= 0 || segment.index != this.segmentCount - 1) break block7;
            LevelParams lpar_1 = this.par.getLevelParams(this.stemlevel + 1);
            int cnt = (int)(this.leavesPerBranch() + 0.5);
            Transformation trf = segment.transf.translate(segment.transf.getZ().mul(this.segmentLength));
            double distangle = lpar_1.nRotate / (double)cnt;
            double varangle = lpar_1.nRotateV / (double)cnt;
            double downangle = lpar_1.nDownAngle;
            double vardown = lpar_1.nDownAngleV;
            double offsetangle = 0.0;
            if (cnt % 2 == 1) {
                LeafImpl leaf = new LeafImpl(trf);
                leaf.make(this.par);
                this.leaves.addElement(leaf);
                offsetangle = distangle;
            } else {
                offsetangle = distangle / 2.0;
            }
            int s = 0;
            while (s < cnt / 2) {
                int rot = 1;
                while (rot >= -1) {
                    Transformation transf1 = trf.roty((double)rot * (offsetangle + (double)s * distangle + lpar_1.var(varangle)));
                    transf1 = transf1.rotx(downangle + lpar_1.var(vardown));
                    LeafImpl leaf = new LeafImpl(transf1);
                    leaf.make(this.par);
                    this.leaves.addElement(leaf);
                    rot -= 2;
                }
                ++s;
            }
        }
    }

    int makeClones(Transformation trf, int nseg) {
        int seg_splits_eff;
        if (this.stemlevel == 0 && nseg == 0 && this.par._0BaseSplits > 0) {
            seg_splits_eff = this.par._0BaseSplits;
        } else {
            double seg_splits = this.lpar.nSegSplits;
            seg_splits_eff = (int)(seg_splits + this.lpar.splitErrorValue + 0.5);
            this.lpar.splitErrorValue -= (double)seg_splits_eff - seg_splits;
        }
        if (seg_splits_eff < 1) {
            return -1;
        }
        double s_angle = 360 / (seg_splits_eff + 1);
        int i = 0;
        while (i < seg_splits_eff) {
            StemImpl clone = this.clone(trf, nseg + 1);
            clone.transf = clone.split(trf, s_angle * (double)(1 + i), nseg, seg_splits_eff);
            int segm = clone.makeSegments(nseg + 1, clone.segmentCount);
            if (segm >= 0) {
                return segm;
            }
            this.clones.addElement(clone);
            ++i;
        }
        trf = this.split(trf, 0.0, nseg, seg_splits_eff);
        return -1;
    }

    Transformation split(Transformation trf, double s_angle, int nseg, int nsplits) {
        int remaining_seg = this.segmentCount - nseg - 1;
        double declination = Math.acos(trf.getZ().getZ()) * 180.0 / Math.PI;
        double split_angle = Math.max(0.0, this.lpar.nSplitAngle + this.lpar.var(this.lpar.nSplitAngleV) - declination);
        trf = trf.rotx(split_angle);
        this.splitCorrection -= split_angle / (double)remaining_seg;
        if (s_angle > 0.0) {
            double split_diverge;
            if (this.par._0BaseSplits > 0 && this.stemlevel == 0 && nseg == 0) {
                split_diverge = s_angle + this.lpar.var(this.lpar.nSplitAngleV);
            } else {
                split_diverge = 20.0 + 0.75 * (30.0 + Math.abs(declination - 90.0)) * Math.pow((this.lpar.var(1.0) + 1.0) / 2.0, 2.0);
                if (this.lpar.var(1.0) >= 0.0) {
                    split_diverge = -split_diverge;
                }
            }
            trf = trf.rotaxis(split_diverge, net.sourceforge.arbaro.transformation.Vector.Z_AXIS);
        } else {
            double split_diverge = 0.0;
        }
        if (!this.pruneTest) {
            this.substemsPerSegment /= (double)(nsplits + 1);
        }
        return trf;
    }

    public boolean traverseTree(TreeTraversal traversal) {
        if (traversal.enterStem(this)) {
            Enumeration s;
            if (this.leaves != null) {
                Enumeration l = this.leaves.elements();
                while (l.hasMoreElements()) {
                    if (!((Leaf)l.nextElement()).traverseTree(traversal)) break;
                }
            }
            if (this.substems != null) {
                s = this.substems.elements();
                while (s.hasMoreElements()) {
                    if (!((Stem)s.nextElement()).traverseTree(traversal)) break;
                }
            }
            if (this.clones != null) {
                s = this.clones.elements();
                while (s.hasMoreElements()) {
                    if (!((Stem)s.nextElement()).traverseTree(traversal)) break;
                }
            }
        }
        return traversal.leaveStem(this);
    }

    long substemTotal() {
        if (this.substems == null) {
            return 0L;
        }
        long sum = this.substems.size();
        int i = 0;
        while (i < this.substems.size()) {
            sum += ((StemImpl)this.substems.elementAt(i)).substemTotal();
            ++i;
        }
        return sum;
    }

    public long getLeafCount() {
        if (this.leaves != null) {
            return this.leaves.size();
        }
        return 0L;
    }

    public boolean isClone() {
        return this.cloneIndex.size() > 0;
    }

    public boolean isSmooth() {
        return this.stemlevel <= this.par.smooth_mesh_level;
    }

    public int getCloneSectionOffset() {
        if (!this.isClone()) {
            return 0;
        }
        int segInx = ((SegmentImpl)this.segments.elementAt((int)0)).index;
        return this.clonedFrom.getSectionCountBelow(segInx);
    }

    protected int getSectionCountBelow(int index) {
        int count = 1;
        Enumeration segs = this.segments.elements();
        while (segs.hasMoreElements()) {
            SegmentImpl s = (SegmentImpl)segs.nextElement();
            if (s.index < index) {
                count += s.subsegments.size();
                continue;
            }
            return count - 1;
        }
        return count - 1;
    }

    public void minMaxTest(net.sourceforge.arbaro.transformation.Vector pt) {
        this.maxPoint.setMaxCoord(pt);
        this.minPoint.setMinCoord(pt);
        if (this.clonedFrom != null) {
            this.clonedFrom.minMaxTest(pt);
        }
        if (this.parent != null) {
            this.parent.minMaxTest(pt);
        } else {
            this.tree.minMaxTest(pt);
        }
    }

    private class SectionsEnumerator
    implements Enumeration {
        private Enumeration segments;
        private Enumeration subsegments;

        public SectionsEnumerator(StemImpl stem) {
            this.segments = stem.segments.elements();
        }

        public boolean hasMoreElements() {
            return this.subsegments != null && this.subsegments.hasMoreElements() || this.segments.hasMoreElements();
        }

        public Object nextElement() {
            if (this.subsegments == null) {
                SegmentImpl s = (SegmentImpl)this.segments.nextElement();
                this.subsegments = s.subsegments.elements();
                return s;
            }
            if (this.subsegments.hasMoreElements()) {
                return this.subsegments.nextElement();
            }
            if (this.segments.hasMoreElements()) {
                SegmentImpl s = (SegmentImpl)this.segments.nextElement();
                this.subsegments = s.subsegments.elements();
                return this.subsegments.nextElement();
            }
            throw new NoSuchElementException("SectionsEnumerator");
        }
    }
}

