/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.arbaro.transformation;

import net.sourceforge.arbaro.transformation.Matrix;
import net.sourceforge.arbaro.transformation.Vector;

public final class Transformation {
    public static final int X = 0;
    public static final int Y = 1;
    public static final int Z = 2;
    public static final int T = 3;
    Matrix matrix;
    Vector vector;

    public Transformation() {
        this.matrix = new Matrix();
        this.vector = new Vector();
    }

    public Transformation(Matrix m, Vector v) {
        this.matrix = m;
        this.vector = v;
    }

    public Matrix matrix() {
        return this.matrix;
    }

    public Vector vector() {
        return this.vector;
    }

    public Transformation prod(Transformation T1) {
        return new Transformation(this.matrix.prod(T1.matrix()), this.matrix.prod(T1.vector()).add(this.vector));
    }

    public Vector apply(Vector v) {
        return this.matrix.prod(v).add(this.vector);
    }

    public Vector getX() {
        return this.matrix.col(0);
    }

    public Vector getY() {
        return this.matrix.col(1);
    }

    public Vector getZ() {
        return this.matrix.col(2);
    }

    public Vector getT() {
        return this.vector;
    }

    public String toString() {
        return "x: " + this.getX() + ", y: " + this.getY() + ", z: " + this.getZ() + ", t: " + this.getT();
    }

    public Transformation rotz(double angle) {
        double radAngle = angle * Math.PI / 180.0;
        Matrix rm = new Matrix(Math.cos(radAngle), -Math.sin(radAngle), 0.0, Math.sin(radAngle), Math.cos(radAngle), 0.0, 0.0, 0.0, 1.0);
        return new Transformation(this.matrix.prod(rm), this.vector);
    }

    public Transformation roty(double angle) {
        double radAngle = angle * Math.PI / 180.0;
        Matrix rm = new Matrix(Math.cos(radAngle), 0.0, -Math.sin(radAngle), 0.0, 1.0, 0.0, Math.sin(radAngle), 0.0, Math.cos(radAngle));
        return new Transformation(this.matrix.prod(rm), this.vector);
    }

    public Transformation rotx(double angle) {
        double radAngle = angle * Math.PI / 180.0;
        Matrix rm = new Matrix(1.0, 0.0, 0.0, 0.0, Math.cos(radAngle), -Math.sin(radAngle), 0.0, Math.sin(radAngle), Math.cos(radAngle));
        return new Transformation(this.matrix.prod(rm), this.vector);
    }

    public Transformation rotxz(double delta, double rho) {
        double radDelta = delta * Math.PI / 180.0;
        double radRho = rho * Math.PI / 180.0;
        double sir = Math.sin(radRho);
        double cor = Math.cos(radRho);
        double sid = Math.sin(radDelta);
        double cod = Math.cos(radDelta);
        Matrix rm = new Matrix(cor, -sir * cod, sir * sid, sir, cor * cod, -cor * sid, 0.0, sid, cod);
        return new Transformation(this.matrix.prod(rm), this.vector);
    }

    public Transformation rotaxisz(double delta, double rho) {
        double radDelta = delta * Math.PI / 180.0;
        double radRho = rho * Math.PI / 180.0;
        double a = Math.cos(radRho);
        double b = Math.sin(radRho);
        double si = Math.sin(radDelta);
        double co = Math.cos(radDelta);
        Matrix rm = new Matrix(co + a * a * (1.0 - co), b * a * (1.0 - co), b * si, a * b * (1.0 - co), co + b * b * (1.0 - co), -a * si, -b * si, a * si, co);
        return new Transformation(this.matrix.prod(rm), this.vector);
    }

    public Transformation translate(Vector v) {
        return new Transformation(this.matrix, this.vector.add(v));
    }

    public Transformation rotaxis(double angle, Vector axis) {
        double radAngle = angle * Math.PI / 180.0;
        Vector normAxis = axis.normalize();
        double a = normAxis.getX();
        double b = normAxis.getY();
        double c = normAxis.getZ();
        double si = Math.sin(radAngle);
        double co = Math.cos(radAngle);
        Matrix rm = new Matrix(co + a * a * (1.0 - co), -c * si + b * a * (1.0 - co), b * si + c * a * (1.0 - co), c * si + a * b * (1.0 - co), co + b * b * (1.0 - co), -a * si + c * b * (1.0 - co), -b * si + a * c * (1.0 - co), a * si + b * c * (1.0 - co), co + c * c * (1.0 - co));
        return new Transformation(rm.prod(this.matrix), this.vector);
    }

    public Transformation inverse() {
        Matrix T1 = this.matrix.transpose();
        return new Transformation(T1, T1.prod(this.vector.mul(-1.0)));
    }
}

