/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.arbaro.gui;

import java.awt.Component;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileWriter;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import net.sourceforge.arbaro.export.Console;
import net.sourceforge.arbaro.export.ExporterFactory;
import net.sourceforge.arbaro.export.Progress;
import net.sourceforge.arbaro.gui.Config;
import net.sourceforge.arbaro.gui.ShieldedGUIExporter;
import net.sourceforge.arbaro.gui.SwingWorker;
import net.sourceforge.arbaro.tree.Tree;
import net.sourceforge.arbaro.tree.TreeGenerator;

class TreeCreationTask {
    TreeGenerator treeGenerator;
    Progress progress;
    PrintWriter writer;
    File scene_file = null;
    PrintWriter scenewriter = null;
    String renderFilename = null;
    boolean isNotActive;
    String povrayexe;
    Component parent;
    TreeWorker worker;

    public TreeCreationTask(Component parent, Config config) {
        this.parent = parent;
        this.povrayexe = config.getProperty("povray.executable");
        if (this.povrayexe == null) {
            System.err.println("Warning: Povray executable not set up, trying \"" + Config.defaultPovrayExe() + "\" without path");
            this.povrayexe = Config.defaultPovrayExe();
        }
        this.isNotActive = true;
    }

    public void start(TreeGenerator treeFactory, File outFile, File sceneFile, String imgFilename) {
        try {
            this.treeGenerator = treeFactory;
            this.writer = new PrintWriter(new FileWriter(outFile));
            if (sceneFile != null) {
                this.scene_file = sceneFile;
                this.scenewriter = new PrintWriter(new FileWriter(sceneFile));
            }
            this.renderFilename = imgFilename;
            this.isNotActive = false;
            this.worker = new TreeWorker();
            this.worker.start();
        }
        catch (Exception e) {
            Console.printException(e);
        }
    }

    int getProgress() {
        return this.progress.getPercent();
    }

    String getProgressMsg() {
        return this.progress.getPhase();
    }

    void stop() {
        if (this.worker != null) {
            System.err.println("stop tree creation...");
            this.worker.interrupt();
            this.isNotActive = true;
            this.worker = null;
        }
    }

    boolean notActive() {
        return this.isNotActive;
    }

    final class TreeWorker
    extends SwingWorker {
        TreeWorker() {
        }

        public Object construct() {
            return new DoTask(TreeCreationTask.this.parent);
        }

        public void finished() {
            TreeCreationTask.this.isNotActive = true;
        }
    }

    class DoTask {
        void render() {
            try {
                String str;
                String[] povcmd = new String[]{TreeCreationTask.this.povrayexe, "+L" + TreeCreationTask.this.scene_file.getParent(), "+w" + ExporterFactory.getRenderW(), "+h" + ExporterFactory.getRenderH(), "+o" + TreeCreationTask.this.renderFilename, TreeCreationTask.this.scene_file.getPath()};
                System.err.println(povcmd);
                System.err.println("rendering...");
                Process povProc = Runtime.getRuntime().exec(povcmd);
                BufferedReader pov_in = new BufferedReader(new InputStreamReader(povProc.getErrorStream()));
                while ((str = pov_in.readLine()) != null) {
                    System.err.println(str);
                }
            }
            catch (Exception e) {
                System.err.println(e);
                e.printStackTrace(System.err);
            }
        }

        DoTask(Component parent) {
            try {
                TreeCreationTask.this.progress = new Progress();
                Tree tree = TreeCreationTask.this.treeGenerator.makeTree(TreeCreationTask.this.progress);
                ShieldedGUIExporter exporter = new ShieldedGUIExporter(parent, ExporterFactory.createExporter(tree));
                exporter.write(TreeCreationTask.this.writer, TreeCreationTask.this.progress);
                if (TreeCreationTask.this.scenewriter != null) {
                    exporter = new ShieldedGUIExporter(parent, ExporterFactory.createSceneExporter(tree));
                    exporter.write(TreeCreationTask.this.scenewriter, TreeCreationTask.this.progress);
                }
                if (TreeCreationTask.this.renderFilename != null && TreeCreationTask.this.renderFilename.length() > 0) {
                    TreeCreationTask.this.progress.beginPhase("Rendering tree", -1L);
                    this.render();
                    TreeCreationTask.this.progress.endPhase();
                }
            }
            catch (Exception err) {
                System.err.println(err);
                err.printStackTrace(System.err);
            }
        }
    }
}

