/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.arbaro.export;

import java.text.NumberFormat;
import java.util.Enumeration;
import net.sourceforge.arbaro.export.MeshExporter;
import net.sourceforge.arbaro.export.OBJLeafFaceWriter;
import net.sourceforge.arbaro.export.OBJLeafVertexWriter;
import net.sourceforge.arbaro.mesh.Face;
import net.sourceforge.arbaro.mesh.LeafMesh;
import net.sourceforge.arbaro.mesh.Mesh;
import net.sourceforge.arbaro.mesh.MeshGenerator;
import net.sourceforge.arbaro.mesh.MeshPart;
import net.sourceforge.arbaro.mesh.UVVector;
import net.sourceforge.arbaro.mesh.Vertex;
import net.sourceforge.arbaro.params.FloatFormat;
import net.sourceforge.arbaro.transformation.Vector;
import net.sourceforge.arbaro.tree.Tree;

final class OBJExporter
extends MeshExporter {
    long vertexProgressCount = 0L;
    long faceProgressCount = 0L;
    NumberFormat frm = FloatFormat.getInstance();
    Mesh mesh;
    LeafMesh leafMesh;
    Tree tree;
    long smoothingGroup;
    int vertexOffset;
    int uvVertexOffset;
    public boolean outputLeafUVs = true;
    public boolean outputStemUVs = true;
    boolean outputNormals = false;

    public OBJExporter(Tree tree, MeshGenerator meshGenerator) {
        super(meshGenerator);
        this.tree = tree;
    }

    public void doWrite() {
        this.smoothingGroup = 1L;
        long objCount = (this.tree.getStemCount() + this.tree.getLeafCount()) * (long)(this.outputNormals ? 2 : 1);
        this.mesh = this.meshGenerator.createStemMeshByLevel(this.tree, this.progress);
        this.leafMesh = this.meshGenerator.createLeafMesh(this.tree, this.meshGenerator.getUseQuads());
        this.progress.beginPhase("Writing vertices", objCount);
        this.writeStemVertices("v");
        this.writeLeafVertices("v");
        if (this.outputStemUVs) {
            this.writeStemVertices("vt");
        }
        if (this.outputLeafUVs) {
            this.writeLeafVertices("vt");
        }
        if (this.outputNormals) {
            this.writeStemVertices("vn");
            this.writeLeafVertices("vn");
        }
        this.progress.endPhase();
        this.progress.beginPhase("Writing faces", objCount);
        this.writeStemFaces();
        OBJLeafFaceWriter faceExporter = new OBJLeafFaceWriter(this.tree, this, this.leafMesh, this.vertexOffset, this.uvVertexOffset, this.smoothingGroup, this.outputLeafUVs, this.outputStemUVs);
        this.tree.traverseTree(faceExporter);
        this.vertexOffset = faceExporter.leafVertexOffset;
        this.progress.endPhase();
        this.w.flush();
    }

    private void writeStemVertices(String type) {
        if (type == "vt") {
            Enumeration vertices = this.mesh.allVertices(true);
            while (vertices.hasMoreElements()) {
                UVVector vertex = (UVVector)vertices.nextElement();
                this.writeUVVertex(vertex);
            }
        } else {
            Enumeration vertices = this.mesh.allVertices(false);
            while (vertices.hasMoreElements()) {
                Vertex vertex = (Vertex)vertices.nextElement();
                if (type == "v") {
                    this.writeVertex(vertex.point, "v");
                    continue;
                }
                this.writeVertex(vertex.normal, "vn");
            }
            this.incProgressCount(500);
        }
    }

    private void writeLeafVertices(String type) {
        if (type == "vt") {
            if (this.leafMesh.isFlat()) {
                int i = 0;
                while (i < this.leafMesh.getShapeVertexCount()) {
                    this.writeUVVertex(this.leafMesh.shapeUVAt(i));
                    ++i;
                }
            }
        } else {
            OBJLeafVertexWriter vertexExporter = new OBJLeafVertexWriter(this.tree, this, this.leafMesh, this.vertexOffset, type);
            this.tree.traverseTree(vertexExporter);
            this.vertexOffset = vertexExporter.leafVertexOffset;
        }
    }

    private void writeStemFaces() {
        this.vertexOffset = 1;
        int stemLevel = 0;
        while (stemLevel < this.tree.getLevels()) {
            this.w.println("g " + (stemLevel == 0 ? "trunk" : "stems_" + stemLevel));
            this.w.println("usemtl " + (stemLevel == 0 ? "trunk" : "stems_" + stemLevel));
            Enumeration parts = this.mesh.allParts(stemLevel);
            while (parts.hasMoreElements()) {
                MeshPart mp = (MeshPart)parts.nextElement();
                this.uvVertexOffset = 1 + this.mesh.firstUVIndex(mp.getStem().getLevel());
                this.w.println("s " + this.smoothingGroup++);
                Enumeration faces = mp.allFaces(this.mesh, this.vertexOffset, false);
                Enumeration uvFaces = mp.allFaces(this.mesh, this.uvVertexOffset, true);
                while (faces.hasMoreElements()) {
                    Face face = (Face)faces.nextElement();
                    Face uvFace = (Face)uvFaces.nextElement();
                    this.writeFace(face, 0L, uvFace, 0L, this.outputStemUVs, this.outputNormals);
                }
                this.vertexOffset += mp.vertexCount();
                this.uvVertexOffset += mp.uvCount();
                this.incProgressCount(500);
            }
            ++stemLevel;
        }
    }

    private void writeVertex(Vector v, String type) {
        this.w.println(String.valueOf(type) + " " + this.frm.format(v.getX()) + " " + this.frm.format(v.getZ()) + " " + this.frm.format(v.getY()));
    }

    private void writeUVVertex(UVVector v) {
        this.w.println("vt " + this.frm.format(v.u) + " " + this.frm.format(v.v) + " " + this.frm.format(0L));
    }

    private void writeFace(Face f, long offset, Face uv, long uvOffset, boolean writeUVs, boolean writeNormals) {
        this.w.print("f ");
        int i = 0;
        while (i < f.points.length) {
            this.w.print(offset + f.points[i]);
            if (writeUVs || writeNormals) {
                this.w.print("/");
                if (writeUVs) {
                    this.w.print(uvOffset + uv.points[i]);
                }
                if (writeNormals) {
                    this.w.print("/" + offset + f.points[i]);
                }
            }
            if (i < f.points.length - 1) {
                this.w.print(" ");
            } else {
                this.w.println();
            }
            ++i;
        }
    }
}

