/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.arbaro.export;

import net.sourceforge.arbaro.export.AbstractExporter;
import net.sourceforge.arbaro.export.DXFExporter;
import net.sourceforge.arbaro.export.Exporter;
import net.sourceforge.arbaro.export.InvalidExportFormatError;
import net.sourceforge.arbaro.export.OBJExporter;
import net.sourceforge.arbaro.export.POVConeExporter;
import net.sourceforge.arbaro.export.POVMeshExporter;
import net.sourceforge.arbaro.export.POVSceneExporter;
import net.sourceforge.arbaro.export.ShieldedExporter;
import net.sourceforge.arbaro.mesh.MeshGenerator;
import net.sourceforge.arbaro.mesh.MeshGeneratorFactory;
import net.sourceforge.arbaro.params.Params;
import net.sourceforge.arbaro.tree.Tree;

public class ExporterFactory {
    public static final int POV_MESH = 0;
    public static final int POV_CONES = 1;
    public static final int DXF = 2;
    public static final int OBJ = 3;
    static int exportFormat = 0;
    static String outputPath = String.valueOf(System.getProperty("user.dir")) + System.getProperty("file.separator") + "pov";
    static int renderW = 400;
    static int renderH = 600;
    static boolean outputStemUVs = false;
    static boolean outputLeafUVs = false;
    static final String[] formats = new String[]{"Povray meshes", "Povray primitives", "AutoCAD DXF", "Wavefront OBJ"};
    static final String[] shortformats = new String[]{"POV_MESH", "POV_CONES", "DXF", "OBJ"};

    public static void setExportFormat(int output) {
        exportFormat = output;
    }

    public static int getExportFormat() {
        return exportFormat;
    }

    public static String getOutputPath() {
        return outputPath;
    }

    public static void setOutputPath(String p) {
        outputPath = p;
    }

    public static void setRenderW(int w) {
        renderW = w;
    }

    public static void setRenderH(int h) {
        renderH = h;
    }

    public static int getRenderH() {
        return renderH;
    }

    public static int getRenderW() {
        return renderW;
    }

    public static void setOutputStemUVs(boolean oUV) {
        outputStemUVs = oUV;
    }

    public static boolean getOutputStemUVs() {
        return outputStemUVs;
    }

    public static void setOutputLeafUVs(boolean oUV) {
        outputLeafUVs = oUV;
    }

    public static boolean getOutputLeafUVs() {
        return outputLeafUVs;
    }

    public static Exporter createExporter(Tree tree) throws InvalidExportFormatError {
        AbstractExporter exporter = null;
        boolean useQuads = false;
        if (exportFormat == 1) {
            exporter = new POVConeExporter(tree);
        } else if (exportFormat == 0) {
            MeshGenerator meshGenerator = MeshGeneratorFactory.createMeshGenerator(useQuads);
            exporter = new POVMeshExporter(tree, meshGenerator);
            ((POVMeshExporter)exporter).outputStemUVs = outputStemUVs;
            ((POVMeshExporter)exporter).outputLeafUVs = outputLeafUVs;
        } else if (exportFormat == 2) {
            MeshGenerator meshGenerator = MeshGeneratorFactory.createMeshGenerator(useQuads);
            exporter = new DXFExporter(tree, meshGenerator);
        } else if (exportFormat == 3) {
            useQuads = true;
            MeshGenerator meshGenerator = MeshGeneratorFactory.createMeshGenerator(useQuads);
            exporter = new OBJExporter(tree, meshGenerator);
            ((OBJExporter)exporter).outputStemUVs = outputStemUVs;
            ((OBJExporter)exporter).outputLeafUVs = outputLeafUVs;
        } else {
            throw new InvalidExportFormatError("Invalid export format");
        }
        return exporter;
    }

    public static Exporter createSceneExporter(Tree tree) {
        return new POVSceneExporter(tree, renderW, renderH);
    }

    public static Exporter createShieldedExporter(Tree tree, Params params) throws InvalidExportFormatError {
        return new ShieldedExporter(ExporterFactory.createExporter(tree));
    }

    public static Exporter createShieldedSceneExporter(Tree tree) {
        return new ShieldedExporter(ExporterFactory.createSceneExporter(tree));
    }

    public static String[] getExportFormats() {
        return formats;
    }

    public static String[] getShortExportFormats() {
        return shortformats;
    }
}

