/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.arbaro.mesh;

import net.sourceforge.arbaro.export.Console;
import net.sourceforge.arbaro.export.Progress;
import net.sourceforge.arbaro.mesh.LeafMesh;
import net.sourceforge.arbaro.mesh.Mesh;
import net.sourceforge.arbaro.mesh.MeshCreator;
import net.sourceforge.arbaro.mesh.MeshGenerator;
import net.sourceforge.arbaro.tree.Tree;

class MeshGeneratorImpl
implements MeshGenerator {
    public boolean useQuads;

    public boolean getUseQuads() {
        return this.useQuads;
    }

    public MeshGeneratorImpl(boolean useQuads) {
        this.useQuads = useQuads;
    }

    public Mesh createStemMesh(Tree tree, Progress progress) {
        progress.beginPhase("Creating mesh", tree.getStemCount());
        this.outputVertexInfo(tree);
        Mesh mesh = new Mesh(tree.getLevels());
        MeshCreator meshCreator = new MeshCreator(mesh, -1, this.useQuads, progress);
        tree.traverseTree(meshCreator);
        progress.endPhase();
        return mesh;
    }

    private void outputVertexInfo(Tree tree) {
        Console.verboseOutput("Output: mesh");
        int l = 0;
        while (l < Math.min(tree.getLevels(), 4)) {
            Console.verboseOutput("  Level " + l + ": " + tree.getVertexInfo(l));
            ++l;
        }
    }

    public Mesh createStemMeshByLevel(Tree tree, Progress progress) {
        progress.beginPhase("Creating mesh", tree.getStemCount());
        this.outputVertexInfo(tree);
        Mesh mesh = new Mesh(tree.getLevels());
        int level = 0;
        while (level < tree.getLevels()) {
            MeshCreator meshCreator = new MeshCreator(mesh, level, this.useQuads, progress);
            tree.traverseTree(meshCreator);
            ++level;
        }
        progress.endPhase();
        return mesh;
    }

    public LeafMesh createLeafMesh(Tree tree, boolean useQuads) {
        return new LeafMesh(tree.getLeafShape(), tree.getLeafLength(), tree.getLeafWidth(), tree.getLeafStemLength(), useQuads);
    }
}

