/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.arbaro.tree;

import java.io.ByteArrayInputStream;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.Dictionary;
import java.util.Enumeration;
import java.util.Hashtable;
import junit.framework.TestCase;
import junit.swingui.TestRunner;
import net.sourceforge.arbaro.export.Progress;
import net.sourceforge.arbaro.params.AbstractParam;
import net.sourceforge.arbaro.params.FloatParam;
import net.sourceforge.arbaro.params.IntParam;
import net.sourceforge.arbaro.params.Params;
import net.sourceforge.arbaro.tree.Tree;
import net.sourceforge.arbaro.tree.TreeGenerator;
import net.sourceforge.arbaro.tree.TreeGeneratorFactory;

public class treeTest
extends TestCase {
    static final double prec = 1.0E-10;
    static final String sassafrasCfg = "species=sassafras\nShape=2\nLevels=4\nScale=23\nScaleV=7\nBaseSize=0.2\nRatio=0.02\nRatioPower=1.3\nLobes=3\nLobeDepth=0.05\nFlare=0\nLeaves=15\nLeafShape=0\nLeafScale=0.25\nLeafScaleX=0.7\nAttractionUp=0\nLeafQuality=1\nPruneRatio=0\n0Scale=1\n0ScaleV=0\n0Length=1\n0LengthV=0\n0Taper=1.05\n0BaseSplits=0\n0SegSplits=0\n0SplitAngle=20\n0SplitAngleV=5\n0CurveRes=15\n0CurveBack=0\n0Curve=0\n0CurveV=60\n1Length=0.4\n1LengthV=0\n1Taper=1\n1DownAngle=90\n1DownAngleV=-10\n1Rotate=140\n1RotateV=0\n1Branches=15\n1SplitAngle=20\n1SplitAngle=0\n1SegSplits=0\n1CurveRes=5\n1CurveBack=30\n1Curve=-60\n1CurveV=200\n2Length=0.7\n2LengthV=0\n2Taper=1\n2DownAngle=50\n2DownAngleV=10\n2Rotate=140\n2RotateV=0\n2Branches=20\n2SplitAngle=0\n2SplitAngle=0\n2SegSplits=0\n2CurveRes=8\n2CurveBack=0\n2Curve=-40\n2CurveV=300\n3Length=0.4\n3LengthV=0\n3Taper=1\n3DownAngle=45\n3DownAngleV=10\n3Rotate=140\n3RotateV=0\n3Branches=30\n3SplitAngle=0\n3SplitAngleV=0\n3SegSplits=0\n3CurveRes=3\n3CurveBack=0\n3Curve=0\n3CurveV=200\n";
    static Dictionary sassafrasParams;
    static /* synthetic */ Class class$0;

    public static void main(String[] args) {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("net.sourceforge.arbaro.tree.treeTest");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        TestRunner.run((Class)clazz);
    }

    public void setUp() {
        sassafrasParams = new Hashtable();
        String[] strArray = sassafrasCfg.split("\n");
        int i = 0;
        while (i < strArray.length) {
            String[] key_val = strArray[i].split("=");
            sassafrasParams.put(key_val[0], key_val[1]);
            ++i;
        }
    }

    private void checkParam(String key, AbstractParam par) {
        String val = (String)sassafrasParams.get(key);
        if (par instanceof IntParam) {
            treeTest.assertEquals((int)new Integer(val), (int)((IntParam)par).intValue());
        } else if (par instanceof FloatParam) {
            treeTest.assertEquals((double)new Double(val), (double)((FloatParam)par).doubleValue(), (double)1.0E-10);
        } else {
            treeTest.assertEquals((String)val, (String)par.getValue());
        }
    }

    private void checkParams(Params params) {
        Enumeration keys = sassafrasParams.keys();
        while (keys.hasMoreElements()) {
            String key = (String)keys.nextElement();
            if (key.equals("species")) {
                this.checkParam(key, params.getParam("Species"));
                continue;
            }
            this.checkParam(key, params.getParam(key));
        }
    }

    public void testTreeGenerator() {
        TreeGenerator generator = TreeGeneratorFactory.createTreeGenerator();
        ByteArrayInputStream is = new ByteArrayInputStream(sassafrasCfg.getBytes());
        generator.readParamsFromCfg(is);
        this.checkParams(generator.getParams());
        StringWriter xsw = new StringWriter();
        PrintWriter pw = new PrintWriter(xsw);
        generator.writeParamsToXML(pw);
        generator.clearParams();
        treeTest.assertEquals((Object)generator.getParam("Species"), (Object)"default");
        ByteArrayInputStream xis = new ByteArrayInputStream(xsw.toString().getBytes());
        generator.readParamsFromXML(xis);
        this.checkParams(generator.getParams());
        Tree tree = generator.makeTree(new Progress());
    }

    class ParamException
    extends RuntimeException {
        public ParamException(String msg) {
            super(msg);
        }
    }
}

