/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.arbaro.mesh;

import net.sourceforge.arbaro.mesh.Face;
import net.sourceforge.arbaro.mesh.UVVector;
import net.sourceforge.arbaro.mesh.Vertex;
import net.sourceforge.arbaro.transformation.Vector;

abstract class LeafShape {
    Vertex[] vertices;
    Face[] faces;
    double length = 1.0;
    double width = 1.0;
    double stemLen = 0.5;
    boolean useQuads;

    LeafShape(double len, double wid, double stem_len, boolean quads) {
        this.length = len;
        this.width = wid;
        this.stemLen = stem_len;
        this.useQuads = quads;
    }

    void setPoint(int i, double x, double y, double z) {
        Vector point = new Vector(x * this.width, y * this.width, (this.stemLen + z) * this.length);
        UVVector uv = new UVVector(x + 0.5, z);
        if (this.vertices[i] == null) {
            this.vertices[i] = new Vertex(point, null, uv);
        } else {
            this.vertices[i].point = point;
        }
    }

    int getVertexCount() {
        return this.vertices.length;
    }

    int getFaceCount() {
        return this.faces.length;
    }
}

