/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.arbaro.mesh;

import net.sourceforge.arbaro.export.Console;
import net.sourceforge.arbaro.export.Progress;
import net.sourceforge.arbaro.mesh.LeafMesh;
import net.sourceforge.arbaro.mesh.Mesh;
import net.sourceforge.arbaro.mesh.MeshGenerator;
import net.sourceforge.arbaro.tree.Tree;

public class ShieldedMeshGenerator
implements MeshGenerator {
    private MeshGenerator meshGenerator;

    public boolean getUseQuads() {
        return this.meshGenerator.getUseQuads();
    }

    public ShieldedMeshGenerator(MeshGenerator meshGenerator) {
        this.meshGenerator = meshGenerator;
    }

    protected void showException(Exception e) {
        Console.errorOutput("Error in mesh generator:");
        Console.printException(e);
    }

    public LeafMesh createLeafMesh(Tree tree, boolean useQuads) {
        try {
            return this.meshGenerator.createLeafMesh(tree, useQuads);
        }
        catch (Exception e) {
            this.showException(e);
            return null;
        }
    }

    public Mesh createStemMesh(Tree tree, Progress progress) {
        try {
            return this.meshGenerator.createStemMesh(tree, progress);
        }
        catch (Exception e) {
            this.showException(e);
            return null;
        }
    }

    public Mesh createStemMeshByLevel(Tree tree, Progress progress) {
        try {
            return this.meshGenerator.createStemMeshByLevel(tree, progress);
        }
        catch (Exception e) {
            this.showException(e);
            return null;
        }
    }
}

