/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.arbaro.transformation;

import java.text.NumberFormat;
import net.sourceforge.arbaro.params.FloatFormat;

public final class Vector {
    static final int X = 0;
    static final int Y = 1;
    static final int Z = 2;
    public static final Vector X_AXIS = new Vector(1.0, 0.0, 0.0);
    public static final Vector Y_AXIS = new Vector(0.0, 1.0, 0.0);
    public static final Vector Z_AXIS = new Vector(0.0, 0.0, 1.0);
    private double[] coord = new double[3];

    public Vector() {
    }

    public Vector(double x, double y, double z) {
        this.coord[0] = x;
        this.coord[1] = y;
        this.coord[2] = z;
    }

    public boolean equals(Vector v) {
        return this.sub(v).abs() < 1.0E-7;
    }

    public double abs() {
        return Math.sqrt(this.coord[0] * this.coord[0] + this.coord[1] * this.coord[1] + this.coord[2] * this.coord[2]);
    }

    public String toString() {
        NumberFormat fmt = FloatFormat.getInstance();
        return "<" + fmt.format(this.coord[0]) + "," + fmt.format(this.coord[1]) + "," + fmt.format(this.coord[2]) + ">";
    }

    public Vector normalize() {
        double abs = this.abs();
        return new Vector(this.coord[0] / abs, this.coord[1] / abs, this.coord[2] / abs);
    }

    public double getX() {
        return this.coord[0];
    }

    public double getY() {
        return this.coord[1];
    }

    public double getZ() {
        return this.coord[2];
    }

    public Vector mul(double factor) {
        return new Vector(this.coord[0] * factor, this.coord[1] * factor, this.coord[2] * factor);
    }

    public double prod(Vector v) {
        return this.coord[0] * v.getX() + this.coord[1] * v.getY() + this.coord[2] * v.getZ();
    }

    public Vector div(double factor) {
        return this.mul(1.0 / factor);
    }

    public Vector add(Vector v) {
        return new Vector(this.coord[0] + v.getX(), this.coord[1] + v.getY(), this.coord[2] + v.getZ());
    }

    public Vector sub(Vector v) {
        return this.add(v.mul(-1.0));
    }

    public static double atan2(double v, double u) {
        if (u == 0.0) {
            if (v >= 0.0) {
                return 90.0;
            }
            return -90.0;
        }
        if (u > 0.0) {
            return Math.atan(v / u) * 180.0 / Math.PI;
        }
        if (v >= 0.0) {
            return 180.0 + Math.atan(v / u) * 180.0 / Math.PI;
        }
        return Math.atan(v / u) * 180.0 / Math.PI - 180.0;
    }

    public void setMaxCoord(Vector v) {
        if (v.getX() > this.coord[0]) {
            this.coord[0] = v.getX();
        }
        if (v.getY() > this.coord[1]) {
            this.coord[1] = v.getY();
        }
        if (v.getZ() > this.coord[2]) {
            this.coord[2] = v.getZ();
        }
    }

    public void setMinCoord(Vector v) {
        if (v.getX() < this.coord[0]) {
            this.coord[0] = v.getX();
        }
        if (v.getY() < this.coord[1]) {
            this.coord[1] = v.getY();
        }
        if (v.getZ() < this.coord[2]) {
            this.coord[2] = v.getZ();
        }
    }
}

