/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.arbaro.tree;

import net.sourceforge.arbaro.params.Params;
import net.sourceforge.arbaro.transformation.Transformation;
import net.sourceforge.arbaro.transformation.Vector;
import net.sourceforge.arbaro.tree.Leaf;
import net.sourceforge.arbaro.tree.TreeTraversal;

class LeafImpl
implements Leaf {
    public Transformation transf;

    public Transformation getTransformation() {
        return this.transf;
    }

    public LeafImpl(Transformation trf) {
        this.transf = trf;
    }

    private void setLeafOrientation(Params par) {
        if (par.LeafBend == 0.0) {
            return;
        }
        Vector pos = this.transf.getT();
        Vector norm = this.transf.getY();
        double tpos = Vector.atan2(pos.getY(), pos.getX());
        double tbend = tpos - Vector.atan2(norm.getY(), norm.getX());
        double bend_angle = par.LeafBend * tbend;
        this.transf = this.transf.rotaxis(bend_angle, Vector.Z_AXIS);
        norm = this.transf.getY();
        double fbend = Vector.atan2(Math.sqrt(norm.getX() * norm.getX() + norm.getY() * norm.getY()), norm.getZ());
        bend_angle = par.LeafBend * fbend;
        this.transf = this.transf.rotx(bend_angle);
    }

    public void make(Params par) {
        this.setLeafOrientation(par);
    }

    public boolean traverseTree(TreeTraversal traversal) {
        return traversal.visitLeaf(this);
    }
}

