/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.arbaro.mesh;

import java.util.Enumeration;
import net.sourceforge.arbaro.export.Progress;
import net.sourceforge.arbaro.mesh.MeshPart;
import net.sourceforge.arbaro.mesh.MeshSection;
import net.sourceforge.arbaro.transformation.Transformation;
import net.sourceforge.arbaro.transformation.Vector;
import net.sourceforge.arbaro.tree.Stem;
import net.sourceforge.arbaro.tree.StemSection;

class MeshPartCreator {
    MeshPart meshPart;
    boolean useQuads;
    Stem stem;

    public MeshPartCreator(Stem stem, boolean useQuads) {
        this.useQuads = useQuads;
        this.stem = stem;
    }

    public MeshPart createMeshPart(Progress progress) {
        this.meshPart = new MeshPart(this.stem, this.stem.isSmooth(), this.useQuads);
        double vLength = this.stem.getLength() + this.stem.getBaseRadius() + this.stem.getPeakRadius();
        Enumeration sections = this.stem.sections();
        StemSection section = (StemSection)sections.nextElement();
        this.createMidPoint(section, 0.0);
        ((MeshSection)this.meshPart.firstElement()).setNormalsToVector(section.getZ().mul(-1.0));
        while (true) {
            this.createSectionMeshpoints(section, section.getDistance() / vLength);
            if (!sections.hasMoreElements()) {
                if (section.getRadius() > 1.0E-6) {
                    this.createMidPoint(section, 1.0);
                }
                ((MeshSection)this.meshPart.lastElement()).setNormalsToVector(section.getZ());
            }
            if (!sections.hasMoreElements()) break;
            section = (StemSection)sections.nextElement();
        }
        if (this.meshPart.size() > 0) {
            return this.meshPart;
        }
        return null;
    }

    private void createMidPoint(StemSection sec, double vMap) {
        MeshSection section = new MeshSection(1, vMap);
        Transformation trf = sec.getTransformation();
        section.addPoint(trf.apply(new Vector(0.0, 0.0, 0.0)), 0.5);
        this.meshPart.addSection(section);
    }

    private void createSectionMeshpoints(StemSection sec, double vMap) {
        Vector[] points = sec.getSectionPoints();
        MeshSection section = new MeshSection(points.length, vMap);
        if (points.length == 1) {
            section.addPoint(points[0], 0.5);
        } else {
            int i = 0;
            while (i < points.length) {
                double angle = (double)i * 360.0 / (double)points.length;
                section.addPoint(points[i], angle / 360.0);
                ++i;
            }
        }
        this.meshPart.addSection(section);
    }
}

