/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.arbaro.transformation;

import junit.framework.TestCase;
import junit.swingui.TestRunner;
import net.sourceforge.arbaro.transformation.Matrix;
import net.sourceforge.arbaro.transformation.Transformation;
import net.sourceforge.arbaro.transformation.Vector;

public class TransformationTest
extends TestCase {
    double prec = 1.0E-5;
    static Matrix aTestMatrix = new Matrix(1.0, 2.0, 3.0, 4.0, 5.0, 6.0, 7.0, 8.0, 9.0);
    static Vector aTestVector = new Vector(-1.0, -2.0, -3.0);
    static Transformation aTestTransformation = new Transformation(aTestMatrix, aTestVector);
    static /* synthetic */ Class class$0;

    public static void main(String[] args) {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("net.sourceforge.arbaro.transformation.TransformationTest");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        TestRunner.run((Class)clazz);
    }

    private void assertMatrixEquals(Matrix m1, Matrix m2) {
        int r = 0;
        while (r <= 2) {
            int c = 0;
            while (c <= 2) {
                TransformationTest.assertEquals((double)m1.get(r, c), (double)m2.get(r, c), (double)this.prec);
                ++c;
            }
            ++r;
        }
    }

    private void assertVectorEquals(Vector v1, Vector v2) {
        TransformationTest.assertEquals((double)v1.getX(), (double)v2.getX(), (double)this.prec);
        TransformationTest.assertEquals((double)v1.getY(), (double)v2.getY(), (double)this.prec);
        TransformationTest.assertEquals((double)v1.getZ(), (double)v2.getZ(), (double)this.prec);
    }

    private void assertTransformationEquals(Transformation T1, Transformation T2) {
        this.assertMatrixEquals(T1.matrix, T2.matrix);
        this.assertVectorEquals(T1.vector, T2.vector);
    }

    public void testTransformation() {
        Transformation T = new Transformation();
        this.assertMatrixEquals(T.matrix(), new Matrix());
        this.assertVectorEquals(T.vector(), new Vector());
    }

    public void testTransformationMatrixVector() {
        Transformation T = new Transformation(aTestMatrix, aTestVector);
        this.assertMatrixEquals(T.matrix(), aTestMatrix);
        this.assertVectorEquals(T.vector(), aTestVector);
    }

    public void testMatrix() {
        Transformation T = new Transformation(aTestMatrix, aTestVector);
        this.assertMatrixEquals(T.matrix(), aTestMatrix);
    }

    public void testVector() {
        Transformation T = new Transformation(aTestMatrix, aTestVector);
        this.assertVectorEquals(T.vector(), aTestVector);
    }

    public void testProd() {
        Transformation P = aTestTransformation.prod(aTestTransformation);
        this.assertMatrixEquals(aTestMatrix.prod(aTestMatrix), P.matrix());
        this.assertVectorEquals(aTestVector.add(aTestMatrix.prod(aTestVector)), P.vector());
        Transformation U = new Transformation();
        this.assertTransformationEquals(U.prod(U), U);
    }

    public void testApply() {
        Transformation T = new Transformation(aTestMatrix, aTestVector);
        this.assertVectorEquals(T.apply(new Vector()), T.vector());
        this.assertVectorEquals(T.apply(new Vector(1.0, 1.0, 1.0)), new Vector(5.0, 13.0, 21.0));
    }

    public void testGetX() {
        this.assertVectorEquals(new Transformation(aTestMatrix, aTestVector).getX(), aTestMatrix.col(0));
    }

    public void testGetY() {
        this.assertVectorEquals(new Transformation(aTestMatrix, aTestVector).getY(), aTestMatrix.col(1));
    }

    public void testGetZ() {
        this.assertVectorEquals(new Transformation(aTestMatrix, aTestVector).getZ(), aTestMatrix.col(2));
    }

    public void testGetT() {
        this.assertVectorEquals(new Transformation(aTestMatrix, aTestVector).getT(), aTestVector);
    }

    public void testRotz() {
        Transformation T = new Transformation().rotx(30.0).roty(-130.0).rotz(250.0).translate(aTestVector);
        Transformation T1 = T.rotz(135.0).rotz(225.0);
        this.assertTransformationEquals(T, T1);
    }

    public void testRoty() {
        Transformation T = new Transformation().rotx(30.0).roty(-130.0).rotz(250.0).translate(aTestVector);
        Transformation T1 = T.roty(135.0).roty(225.0);
        this.assertTransformationEquals(T, T1);
    }

    public void testRotx() {
        Transformation T = new Transformation().rotx(30.0).roty(-130.0).rotz(250.0).translate(aTestVector);
        Transformation T1 = T.rotx(135.0).rotx(225.0);
        this.assertTransformationEquals(T, T1);
    }

    public void testRotxz() {
        Transformation T = new Transformation().rotx(30.0).roty(-130.0).rotz(250.0).translate(aTestVector);
        Transformation T1 = T.rotz(261.0).rotx(-32.0);
        Transformation T2 = T.rotxz(-32.0, 261.0);
        this.assertTransformationEquals(T1, T2);
        this.assertVectorEquals(T2.vector(), aTestVector);
    }

    public void testRotaxisz() {
        TransformationTest.fail((String)"test not implemented");
    }

    public void testTranslate() {
        Transformation T = new Transformation(aTestMatrix, aTestVector).translate(aTestVector);
        this.assertMatrixEquals(T.matrix(), aTestMatrix);
        this.assertVectorEquals(T.vector(), aTestVector.mul(2.0));
    }

    public void testRotaxis() {
        Transformation T = new Transformation().rotx(30.0).roty(-130.0).rotz(250.0).translate(aTestVector);
        Transformation T1 = T.rotaxis(135.0, aTestVector).rotaxis(225.0, aTestVector);
        this.assertTransformationEquals(T, T1);
    }

    public void testInverse() {
        Transformation U = new Transformation();
        this.assertTransformationEquals(U, U.inverse());
        Transformation T = new Transformation().rotx(30.0).roty(-130.0).rotz(250.0).translate(aTestVector);
        this.assertTransformationEquals(T.prod(T.inverse()), U);
    }
}

