/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.arbaro;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileWriter;
import java.io.InputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import net.sourceforge.arbaro.export.Console;
import net.sourceforge.arbaro.export.Exporter;
import net.sourceforge.arbaro.export.ExporterFactory;
import net.sourceforge.arbaro.export.InvalidExportFormatError;
import net.sourceforge.arbaro.export.Progress;
import net.sourceforge.arbaro.params.Params;
import net.sourceforge.arbaro.tree.Tree;
import net.sourceforge.arbaro.tree.TreeGenerator;
import net.sourceforge.arbaro.tree.TreeGeneratorFactory;

public class arbaro {
    static int XMLinput = 0;
    static int CFGinput = 1;
    static int XMLoutput = 99;
    public static final String programName = "Arbaro 2.0 - creates trees objects for rendering from xml parameter files\n(c) 2003-2004 by Wolfram Diestel <diestel@steloj.de> (GPL see file COPYING)\n";

    static void println(String s) {
        System.err.println(s);
    }

    static void println() {
        System.err.println();
    }

    static void printProgramName() {
        arbaro.println(programName);
        arbaro.println();
    }

    static void usage() {
        arbaro.println("syntax:");
        arbaro.println("java -jar arbaro.jar [OPTIONS] <paramfile.xml> > <tree.inc>");
        arbaro.println();
        arbaro.println("options");
        arbaro.println("     -h|--help           Show this helpscreen");
        arbaro.println();
        arbaro.println("     -q|--quiet          Only error messages are output to stderr no progress");
        arbaro.println();
        arbaro.println("     -qq|--reallyquiet   No messages are output to stderr");
        arbaro.println();
        arbaro.println("     -d|--debug          Much debugging ouput should be interesting for developers only");
        arbaro.println();
        arbaro.println("     -o|--output <file>  Output tree code to this file instead of STDOUT");
        arbaro.println();
        arbaro.println("     -s|--seed <seed>    Random seed for the tree, default is 13, but you won't all");
        arbaro.println("                         trees look the same as mine, so give something like -s 17 here");
        arbaro.println("                         the seed is part of the  declaration string in povray files");
        arbaro.println();
        arbaro.println("    -l|--levels <level>  1..Levels+1 -- calculates and ouputs only so much levels, usefull for");
        arbaro.println("                         fast testing of parameter changes or to get a draft tree for");
        arbaro.println("                         a first impression of a scene without all that small stems and");
        arbaro.println("                         leaves. Levels+1 means: calculate alle Levels and Leaves, but this");
        arbaro.println("                         is the same as not giving this option here");
        arbaro.println();
        arbaro.println("    -f|--format <format> Export format, this is one of: ");
        arbaro.println("                         POV_CONES -- Povray primitives (cones and spheres)");
        arbaro.println("                         POV_MESH  -- Povray mesh2 objects");
        arbaro.println("                         OBJ       -- Wavefront OBJ file");
        arbaro.println("                         DXF       -- AutoCAD DXF file");
        arbaro.println();
        arbaro.println("    --uvleaves           For the export formats POV_MESH and OBJ:");
        arbaro.println("                         Output uv coordinates for the leaves");
        arbaro.println();
        arbaro.println("    --uvstems            For the export formats POV_MESH and OBJ:");
        arbaro.println("                         Output uv coordinates for the stems");
        arbaro.println();
        arbaro.println("    -s|--smooth <value>  For the export formats POV_MESH, OBJ and DXF, the smooth value");
        arbaro.println("                         influences how much vertices are used for every stem section");
        arbaro.println("                         and for POV_MESH which levels normals should be used to hide");
        arbaro.println("                         the triangle borders. The value should be between 0.0 and 1.0");
        arbaro.println();
        arbaro.println("    -r|--treecfg         Input file is a simple Param=Value list. Needs less typing for");
        arbaro.println("                         a new tree than writing XML code");
        arbaro.println();
        arbaro.println("    -x|--xml             Output parameters as XML tree definition instead of creating");
        arbaro.println("                         the tree and writing it as povray code. Useful for converting a");
        arbaro.println("                         simple parameter list to a XML file: ");
        arbaro.println("                            java -jar arbaro_cmd.jar --treecfg --xml < mytree.cfg > mytree.xml");
        arbaro.println("    -p|--scene [<file>]  additionally output Povray scene file");
        arbaro.println();
        arbaro.println("example:");
        arbaro.println();
        arbaro.println("    java -jar arbaro_cmd.jar trees/quaking_aspen.xml > pov/quaking_aspen.inc");
        arbaro.println();
    }

    private static int getExportFormat(String format) throws InvalidExportFormatError {
        String[] formats = ExporterFactory.getShortExportFormats();
        int i = 0;
        while (i < formats.length) {
            if (formats[i].equals(format)) {
                return i;
            }
            ++i;
        }
        throw new InvalidExportFormatError("Invalid export format given.");
    }

    public static void main(String[] args) throws Exception {
        InputStream in;
        boolean quiet = false;
        boolean reallyQuiet = false;
        boolean debug = false;
        boolean uvLeaves = false;
        boolean uvStems = false;
        int seed = 13;
        int levels = -1;
        int output = 0;
        double smooth = -1.0;
        int input = XMLinput;
        String input_file = null;
        String output_file = null;
        String scene_file = null;
        int i = 0;
        while (i < args.length) {
            if (args[i].equals("-d") || args[i].equals("--debug")) {
                debug = true;
            } else if (args[i].equals("-h") || args[i].equals("--help")) {
                arbaro.printProgramName();
                arbaro.usage();
                System.exit(0);
            } else if (args[i].equals("-q") || args[i].equals("--quiet")) {
                quiet = true;
            } else if (args[i].equals("-qq") || args[i].equals("--reallyquiet")) {
                reallyQuiet = true;
                quiet = true;
            } else if (args[i].equals("-o") || args[i].equals("--output")) {
                output_file = args[++i];
            } else if (args[i].equals("-s") || args[i].equals("--seed")) {
                seed = new Integer(args[++i]);
            } else if (args[i].equals("-l") || args[i].equals("--levels")) {
                levels = new Integer(args[++i]);
            } else if (args[i].equals("-f") || args[i].equals("--format")) {
                output = arbaro.getExportFormat(args[++i]);
            } else if (args[i].equals("--uvleaves")) {
                uvLeaves = true;
                ++i;
            } else if (args[i].equals("--uvstems")) {
                uvStems = true;
                ++i;
            } else if (args[i].equals("-s") || args[i].equals("--smooth")) {
                smooth = new Double(args[++i]);
            } else if (args[i].equals("-x") || args[i].equals("--xml")) {
                output = XMLoutput;
            } else if (args[i].equals("-r") || args[i].equals("--treecfg")) {
                input = CFGinput;
            } else if (args[i].equals("-p") || args[i].equals("--scene")) {
                scene_file = args[++i];
            } else if (args[i].charAt(0) == '-') {
                arbaro.printProgramName();
                arbaro.usage();
                System.err.println("Invalid option " + args[i] + "!");
                System.exit(1);
            } else {
                input_file = args[i];
                break;
            }
            ++i;
        }
        if (!quiet) {
            arbaro.printProgramName();
        }
        if (debug) {
            Console.setOutputLevel(3);
        } else if (reallyQuiet) {
            Console.setOutputLevel(0);
        } else if (quiet) {
            Console.setOutputLevel(1);
        } else {
            Console.setOutputLevel(2);
        }
        TreeGenerator treeGenerator = TreeGeneratorFactory.createTreeGenerator();
        if (input_file == null) {
            Console.verboseOutput("No tree definition file given.");
            Console.verboseOutput("Reading parameters from STDIN...");
            in = System.in;
        } else {
            Console.verboseOutput("Reading parameters from " + input_file + "...");
            in = new FileInputStream(input_file);
        }
        if (input == CFGinput) {
            treeGenerator.readParamsFromCfg(in);
        } else {
            treeGenerator.readParamsFromXML(in);
        }
        if (smooth >= 0.0) {
            treeGenerator.setParam("Smooth", new Double(smooth).toString());
        }
        PrintWriter out = output_file == null ? new PrintWriter(new OutputStreamWriter(System.out)) : new PrintWriter(new FileWriter(new File(output_file)));
        if (output == XMLoutput) {
            treeGenerator.writeParamsToXML(out);
        } else {
            treeGenerator.setSeed(seed);
            Progress progress = new Progress();
            Tree tree = treeGenerator.makeTree(progress);
            Params params = treeGenerator.getParams();
            params.stopLevel = levels;
            ExporterFactory.setExportFormat(output);
            ExporterFactory.setOutputStemUVs(uvStems);
            ExporterFactory.setOutputLeafUVs(uvLeaves);
            Exporter exporter = ExporterFactory.createExporter(tree);
            exporter.write(out, progress);
            if (scene_file != null) {
                if (!quiet) {
                    System.err.println("Writing Povray scene to " + scene_file + "...");
                }
                PrintWriter scout = new PrintWriter(new FileWriter(new File(scene_file)));
                exporter = ExporterFactory.createSceneExporter(tree);
                exporter.write(scout, progress);
            }
        }
    }
}

