/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.arbaro.export;

import java.io.PrintWriter;
import java.text.NumberFormat;
import net.sourceforge.arbaro.export.AbstractExporter;
import net.sourceforge.arbaro.params.FloatFormat;
import net.sourceforge.arbaro.transformation.Matrix;
import net.sourceforge.arbaro.transformation.Transformation;
import net.sourceforge.arbaro.transformation.Vector;
import net.sourceforge.arbaro.tree.Leaf;
import net.sourceforge.arbaro.tree.Stem;
import net.sourceforge.arbaro.tree.Tree;
import net.sourceforge.arbaro.tree.TreeTraversal;

class POVConeLeafWriter
implements TreeTraversal {
    Tree tree;
    PrintWriter w;
    String povrayDeclarationPrefix;
    AbstractExporter exporter;

    public POVConeLeafWriter(AbstractExporter exporter, Tree tree) {
        this.exporter = exporter;
        this.w = exporter.getWriter();
        this.tree = tree;
        this.povrayDeclarationPrefix = String.valueOf(tree.getSpecies()) + "_" + tree.getSeed() + "_";
    }

    public boolean enterStem(Stem stem) {
        return true;
    }

    public boolean enterTree(Tree tree) {
        this.tree = tree;
        return true;
    }

    public boolean leaveStem(Stem stem) {
        return true;
    }

    public boolean leaveTree(Tree tree) {
        this.w.flush();
        return true;
    }

    public boolean visitLeaf(Leaf leaf) {
        String indent = "    ";
        this.w.println(String.valueOf(indent) + "object { " + this.povrayDeclarationPrefix + "leaf " + this.transformationStr(leaf.getTransformation()) + "}");
        this.exporter.incProgressCount(500);
        return true;
    }

    private String transformationStr(Transformation trf) {
        NumberFormat fmt = FloatFormat.getInstance();
        Matrix matrix = trf.matrix();
        Vector vector = trf.vector();
        return "matrix <" + fmt.format(matrix.get(0, 0)) + "," + fmt.format(matrix.get(2, 0)) + "," + fmt.format(matrix.get(1, 0)) + "," + fmt.format(matrix.get(0, 2)) + "," + fmt.format(matrix.get(2, 2)) + "," + fmt.format(matrix.get(1, 2)) + "," + fmt.format(matrix.get(0, 1)) + "," + fmt.format(matrix.get(2, 1)) + "," + fmt.format(matrix.get(1, 1)) + "," + fmt.format(vector.getX()) + "," + fmt.format(vector.getZ()) + "," + fmt.format(vector.getY()) + ">";
    }
}

