/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.arbaro.gui;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Image;
import java.awt.Insets;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.net.URL;
import javax.swing.AbstractAction;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.JSlider;
import javax.swing.JSplitPane;
import javax.swing.JToolBar;
import javax.swing.border.TitledBorder;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import net.sourceforge.arbaro.export.Console;
import net.sourceforge.arbaro.export.ExporterFactory;
import net.sourceforge.arbaro.gui.CfgDialog;
import net.sourceforge.arbaro.gui.Config;
import net.sourceforge.arbaro.gui.ExportDialog;
import net.sourceforge.arbaro.gui.ParamGroupsView;
import net.sourceforge.arbaro.gui.ParamValueTable;
import net.sourceforge.arbaro.gui.PreviewTree;
import net.sourceforge.arbaro.gui.ShowException;
import net.sourceforge.arbaro.gui.TreePreview;
import net.sourceforge.arbaro.params.AbstractParam;
import net.sourceforge.arbaro.params.ParamException;
import net.sourceforge.arbaro.params.Params;

public final class Workplace {
    JFrame frame;
    Config config;
    Params params;
    int seed = 13;
    PreviewTree previewTree;
    TreePreview frontView;
    TreePreview topView;
    JSlider rotator;
    JLabel imageLabel;
    JToolBar toolBar;
    JFileChooser fileChooser;
    File treefile = null;
    boolean modified;
    static final Color bgClr = new Color(242, 242, 229);
    static final Color Silver = new Color(142, 142, 129);
    ParamValueTable valueEditor;
    ParamGroupsView groupsView;
    static final ImageIcon shapeIcon = Workplace.createImageIcon("images/shape.png", "Tree shape");
    static final ImageIcon radiusIcon = Workplace.createImageIcon("images/radius.png", "Trunk radius");
    static final ImageIcon leavesIcon = Workplace.createImageIcon("images/leaves.png", "Leaves");
    static final ImageIcon pruneIcon = Workplace.createImageIcon("images/pruning.png", "Pruning/Envelope");
    static final ImageIcon miscIcon = Workplace.createImageIcon("images/misc.png", "Miscellaneous parameters");
    static final ImageIcon lentapIcon = Workplace.createImageIcon("images/len_tapr.png", "Length and taper");
    static final ImageIcon curveIcon = Workplace.createImageIcon("images/curve.png", "Curvature");
    static final ImageIcon splitIcon = Workplace.createImageIcon("images/splitting.png", "Splitting");
    static final ImageIcon substemIcon = Workplace.createImageIcon("images/substem.png", "Branching");
    static final ImageIcon aboutIcon = Workplace.createImageIcon("images/arbaro64.png", "Arbaro");
    FileNewAction fileNewAction = new FileNewAction();
    FileOpenAction fileOpenAction = new FileOpenAction();
    FileSaveAction fileSaveAction = new FileSaveAction();
    ExportTreeAction exportTreeAction = new ExportTreeAction();
    RenderTreeAction renderTreeAction = new RenderTreeAction();
    QuitAction quitAction = new QuitAction();
    static /* synthetic */ Class class$0;

    protected static ImageIcon createImageIcon(String path, String description) {
        URL imgURL;
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("net.sourceforge.arbaro.gui.Workplace");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if ((imgURL = clazz.getResource(path)) != null) {
            return new ImageIcon(imgURL, description);
        }
        System.err.println("Couldn't find file: " + path);
        return null;
    }

    public Workplace() {
        URL imgURL;
        this.params = new Params();
        try {
            this.params.prepare(13);
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.frame = new JFrame("Arbaro");
        this.previewTree = new PreviewTree(this.params);
        this.frame.setDefaultCloseOperation(0);
        this.frame.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent e) {
                if (!Workplace.this.shouldSave()) {
                    return;
                }
                System.exit(0);
            }
        });
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("net.sourceforge.arbaro.gui.Workplace");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if ((imgURL = clazz.getResource("images/arbaro32.png")) != null) {
            Image icon = Toolkit.getDefaultToolkit().getImage(imgURL);
            this.frame.setIconImage(icon);
        }
        this.fileChooser = new JFileChooser();
        this.fileChooser.setCurrentDirectory(new File(String.valueOf(System.getProperty("user.dir")) + "/trees"));
        this.config = new Config();
        this.applyConfig();
        AbstractParam.loading = true;
        this.createGUI();
        this.groupsView.fireStateChanged();
        this.frame.setVisible(true);
        this.setModified(false);
        AbstractParam.loading = false;
    }

    public void applyConfig() {
        this.seed = Integer.parseInt(this.config.getProperty("tree.seed", "" + this.seed));
        ExporterFactory.setExportFormat(Integer.parseInt(this.config.getProperty("export.format", "" + ExporterFactory.getExportFormat())));
        ExporterFactory.setRenderW(Integer.parseInt(this.config.getProperty("povray.width", "" + ExporterFactory.getRenderW())));
        ExporterFactory.setRenderH(Integer.parseInt(this.config.getProperty("povray.height", "" + ExporterFactory.getRenderH())));
        ExporterFactory.setOutputPath(this.config.getProperty("export.path", ExporterFactory.getOutputPath()));
    }

    void createGUI() {
        this.createMenuBar();
        this.createToolBar();
        JSplitPane mainPane = new JSplitPane(1);
        mainPane.setResizeWeight(0.25);
        JPanel leftPane = new JPanel();
        leftPane.setLayout(new BoxLayout(leftPane, 3));
        this.groupsView = new ParamGroupsView();
        JScrollPane scrollPane = new JScrollPane(this.groupsView);
        leftPane.add(scrollPane);
        this.valueEditor = new ParamValueTable(this.params);
        leftPane.add(this.valueEditor);
        this.valueEditor.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent e) {
                try {
                    Workplace.this.setModified(true);
                    Workplace.this.previewTree.remake(true);
                    Workplace.this.frame.setTitle("Arbaro [" + Workplace.this.params.Species + "]");
                }
                catch (ParamException err) {
                    Console.errorOutput(err.toString());
                    Workplace.this.valueEditor.showError(err);
                }
                catch (Exception err) {
                    Console.printException(err);
                }
            }
        });
        this.groupsView.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent e) {
                try {
                    int level = Workplace.this.groupsView.getGroupLevel();
                    String group = Workplace.this.groupsView.getGroupName();
                    Workplace.this.valueEditor.showGroup(group, level);
                    if (level == -999) {
                        if (group.equals("LEAVES") || group.equals("LEAVESADD")) {
                            Workplace.this.previewTree.setShowLevel(Workplace.this.params.Levels);
                        } else {
                            Workplace.this.previewTree.setShowLevel(1);
                        }
                    } else {
                        Workplace.this.previewTree.setShowLevel(level);
                    }
                    ImageIcon icon = shapeIcon;
                    if (group.equals("SHAPE")) {
                        icon = shapeIcon;
                    } else if (group.equals("TRUNK")) {
                        icon = radiusIcon;
                    } else if (group.equals("LEAVES") || group.equals("LEAVESADD")) {
                        icon = leavesIcon;
                    } else if (group.equals("PRUNING")) {
                        icon = pruneIcon;
                    } else if (group.equals("MISC")) {
                        icon = miscIcon;
                    } else if (group.equals("LENTAPER")) {
                        icon = lentapIcon;
                    } else if (group.equals("CURVATURE")) {
                        icon = curveIcon;
                    } else if (group.equals("SPLITTING")) {
                        icon = splitIcon;
                    } else if (group.equals("BRANCHING")) {
                        icon = substemIcon;
                    }
                    Workplace.this.imageLabel.setIcon(icon);
                    ((TitledBorder)Workplace.this.imageLabel.getBorder()).setTitle(icon.getDescription());
                    Workplace.this.previewTree.remake(true);
                }
                catch (Exception err) {
                    Console.printException(err);
                }
            }
        });
        mainPane.add((Component)leftPane, "left");
        JPanel rightPane = new JPanel();
        rightPane.setOpaque(true);
        GridBagLayout grid = new GridBagLayout();
        GridBagConstraints constraints = new GridBagConstraints();
        rightPane.setLayout(grid);
        constraints.insets = new Insets(1, 1, 0, 0);
        JPanel frontViewWS = this.createFrontView();
        constraints.weightx = 1.0;
        constraints.weighty = 1.0;
        constraints.fill = 1;
        constraints.gridx = 0;
        constraints.gridy = 0;
        constraints.gridwidth = 2;
        constraints.gridheight = 2;
        grid.setConstraints(frontViewWS, constraints);
        rightPane.add(frontViewWS);
        constraints.weightx = 0.2;
        this.topView = new TreePreview(this.previewTree, 90, this.config);
        this.topView.setOpaque(true);
        this.topView.setBackground(bgClr);
        constraints.gridx = 2;
        constraints.gridy = 0;
        constraints.gridwidth = 1;
        constraints.gridheight = 1;
        grid.setConstraints(this.topView, constraints);
        rightPane.add(this.topView);
        this.imageLabel = new JLabel("", shapeIcon, 0);
        this.imageLabel.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEmptyBorder(2, 2, 2, 2), "Tree shape", 2, 5));
        this.imageLabel.setOpaque(true);
        this.imageLabel.setBackground(bgClr);
        constraints.weighty = 0.2;
        constraints.gridx = 2;
        constraints.gridy = 1;
        grid.setConstraints(this.imageLabel, constraints);
        rightPane.add(this.imageLabel);
        mainPane.add((Component)rightPane, "right");
        mainPane.setPreferredSize(new Dimension(800, 600));
        Container contentPane = this.frame.getContentPane();
        contentPane.add((Component)mainPane, "Center");
        contentPane.add((Component)this.toolBar, "First");
        this.frame.pack();
    }

    private JPanel createFrontView() {
        JPanel frontViewWithSlider = new JPanel();
        frontViewWithSlider.setLayout(new BorderLayout());
        this.frontView = new TreePreview(this.previewTree, 0, this.config);
        this.frontView.setOpaque(true);
        this.frontView.setBackground(Color.WHITE);
        frontViewWithSlider.add((Component)this.frontView, "Center");
        this.rotator = new JSlider(-180, 180);
        this.rotator.setPaintLabels(true);
        this.rotator.setPaintTicks(true);
        this.rotator.setPaintTrack(true);
        this.rotator.setMinorTickSpacing(10);
        this.rotator.setMajorTickSpacing(90);
        this.rotator.setBackground(new Color(250, 250, 245));
        this.rotator.setBorder(BorderFactory.createMatteBorder(0, 0, 0, 1, frontViewWithSlider.getBackground()));
        this.rotator.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent e) {
                JSlider source = (JSlider)e.getSource();
                Workplace.this.frontView.setDraft(source.getValueIsAdjusting());
                Workplace.this.topView.setDraft(source.getValueIsAdjusting());
                Workplace.this.frontView.setRotation(Workplace.this.rotator.getValue());
                Workplace.this.topView.setRotation(Workplace.this.rotator.getValue());
            }
        });
        frontViewWithSlider.add((Component)this.rotator, "South");
        return frontViewWithSlider;
    }

    JToolBar createToolBar() {
        this.toolBar = new JToolBar();
        this.addToolBarButton(this.fileNewAction);
        this.addToolBarButton(this.fileOpenAction);
        this.addToolBarButton(this.fileSaveAction);
        this.toolBar.add(Box.createRigidArea(new Dimension(10, 10)));
        this.addToolBarButton(this.exportTreeAction);
        this.addToolBarButton(this.renderTreeAction);
        return this.toolBar;
    }

    void addToolBarButton(AbstractAction action) {
        JButton button = new JButton(action);
        button.setText("");
        this.toolBar.add(button);
    }

    void createMenuBar() {
        JMenuBar menubar = new JMenuBar();
        JMenu menu = new JMenu("File");
        menu.setMnemonic('F');
        JMenuItem item = new JMenuItem(this.fileNewAction);
        menu.add(item);
        item = new JMenuItem(this.fileOpenAction);
        menu.add(item);
        item = new JMenuItem(this.fileSaveAction);
        menu.add(item);
        item = new JMenuItem(new FileSaveAsAction());
        menu.add(item);
        menu.add(new JSeparator());
        item = new JMenuItem(this.exportTreeAction);
        menu.add(item);
        item = new JMenuItem(this.renderTreeAction);
        menu.add(item);
        menu.add(new JSeparator());
        item = new JMenuItem(this.quitAction);
        menu.add(item);
        menubar.add(menu);
        menu = new JMenu("Setup");
        menu.setMnemonic('S');
        item = new JMenuItem(new SetupArbaroAction());
        menu.add(item);
        menubar.add(menu);
        menu = new JMenu("Help");
        menu.setMnemonic('H');
        item = new JMenuItem(new HelpAboutAction());
        menu.add(item);
        menubar.add(menu);
        this.frame.setJMenuBar(menubar);
    }

    void setModified(boolean mod) {
        this.modified = mod;
        this.params.enableDisable();
    }

    boolean shouldSave() {
        if (this.modified) {
            int result = JOptionPane.showConfirmDialog(this.frame, "Some parameters are modified. Should the tree definition be saved?", "Tree definition modified", 1, 3);
            if (result == 0) {
                if (this.treefile != null) {
                    return this.fileSave();
                }
                return this.fileSaveAs();
            }
            return result != 2;
        }
        return true;
    }

    boolean fileSaveAs() {
        int returnVal = this.fileChooser.showSaveDialog(this.frame);
        if (returnVal == 0) {
            this.treefile = this.fileChooser.getSelectedFile();
            return this.fileSave();
        }
        return false;
    }

    boolean fileSave() {
        System.err.println("saving to file: " + this.fileChooser.getSelectedFile().getName());
        try {
            PrintWriter out = new PrintWriter(new FileWriter(this.treefile));
            this.params.toXML(out);
            this.setModified(false);
            return true;
        }
        catch (ParamException err) {
            JOptionPane.showMessageDialog(this.frame, err.getMessage(), "Parameter Error", 0);
        }
        catch (FileNotFoundException err) {
            JOptionPane.showMessageDialog(this.frame, err.getMessage(), "File not found", 0);
        }
        catch (IOException err) {
            JOptionPane.showMessageDialog(this.frame, err.getMessage(), "Output error", 0);
        }
        return false;
    }

    class FileNewAction
    extends AbstractAction {
        private static final long serialVersionUID = 1L;

        public FileNewAction() {
            super("New", Workplace.createImageIcon("images/actions/New24.png", "New"));
            this.putValue("ShortDescription", "New file");
            this.putValue("MnemonicKey", new Integer(78));
        }

        public void actionPerformed(ActionEvent e) {
            Workplace.this.valueEditor.stopEditing();
            if (!Workplace.this.shouldSave()) {
                return;
            }
            AbstractParam.loading = true;
            Workplace.this.params.clearParams();
            Workplace.this.setModified(false);
            AbstractParam.loading = false;
            Workplace.this.groupsView.fireStateChanged();
            Workplace.this.params.prepare(13);
            Workplace.this.frame.setTitle("Arbaro [" + Workplace.this.params.Species + "]");
            try {
                Workplace.this.previewTree.setParams(Workplace.this.params);
                Workplace.this.previewTree.remake(true);
            }
            catch (ParamException err) {
                Workplace.this.setModified(false);
                JOptionPane.showMessageDialog(Workplace.this.frame, err.getMessage(), "Parameter Error", 0);
            }
            catch (Exception err) {
                System.err.println(err);
                err.printStackTrace();
            }
        }
    }

    class FileOpenAction
    extends AbstractAction {
        private static final long serialVersionUID = 1L;

        public FileOpenAction() {
            super("Open...", Workplace.createImageIcon("images/actions/Open24.png", "Open"));
            this.putValue("ShortDescription", "Open file");
            this.putValue("MnemonicKey", new Integer(79));
        }

        public void actionPerformed(ActionEvent e) {
            Workplace.this.valueEditor.stopEditing();
            if (!Workplace.this.shouldSave()) {
                return;
            }
            int returnVal = Workplace.this.fileChooser.showOpenDialog(Workplace.this.frame);
            if (returnVal == 0) {
                System.err.println("opening file: " + Workplace.this.fileChooser.getSelectedFile().getName());
                try {
                    AbstractParam.loading = true;
                    Workplace.this.params.clearParams();
                    Workplace.this.treefile = Workplace.this.fileChooser.getSelectedFile();
                    Workplace.this.params.readFromXML(new FileInputStream(Workplace.this.treefile));
                    AbstractParam.loading = false;
                    Workplace.this.setModified(false);
                    Workplace.this.groupsView.fireStateChanged();
                    Workplace.this.params.prepare(13);
                    Workplace.this.frame.setTitle("Arbaro [" + Workplace.this.params.Species + "]");
                    Workplace.this.previewTree.setParams(Workplace.this.params);
                    Workplace.this.previewTree.remake(true);
                }
                catch (ParamException err) {
                    Workplace.this.setModified(false);
                    ShowException.msgBox(Workplace.this.frame, "Parameter Error", err);
                }
                catch (FileNotFoundException err) {
                    ShowException.msgBox(Workplace.this.frame, "File not found", err);
                }
                catch (Exception err) {
                    Console.printException(err);
                    ShowException.msgBox(Workplace.this.frame, "Error opening file", err);
                }
            }
        }
    }

    class FileSaveAction
    extends AbstractAction {
        private static final long serialVersionUID = 1L;

        public FileSaveAction() {
            super("Save", Workplace.createImageIcon("images/actions/Save24.png", "Save"));
            this.putValue("ShortDescription", "Save file");
            this.putValue("MnemonicKey", new Integer(83));
        }

        public void actionPerformed(ActionEvent e) {
            Workplace.this.valueEditor.stopEditing();
            if (Workplace.this.treefile != null) {
                Workplace.this.fileSave();
            } else {
                Workplace.this.fileSaveAs();
            }
        }
    }

    class FileSaveAsAction
    extends AbstractAction {
        private static final long serialVersionUID = 1L;

        public FileSaveAsAction() {
            super("Save as...", Workplace.createImageIcon("images/actions/SaveAs24.png", "SaveAs"));
            this.putValue("ShortDescription", "Save file as");
            this.putValue("MnemonicKey", new Integer(65));
        }

        public void actionPerformed(ActionEvent e) {
            Workplace.this.valueEditor.stopEditing();
            Workplace.this.fileSaveAs();
        }
    }

    class ExportTreeAction
    extends AbstractAction {
        private static final long serialVersionUID = 1L;

        public ExportTreeAction() {
            super("Export tree...", Workplace.createImageIcon("images/actions/Create24.png", "Export"));
            this.putValue("ShortDescription", "Create and export tree");
            this.putValue("MnemonicKey", new Integer(67));
        }

        public void actionPerformed(ActionEvent e) {
            Workplace.this.valueEditor.stopEditing();
            new ExportDialog(Workplace.this.frame, Workplace.this.seed, Workplace.this.params, Workplace.this.config, false);
        }
    }

    class RenderTreeAction
    extends AbstractAction {
        private static final long serialVersionUID = 1L;

        public RenderTreeAction() {
            super("Render tree...", Workplace.createImageIcon("images/actions/Render24.png", "Render"));
            this.putValue("ShortDescription", "Create, export and render tree");
            this.putValue("MnemonicKey", new Integer(82));
        }

        public void actionPerformed(ActionEvent e) {
            Workplace.this.valueEditor.stopEditing();
            new ExportDialog(Workplace.this.frame, Workplace.this.seed, Workplace.this.params, Workplace.this.config, true);
        }
    }

    class SetupArbaroAction
    extends AbstractAction {
        private static final long serialVersionUID = 1L;

        public SetupArbaroAction() {
            super("Setup...", Workplace.createImageIcon("images/actions/Preferences24.png", "Setup"));
            this.putValue("ShortDescription", "Setup Arbaro");
            this.putValue("MnemonicKey", new Integer(83));
        }

        public void actionPerformed(ActionEvent e) {
            new CfgDialog(Workplace.this, Workplace.this.frame, Workplace.this.config);
        }
    }

    class QuitAction
    extends AbstractAction {
        private static final long serialVersionUID = 1L;

        public QuitAction() {
            super("Quit", null);
            this.putValue("ShortDescription", "Quit Arbaro");
            this.putValue("MnemonicKey", new Integer(81));
        }

        public void actionPerformed(ActionEvent e) {
            Workplace.this.valueEditor.stopEditing();
            if (!Workplace.this.shouldSave()) {
                return;
            }
            Workplace.this.frame.dispose();
        }
    }

    class HelpAboutAction
    extends AbstractAction {
        private static final long serialVersionUID = 1L;

        public HelpAboutAction() {
            super("About Arbaro...", Workplace.createImageIcon("images/actions/About24.png", "About"));
            this.putValue("ShortDescription", "About Arbaro");
            this.putValue("MnemonicKey", new Integer(65));
        }

        public void actionPerformed(ActionEvent e) {
            JOptionPane.showMessageDialog(Workplace.this.frame, "Arbaro 2.0 - creates trees objects for rendering from xml parameter files\n(c) 2003-2004 by Wolfram Diestel <diestel@steloj.de> (GPL see file COPYING)\n", "About Arbaro", 1, aboutIcon);
        }
    }
}

