/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.arbaro.gui;

import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTextField;
import net.sourceforge.arbaro.export.ExporterFactory;
import net.sourceforge.arbaro.gui.Config;
import net.sourceforge.arbaro.gui.Workplace;

public class CfgDialog {
    JFrame frame;
    JPanel mainPanel;
    JComboBox formatBox;
    JFileChooser fileChooser;
    JTextField fileField;
    JTextField pathField;
    JTextField widthField;
    JTextField heightField;
    JTextField seedField;
    JCheckBox antialiasBox;
    String fileSep = System.getProperty("file.separator");
    Config config;
    Workplace workplace;

    public CfgDialog(Workplace wplace, JFrame parent, Config cfg) {
        this.config = cfg;
        this.workplace = wplace;
        this.frame = new JFrame("Arbaro setup");
        this.frame.setIconImage(parent.getIconImage());
        this.fileChooser = new JFileChooser();
        this.createGUI();
        this.frame.setVisible(true);
    }

    void createGUI() {
        this.mainPanel = new JPanel();
        GridBagLayout grid = new GridBagLayout();
        this.mainPanel.setLayout(grid);
        this.mainPanel.setBorder(BorderFactory.createEmptyBorder(30, 30, 30, 30));
        GridBagConstraints clabel = new GridBagConstraints();
        clabel.gridx = 0;
        clabel.anchor = 17;
        GridBagConstraints ctext = new GridBagConstraints();
        ctext.gridx = 1;
        ctext.ipady = 4;
        ctext.anchor = 17;
        ctext.insets = new Insets(1, 5, 1, 5);
        GridBagConstraints cbutton = new GridBagConstraints();
        cbutton.gridx = 2;
        cbutton.anchor = 17;
        int line = -1;
        clabel.gridy = ++line;
        JLabel label = new JLabel("Default export format:");
        grid.setConstraints(label, clabel);
        this.mainPanel.add(label);
        ctext.gridy = line++;
        this.formatBox = new JComboBox<String>(ExporterFactory.getExportFormats());
        this.formatBox.setEditable(false);
        this.formatBox.setSelectedIndex(Integer.parseInt(this.config.getProperty("export.format", "0")));
        grid.setConstraints(this.formatBox, ctext);
        this.mainPanel.add(this.formatBox);
        clabel.gridy = line;
        label = new JLabel("Output path:");
        grid.setConstraints(label, clabel);
        this.mainPanel.add(label);
        ctext.gridy = line;
        this.pathField = new JTextField(30);
        this.pathField.setText(this.config.getProperty("export.path", String.valueOf(System.getProperty("user.dir")) + this.fileSep + "pov"));
        grid.setConstraints(this.pathField, ctext);
        this.mainPanel.add(this.pathField);
        cbutton.gridy = line++;
        JButton selectFile = new JButton("Choose...");
        selectFile.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent event) {
                int returnVal = CfgDialog.this.fileChooser.showSaveDialog(CfgDialog.this.frame);
                if (returnVal == 0) {
                    CfgDialog.this.pathField.setText(CfgDialog.this.fileChooser.getSelectedFile().getPath());
                }
            }
        });
        grid.setConstraints(selectFile, cbutton);
        this.mainPanel.add(selectFile);
        clabel.gridy = line;
        label = new JLabel("POVRay executable:");
        grid.setConstraints(label, clabel);
        this.mainPanel.add(label);
        ctext.gridy = line;
        this.fileField = new JTextField(30);
        this.fileField.setText(this.config.getProperty("povray.executable", Config.defaultPovrayExe()));
        grid.setConstraints(this.fileField, ctext);
        this.mainPanel.add(this.fileField);
        cbutton.gridy = line++;
        selectFile = new JButton("Choose...");
        selectFile.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent event) {
                int returnVal = CfgDialog.this.fileChooser.showSaveDialog(CfgDialog.this.frame);
                if (returnVal == 0) {
                    CfgDialog.this.fileField.setText(CfgDialog.this.fileChooser.getSelectedFile().getPath());
                }
            }
        });
        grid.setConstraints(selectFile, cbutton);
        this.mainPanel.add(selectFile);
        clabel.gridy = line;
        label = new JLabel("Render width:");
        grid.setConstraints(label, clabel);
        this.mainPanel.add(label);
        ctext.gridy = line++;
        this.widthField = new JTextField(10);
        this.widthField.setAlignmentX(1.0f);
        this.widthField.setText(this.config.getProperty("povray.width", "400"));
        grid.setConstraints(this.widthField, ctext);
        this.mainPanel.add(this.widthField);
        clabel.gridy = line;
        label = new JLabel("Render height:");
        grid.setConstraints(label, clabel);
        this.mainPanel.add(label);
        ctext.gridy = line++;
        this.heightField = new JTextField(10);
        this.heightField.setAlignmentX(1.0f);
        this.heightField.setText(this.config.getProperty("povray.height", "600"));
        grid.setConstraints(this.heightField, ctext);
        this.mainPanel.add(this.heightField);
        clabel.gridy = line;
        label = new JLabel("Default seed:");
        grid.setConstraints(label, clabel);
        this.mainPanel.add(label);
        ctext.gridy = line++;
        this.seedField = new JTextField(10);
        this.seedField.setAlignmentX(1.0f);
        this.seedField.setText(this.config.getProperty("tree.seed", "13"));
        grid.setConstraints(this.seedField, ctext);
        this.mainPanel.add(this.seedField);
        clabel.gridy = line;
        label = new JLabel("Antialias:");
        grid.setConstraints(label, clabel);
        this.mainPanel.add(label);
        ctext.gridy = line;
        this.antialiasBox = new JCheckBox();
        this.antialiasBox.setAlignmentX(1.0f);
        this.antialiasBox.setText("use antialiasing in tree preview");
        this.antialiasBox.setSelected(this.config.getProperty("preview.antialias", "on").equals("on"));
        grid.setConstraints(this.antialiasBox, ctext);
        this.mainPanel.add(this.antialiasBox);
        JButton okButton = new JButton("OK");
        okButton.addActionListener(new OKButtonListener());
        JButton cancelButton = new JButton("Cancel");
        cancelButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                CfgDialog.this.frame.dispose();
            }
        });
        JPanel buttons = new JPanel();
        buttons.add(okButton);
        buttons.add(cancelButton);
        cbutton.gridx = 1;
        cbutton.gridy = 7;
        cbutton.anchor = 10;
        grid.setConstraints(buttons, cbutton);
        this.mainPanel.add(buttons);
        this.frame.getContentPane().add(this.mainPanel);
        this.frame.pack();
    }

    class OKButtonListener
    implements ActionListener {
        OKButtonListener() {
        }

        public void actionPerformed(ActionEvent e) {
            CfgDialog.this.config.setProperty("export.format", "" + CfgDialog.this.formatBox.getSelectedIndex());
            CfgDialog.this.config.setProperty("export.path", CfgDialog.this.pathField.getText());
            CfgDialog.this.config.setProperty("povray.executable", CfgDialog.this.fileField.getText());
            CfgDialog.this.config.setProperty("povray.width", CfgDialog.this.widthField.getText());
            CfgDialog.this.config.setProperty("povray.height", CfgDialog.this.heightField.getText());
            CfgDialog.this.config.setProperty("tree.seed", CfgDialog.this.seedField.getText());
            if (CfgDialog.this.antialiasBox.isSelected()) {
                CfgDialog.this.config.setProperty("preview.antialias", "on");
            } else {
                CfgDialog.this.config.setProperty("preview.antialias", "off");
            }
            CfgDialog.this.frame.dispose();
            try {
                CfgDialog.this.config.store();
                CfgDialog.this.workplace.applyConfig();
            }
            catch (Exception err) {
                JOptionPane.showMessageDialog(CfgDialog.this.frame, err.getMessage(), "Setup Error", 0);
            }
        }
    }
}

