/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.arbaro.export;

import java.io.PrintWriter;
import java.text.NumberFormat;
import net.sourceforge.arbaro.mesh.VFace;
import net.sourceforge.arbaro.params.FloatFormat;
import net.sourceforge.arbaro.transformation.Vector;

final class DXFWriter {
    PrintWriter w;
    NumberFormat frm = FloatFormat.getInstance();

    public DXFWriter(PrintWriter w) {
        this.w = w;
    }

    public void writeHeader(String comment, Vector minPoint, Vector maxPoint) {
        this.wg(999, comment);
        this.wg(0, "SECTION");
        this.wg(2, "HEADER");
        this.wg(9, "$INSBASE");
        this.writePoint(new Vector(), 0);
        this.wg(9, "$EXTMIN");
        this.writePoint(minPoint, 0);
        this.wg(9, "$EXTMAX");
        this.writePoint(maxPoint, 0);
        this.wg(0, "ENDSEC");
    }

    public void writeTables() {
        this.wg(0, "SECTION");
        this.wg(2, "TABLES");
        this.writeLineTable();
        this.writeLayerTable();
        this.wg(0, "ENDSEC");
    }

    public void writeLineTable() {
        this.wg(0, "TABLE");
        this.wg(2, "LTYPE");
        this.wg(70, "1");
        this.wg(0, "LTYPE");
        this.wg(2, "CONTINUOUS");
        this.wg(70, "64");
        this.wg(3, "Solid line");
        this.wg(72, "65");
        this.wg(73, "0");
        this.wg(40, "0.000000");
        this.wg(0, "ENDTAB");
    }

    public void writeLayerTable() {
        this.wg(0, "TABLE");
        this.wg(2, "LAYER");
        this.wg(70, "6");
        this.wg(0, "LAYER");
        this.wg(2, "1");
        this.wg(70, "64");
        this.wg(62, "7");
        this.wg(6, "CONTINUOUS");
        this.wg(0, "LAYER");
        this.wg(2, "2");
        this.wg(70, "64");
        this.wg(62, "7");
        this.wg(6, "CONTINUOUS");
        this.wg(0, "ENDTAB");
    }

    public void writeStyleTable() {
        this.wg(0, "TABLE");
        this.wg(2, "STYLE");
        this.wg(70, "0");
        this.wg(0, "ENDTAB");
    }

    public void writeBlocks() {
        this.wg(0, "SECTION");
        this.wg(2, "BLOCKS");
        this.wg(0, "ENDSEC");
    }

    public void writeEntitiesBegin() {
        this.wg(0, "SECTION");
        this.wg(2, "ENTITIES");
    }

    public void writeEntitiesEnd() {
        this.wg(0, "ENDSEC");
    }

    void wg(int code, String val) {
        this.w.println("" + code);
        this.w.println(val);
    }

    public void writeFace(Vector u, Vector v, Vector w, String layer) {
        this.wg(0, "3DFACE");
        this.wg(8, layer);
        this.wg(62, "1");
        this.writePoint(u, 0);
        this.writePoint(v, 1);
        this.writePoint(w, 2);
        this.writePoint(w, 3);
    }

    public void writeFace(VFace face, String layer) {
        this.wg(0, "3DFACE");
        this.wg(8, layer);
        this.wg(62, layer);
        this.writePoint(face.points[0], 0);
        this.writePoint(face.points[1], 1);
        this.writePoint(face.points[2], 2);
        this.writePoint(face.points[2], 3);
    }

    public void writePoint(Vector v, int n) {
        this.wg(10 + n, this.frm.format(v.getX()));
        this.wg(20 + n, this.frm.format(v.getZ()));
        this.wg(30 + n, this.frm.format(v.getY()));
    }
}

