/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.arbaro.export;

import java.io.PrintWriter;
import net.sourceforge.arbaro.export.Console;
import net.sourceforge.arbaro.export.Exporter;
import net.sourceforge.arbaro.export.Progress;

abstract class AbstractExporter
implements Exporter {
    protected static final int LEAF_PROGRESS_STEP = 500;
    protected static final int STEM_PROGRESS_STEP = 100;
    protected static final int MESH_PROGRESS_STEP = 500;
    protected PrintWriter w;
    Progress progress;
    long progressCount = 0L;

    AbstractExporter() {
    }

    public Progress getProgress() {
        return this.progress;
    }

    public PrintWriter getWriter() {
        return this.w;
    }

    public void write(PrintWriter w, Progress progress) {
        this.w = w;
        this.progress = progress;
        progress.beginPhase("writing tree code", -1L);
        this.doWrite();
        progress.endPhase();
    }

    protected abstract void doWrite();

    protected void incProgressCount(int step) {
        if (this.progressCount++ % (long)step == 0L) {
            this.progress.incProgress(step);
            Console.progressChar();
        }
    }
}

