/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.arbaro.mesh;

import net.sourceforge.arbaro.export.Console;
import net.sourceforge.arbaro.export.Progress;
import net.sourceforge.arbaro.mesh.Mesh;
import net.sourceforge.arbaro.mesh.MeshPart;
import net.sourceforge.arbaro.mesh.MeshPartCreator;
import net.sourceforge.arbaro.tree.Leaf;
import net.sourceforge.arbaro.tree.Stem;
import net.sourceforge.arbaro.tree.Tree;
import net.sourceforge.arbaro.tree.TreeTraversal;

class MeshCreator
implements TreeTraversal {
    Mesh mesh;
    Tree tree;
    Progress progress;
    int level;
    boolean useQuads;

    public MeshCreator(Mesh mesh, int level, boolean useQuads, Progress progress) {
        this.mesh = mesh;
        this.level = level;
        this.useQuads = useQuads;
        this.progress = progress;
    }

    public boolean enterStem(Stem stem) {
        if (this.level >= 0 && stem.getLevel() < this.level) {
            return true;
        }
        if (this.level >= 0 && stem.getLevel() > this.level) {
            return false;
        }
        MeshPartCreator partCreator = new MeshPartCreator(stem, this.useQuads);
        MeshPart meshpart = partCreator.createMeshPart(this.progress);
        if (meshpart != null) {
            this.mesh.addMeshpart(meshpart);
        }
        if (stem.getLevel() <= 1 && !stem.isClone()) {
            Console.progressChar();
        }
        this.progress.incProgress(1L);
        return true;
    }

    public boolean enterTree(Tree tree) {
        this.tree = tree;
        return true;
    }

    public boolean leaveStem(Stem stem) {
        return true;
    }

    public boolean leaveTree(Tree tree) {
        return true;
    }

    public boolean visitLeaf(Leaf leaf) {
        return false;
    }
}

