/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.arbaro.export;

import net.sourceforge.arbaro.export.AbstractExporter;
import net.sourceforge.arbaro.export.OBJLeafWriterBase;
import net.sourceforge.arbaro.mesh.Face;
import net.sourceforge.arbaro.mesh.LeafMesh;
import net.sourceforge.arbaro.tree.Leaf;
import net.sourceforge.arbaro.tree.Tree;

class OBJLeafFaceWriter
extends OBJLeafWriterBase {
    boolean firstLeaf = true;
    long faceProgressCount = 0L;
    long smoothingGroup;
    int uvVertexOffset;
    boolean outputLeafUVs = true;
    boolean outputStemUVs = true;
    boolean outputNormals = false;

    public OBJLeafFaceWriter(Tree tree, AbstractExporter exporter, LeafMesh leafMesh, int leafVertexOffset, int uvVertexOffset, long smoothingGroup, boolean outputLeafUVs, boolean outputStemUVs) {
        super(tree, leafMesh, exporter, leafVertexOffset);
        this.smoothingGroup = smoothingGroup;
        this.uvVertexOffset = uvVertexOffset;
        this.outputLeafUVs = outputLeafUVs;
        this.outputStemUVs = outputStemUVs;
    }

    public boolean visitLeaf(Leaf l) {
        if (this.firstLeaf) {
            this.w.println("g leaves");
            this.w.println("usemtl leaves");
            this.firstLeaf = false;
        }
        this.w.println("s " + this.smoothingGroup++);
        int i = 0;
        while (i < this.leafMesh.getShapeFaceCount()) {
            Face face = this.leafMesh.shapeFaceAt(i);
            this.writeFace(face, this.leafVertexOffset, face, this.uvVertexOffset, this.outputLeafUVs, this.outputNormals);
            ++i;
        }
        this.leafVertexOffset += this.leafMesh.getShapeVertexCount();
        this.exporter.incProgressCount(500);
        return true;
    }

    private void writeFace(Face f, long offset, Face uv, long uvOffset, boolean writeUVs, boolean writeNormals) {
        this.w.print("f ");
        int i = 0;
        while (i < f.points.length) {
            this.w.print(offset + f.points[i]);
            if (writeUVs || writeNormals) {
                this.w.print("/");
                if (writeUVs) {
                    this.w.print(uvOffset + uv.points[i]);
                }
                if (writeNormals) {
                    this.w.print("/" + offset + f.points[i]);
                }
            }
            if (i < f.points.length - 1) {
                this.w.print(" ");
            } else {
                this.w.println();
            }
            ++i;
        }
    }
}

