/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.arbaro.params;

import net.sourceforge.arbaro.params.AbstractParam;
import net.sourceforge.arbaro.params.ParamException;

public class IntParam
extends AbstractParam {
    private int min;
    private int max;
    private int deflt;
    private int value;

    IntParam(String nam, int mn, int mx, int def, String grp, int lev, int ord, String sh, String lng) {
        super(nam, grp, lev, ord, sh, lng);
        this.min = mn;
        this.max = mx;
        this.deflt = def;
        this.value = Integer.MIN_VALUE;
    }

    public String getDefaultValue() {
        Integer i = new Integer(this.deflt);
        return i.toString();
    }

    public void clear() {
        this.value = Integer.MIN_VALUE;
        this.fireStateChanged();
    }

    public void setValue(String val) throws ParamException {
        int i;
        try {
            i = Integer.parseInt(val);
        }
        catch (NumberFormatException e) {
            throw new ParamException("Error setting value of " + this.name + ". \"" + val + "\" isn't a valid integer.");
        }
        if (i < this.min) {
            throw new ParamException("Value of " + this.name + " should be greater or equal to " + this.min);
        }
        if (i > this.max) {
            throw new ParamException("Value of " + this.name + " should be greater or equal to " + this.max);
        }
        this.value = i;
        this.fireStateChanged();
    }

    public String getValue() {
        Integer i = new Integer(this.value);
        return i.toString();
    }

    public boolean empty() {
        return this.value == Integer.MIN_VALUE;
    }

    public int intValue() {
        if (this.empty()) {
            this.warn(String.valueOf(this.name) + " not given, using default value(" + this.deflt + ")");
            this.value = this.deflt;
            this.fireStateChanged();
        }
        return this.value;
    }

    public String getLongDesc() {
        String desc = super.getLongDesc();
        desc = String.valueOf(desc) + "<br><br>";
        if (this.min != Integer.MIN_VALUE) {
            desc = String.valueOf(desc) + "Minimum: " + this.min + "\n";
        }
        if (this.max != Integer.MAX_VALUE) {
            desc = String.valueOf(desc) + "Maximum: " + this.max + "\n";
        }
        if (this.deflt != Integer.MIN_VALUE) {
            desc = String.valueOf(desc) + "Default: " + this.deflt + "\n";
        }
        return desc;
    }
}

