/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.arbaro.mesh;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.sourceforge.arbaro.mesh.DiscShape;
import net.sourceforge.arbaro.mesh.Face;
import net.sourceforge.arbaro.mesh.LeafShape;
import net.sourceforge.arbaro.mesh.SphereShape;
import net.sourceforge.arbaro.mesh.SquareShape;
import net.sourceforge.arbaro.mesh.UVVector;
import net.sourceforge.arbaro.mesh.Vertex;

public class LeafMesh {
    LeafShape shape;
    long faceOffset;
    static /* synthetic */ Class class$0;

    public LeafMesh(String leafShape, double length, double width, double stemLen, boolean useQuads) {
        Pattern pattern = Pattern.compile("disc(\\d*)");
        Matcher m = pattern.matcher(leafShape);
        if (m.matches()) {
            int facecnt = 6;
            if (!m.group(1).equals("")) {
                facecnt = Integer.parseInt(m.group(1));
            }
            this.shape = new DiscShape(facecnt, length, width, stemLen, useQuads);
        } else if (leafShape.equals("square")) {
            this.shape = new SquareShape(length, width, stemLen, useQuads);
        } else if (leafShape.equals("sphere")) {
            this.shape = new SphereShape(length, width, stemLen);
        } else {
            int facecnt = 6;
            this.shape = new DiscShape(facecnt, length, width, stemLen, useQuads);
        }
    }

    public boolean isFlat() {
        Class<?> clazz = this.shape.getClass();
        Class<?> clazz2 = class$0;
        if (clazz2 == null) {
            try {
                clazz2 = class$0 = Class.forName("net.sourceforge.arbaro.mesh.SphereShape");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        return clazz != clazz2;
    }

    public Vertex shapeVertexAt(int i) {
        return this.shape.vertices[i];
    }

    public UVVector shapeUVAt(int i) {
        return this.shape.vertices[i].uv;
    }

    public Face shapeFaceAt(int i) {
        return this.shape.faces[i];
    }

    public int getShapeVertexCount() {
        return this.shape.getVertexCount();
    }

    public int getShapeFaceCount() {
        return this.shape.getFaceCount();
    }
}

