/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.arbaro.params;

import java.io.PrintWriter;
import java.util.Hashtable;
import net.sourceforge.arbaro.params.FloatParam;
import net.sourceforge.arbaro.params.IntParam;
import net.sourceforge.arbaro.params.ParamException;
import net.sourceforge.arbaro.params.Random;

public class LevelParams {
    public int level;
    public double nTaper;
    public int nCurveRes;
    public double nCurve;
    public double nCurveV;
    public double nCurveBack;
    public double nLength;
    public double nLengthV;
    public double nSegSplits;
    public double nSplitAngle;
    public double nSplitAngleV;
    public int nBranches;
    public double nBranchDist;
    public double nDownAngle;
    public double nDownAngleV;
    public double nRotate;
    public double nRotateV;
    public int mesh_points;
    public double splitErrorValue;
    public double substemErrorValue;
    public Random random;
    Hashtable paramDB;
    private long randstate;
    private double spliterrval;

    public LevelParams(int l, Hashtable parDB) {
        this.level = l;
        this.paramDB = parDB;
        this.randstate = Long.MIN_VALUE;
        this.spliterrval = Double.NaN;
    }

    public long initRandom(long seed) {
        this.random = new Random(seed);
        return this.random.nextLong();
    }

    public double var(double variation) {
        return this.random.uniform(-variation, variation);
    }

    public void saveState() {
        this.randstate = this.random.getState();
        this.spliterrval = this.splitErrorValue;
    }

    public void restoreState() {
        if (Double.isNaN(this.spliterrval)) {
            System.err.println("BUG: there is no state saved, cannot restore.");
            System.exit(1);
        }
        this.random.setState(this.randstate);
        this.splitErrorValue = this.spliterrval;
    }

    private void writeParamXml(PrintWriter w, String name, int value) {
        String fullname = this.level + name.substring(1);
        w.println("    <param name='" + fullname + "' value='" + value + "'/>");
    }

    private void writeParamXML(PrintWriter w, String name, double value) {
        String fullname = this.level + name.substring(1);
        w.println("    <param name='" + fullname + "' value='" + value + "'/>");
    }

    void toXML(PrintWriter w, boolean leafLevelOnly) {
        w.println("    <!-- level " + this.level + " -->");
        this.writeParamXML(w, "nDownAngle", this.nDownAngle);
        this.writeParamXML(w, "nDownAngleV", this.nDownAngleV);
        this.writeParamXML(w, "nRotate", this.nRotate);
        this.writeParamXML(w, "nRotateV", this.nRotateV);
        if (!leafLevelOnly) {
            this.writeParamXml(w, "nBranches", this.nBranches);
            this.writeParamXML(w, "nBranchDist", this.nBranchDist);
            this.writeParamXML(w, "nLength", this.nLength);
            this.writeParamXML(w, "nLengthV", this.nLengthV);
            this.writeParamXML(w, "nTaper", this.nTaper);
            this.writeParamXML(w, "nSegSplits", this.nSegSplits);
            this.writeParamXML(w, "nSplitAngle", this.nSplitAngle);
            this.writeParamXML(w, "nSplitAngleV", this.nSplitAngleV);
            this.writeParamXml(w, "nCurveRes", this.nCurveRes);
            this.writeParamXML(w, "nCurve", this.nCurve);
            this.writeParamXML(w, "nCurveBack", this.nCurveBack);
            this.writeParamXML(w, "nCurveV", this.nCurveV);
        }
    }

    private int intParam(String name) throws ParamException {
        String fullname = this.level + name.substring(1);
        IntParam par = (IntParam)this.paramDB.get(fullname);
        if (par != null) {
            return par.intValue();
        }
        throw new ParamException("bug: param " + fullname + " not found!");
    }

    private double dblParam(String name) throws ParamException {
        String fullname = this.level + name.substring(1);
        FloatParam par = (FloatParam)this.paramDB.get(fullname);
        if (par != null) {
            return par.doubleValue();
        }
        throw new ParamException("bug: param " + fullname + " not found!");
    }

    void fromDB(boolean leafLevelOnly) throws ParamException {
        if (!leafLevelOnly) {
            this.nTaper = this.dblParam("nTaper");
            this.nCurveRes = this.intParam("nCurveRes");
            this.nCurve = this.dblParam("nCurve");
            this.nCurveV = this.dblParam("nCurveV");
            this.nCurveBack = this.dblParam("nCurveBack");
            this.nLength = this.dblParam("nLength");
            this.nLengthV = this.dblParam("nLengthV");
            this.nSegSplits = this.dblParam("nSegSplits");
            this.nSplitAngle = this.dblParam("nSplitAngle");
            this.nSplitAngleV = this.dblParam("nSplitAngleV");
            this.nBranches = this.intParam("nBranches");
        }
        this.nBranchDist = this.dblParam("nBranchDist");
        this.nDownAngle = this.dblParam("nDownAngle");
        this.nDownAngleV = this.dblParam("nDownAngleV");
        this.nRotate = this.dblParam("nRotate");
        this.nRotateV = this.dblParam("nRotateV");
    }
}

