/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.arbaro.transformation;

import net.sourceforge.arbaro.transformation.Vector;

public final class Matrix {
    static final int X = 0;
    static final int Y = 1;
    static final int Z = 2;
    private double[] data = new double[9];

    public Matrix() {
        int r = 0;
        while (r <= 2) {
            int c = 0;
            while (c <= 2) {
                this.data[r * 3 + c] = c == r ? 1 : 0;
                ++c;
            }
            ++r;
        }
    }

    public Matrix(double xx, double xy, double xz, double yx, double yy, double yz, double zx, double zy, double zz) {
        this.data[0] = xx;
        this.data[1] = xy;
        this.data[2] = xz;
        this.data[3] = yx;
        this.data[4] = yy;
        this.data[5] = yz;
        this.data[6] = zx;
        this.data[7] = zy;
        this.data[8] = zz;
    }

    public String toString() {
        return "x: " + this.row(0) + " y: " + this.row(1) + " z: " + this.row(2);
    }

    public Vector row(int r) {
        return new Vector(this.data[r * 3 + 0], this.data[r * 3 + 1], this.data[r * 3 + 2]);
    }

    public Vector col(int c) {
        return new Vector(this.data[0 + c], this.data[3 + c], this.data[6 + c]);
    }

    public double get(int r, int c) {
        return this.data[r * 3 + c];
    }

    public void set(int r, int c, double value) {
        this.data[r * 3 + c] = value;
    }

    public Matrix transpose() {
        Matrix T = new Matrix();
        int r = 0;
        while (r <= 2) {
            int c = 0;
            while (c <= 2) {
                T.set(r, c, this.data[c * 3 + r]);
                ++c;
            }
            ++r;
        }
        return T;
    }

    public Matrix mul(double factor) {
        Matrix R = new Matrix();
        int r = 0;
        while (r <= 2) {
            int c = 0;
            while (c <= 2) {
                R.set(r, c, this.data[r * 3 + c] * factor);
                ++c;
            }
            ++r;
        }
        return R;
    }

    public Matrix prod(Matrix M) {
        Matrix R = new Matrix();
        int r = 0;
        while (r <= 2) {
            int c = 0;
            while (c <= 2) {
                R.set(r, c, this.row(r).prod(M.col(c)));
                ++c;
            }
            ++r;
        }
        return R;
    }

    public Matrix add(Matrix M) {
        Matrix R = new Matrix();
        int r = 0;
        while (r <= 2) {
            int c = 0;
            while (c <= 2) {
                R.set(r, c, this.data[r * 3 + c] + M.get(r, c));
                ++c;
            }
            ++r;
        }
        return R;
    }

    public Vector prod(Vector v) {
        return new Vector(this.row(0).prod(v), this.row(1).prod(v), this.row(2).prod(v));
    }

    public Matrix div(double factor) {
        return this.mul(1.0 / factor);
    }

    public Matrix sub(Matrix M) {
        return this.add(M.mul(-1.0));
    }
}

