/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.arbaro.params;

import net.sourceforge.arbaro.params.AbstractParam;
import net.sourceforge.arbaro.params.ParamException;

public class FloatParam
extends AbstractParam {
    private double min;
    private double max;
    private double deflt;
    private double value;

    FloatParam(String nam, double mn, double mx, double def, String grp, int lev, int ord, String sh, String lng) {
        super(nam, grp, lev, ord, sh, lng);
        this.min = mn;
        this.max = mx;
        this.deflt = def;
        this.value = Double.NaN;
    }

    public String getDefaultValue() {
        Double d = new Double(this.deflt);
        return d.toString();
    }

    public void clear() {
        this.value = Double.NaN;
        this.fireStateChanged();
    }

    public void setValue(String val) throws ParamException {
        double d;
        try {
            d = Double.parseDouble(val);
        }
        catch (NumberFormatException e) {
            throw new ParamException("Error setting value of " + this.name + ". \"" + val + "\" isn't a valid number.");
        }
        if (d < this.min) {
            throw new ParamException("Value of " + this.name + " should be greater then or equal to " + this.min);
        }
        if (d > this.max) {
            throw new ParamException("Value of " + this.name + " should be less then or equal to " + this.max);
        }
        this.value = d;
        this.fireStateChanged();
    }

    public String getValue() {
        Double d = new Double(this.value);
        return d.toString();
    }

    public boolean empty() {
        return Double.isNaN(this.value);
    }

    public double doubleValue() {
        if (this.empty()) {
            this.warn(String.valueOf(this.name) + " not given, using default value(" + this.deflt + ")");
            this.value = this.deflt;
            this.fireStateChanged();
        }
        return this.value;
    }

    public String getLongDesc() {
        String desc = super.getLongDesc();
        desc = String.valueOf(desc) + "<br><br>";
        if (!Double.isNaN(this.min)) {
            desc = String.valueOf(desc) + "Minimum: " + this.min + "\n";
        }
        if (!Double.isNaN(this.max)) {
            desc = String.valueOf(desc) + "Maximum: " + this.max + "\n";
        }
        if (!Double.isNaN(this.deflt)) {
            desc = String.valueOf(desc) + "Default: " + this.deflt + "\n";
        }
        return desc;
    }
}

