/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.arbaro.export;

import java.text.NumberFormat;
import java.util.Enumeration;
import net.sourceforge.arbaro.export.MeshExporter;
import net.sourceforge.arbaro.export.POVMeshLeafFaceWriter;
import net.sourceforge.arbaro.export.POVMeshLeafUVFaceWriter;
import net.sourceforge.arbaro.export.POVMeshLeafVertexWriter;
import net.sourceforge.arbaro.mesh.Face;
import net.sourceforge.arbaro.mesh.LeafMesh;
import net.sourceforge.arbaro.mesh.Mesh;
import net.sourceforge.arbaro.mesh.MeshException;
import net.sourceforge.arbaro.mesh.MeshGenerator;
import net.sourceforge.arbaro.mesh.MeshPart;
import net.sourceforge.arbaro.mesh.UVVector;
import net.sourceforge.arbaro.mesh.Vertex;
import net.sourceforge.arbaro.params.FloatFormat;
import net.sourceforge.arbaro.transformation.Vector;
import net.sourceforge.arbaro.tree.Tree;

class POVMeshExporter
extends MeshExporter {
    Mesh mesh;
    LeafMesh leafMesh;
    Tree tree;
    long leafVertexOffset;
    long stemsProgressCount = 0L;
    boolean outputStemNormals = true;
    boolean outputLeafNormals = false;
    public boolean outputLeafUVs = true;
    public boolean outputStemUVs = true;
    String povrayDeclarationPrefix;
    static final NumberFormat fmt = FloatFormat.getInstance();

    public POVMeshExporter(Tree tree, MeshGenerator meshGenerator) {
        super(meshGenerator);
        this.tree = tree;
        this.povrayDeclarationPrefix = String.valueOf(tree.getSpecies()) + "_" + tree.getSeed() + "_";
    }

    public void doWrite() {
        this.w.println("/*************** Tree made by: ******************");
        this.w.println();
        this.w.println("Arbaro 2.0 - creates trees objects for rendering from xml parameter files\n(c) 2003-2004 by Wolfram Diestel <diestel@steloj.de> (GPL see file COPYING)\n");
        this.w.println();
        this.tree.paramsToXML(this.w);
        this.w.println("************************************************/");
        this.w.println("#declare " + this.povrayDeclarationPrefix + "height = " + fmt.format(this.tree.getHeight()) + ";");
        this.writeStems();
        this.writeLeaves();
        this.w.flush();
    }

    private void writeLeaves() {
        this.leafMesh = this.meshGenerator.createLeafMesh(this.tree, false);
        int passes = 2;
        if (this.outputLeafNormals) {
            ++passes;
        }
        if (this.outputLeafUVs) {
            passes = passes++;
        }
        this.progress.beginPhase("Writing leaf mesh", this.tree.getLeafCount() * 2L);
        long leafCount = this.tree.getLeafCount();
        if (leafCount > 0L) {
            this.w.println("#declare " + this.povrayDeclarationPrefix + "leaves = mesh2 {");
            this.w.println("     vertex_vectors { " + (long)this.leafMesh.getShapeVertexCount() * leafCount);
            this.tree.traverseTree(new POVMeshLeafVertexWriter(this, this.leafMesh, this.leafVertexOffset));
            this.w.println("     }");
            if (this.outputLeafUVs && this.leafMesh.isFlat()) {
                this.w.println("     uv_vectors {  " + this.leafMesh.getShapeVertexCount());
                int i = 0;
                while (i < this.leafMesh.getShapeVertexCount()) {
                    this.writeUVVector(this.leafMesh.shapeUVAt(i));
                    if (i < this.leafMesh.getShapeVertexCount() - 1) {
                        this.w.print(",");
                    }
                    if (i % 6 == 2) {
                        this.w.println();
                        this.w.print("          ");
                    }
                    this.w.println();
                    ++i;
                }
                this.w.println("    }");
            }
            this.leafVertexOffset = 0L;
            this.w.println("     face_indices { " + (long)this.leafMesh.getShapeFaceCount() * leafCount);
            this.tree.traverseTree(new POVMeshLeafFaceWriter(this, this.leafMesh, this.leafVertexOffset));
            this.w.println("     }");
            if (this.outputLeafUVs && this.leafMesh.isFlat()) {
                this.w.println("     uv_indices { " + (long)this.leafMesh.getShapeFaceCount() * leafCount);
                this.tree.traverseTree(new POVMeshLeafUVFaceWriter(this, this.leafMesh, this.leafVertexOffset));
                this.w.println("     }");
            }
            this.w.println("}");
        } else {
            this.w.println("#declare " + this.povrayDeclarationPrefix + "leaves = sphere {<0,0,0>,0}");
        }
        this.progress.endPhase();
    }

    private void writeStems() {
        String indent = "  ";
        this.outputStemNormals = true;
        this.mesh = this.meshGenerator.createStemMesh(this.tree, this.progress);
        long vertex_cnt = this.mesh.vertexCount();
        long face_cnt = this.mesh.faceCount();
        long uv_cnt = this.mesh.uvCount();
        long elements = vertex_cnt + face_cnt;
        if (this.outputStemNormals) {
            elements += vertex_cnt;
        }
        if (this.outputStemUVs) {
            elements += face_cnt;
        }
        this.progress.beginPhase("Writing stem mesh", elements);
        this.w.println("#declare " + this.povrayDeclarationPrefix + "stems = ");
        this.w.println(String.valueOf(indent) + "mesh2 {");
        this.w.println(String.valueOf(indent) + "  vertex_vectors { " + vertex_cnt);
        this.writeStemPoints();
        this.w.println(String.valueOf(indent) + "  }");
        if (this.outputStemNormals) {
            this.w.println(String.valueOf(indent) + "  normal_vectors { " + vertex_cnt);
            this.writeStemNormals();
            this.w.println(String.valueOf(indent) + "  }");
        }
        if (this.outputStemUVs) {
            this.w.println(String.valueOf(indent) + "  uv_vectors {  " + uv_cnt);
            this.writeStemUVs();
            this.w.println();
            this.w.println(String.valueOf(indent) + "  }");
        }
        this.w.println(String.valueOf(indent) + "  face_indices { " + face_cnt);
        this.writeStemFaces(false);
        this.w.println();
        this.w.println(String.valueOf(indent) + "  }");
        if (this.outputStemUVs) {
            this.w.println(String.valueOf(indent) + "  uv_indices {  " + face_cnt);
            this.writeStemFaces(true);
            this.w.println();
            this.w.println(String.valueOf(indent) + "/* */  }");
        }
        this.w.println(String.valueOf(indent) + "}");
        this.progress.endPhase();
    }

    private void writeStemPoints() {
        int i = 0;
        Enumeration vertices = this.mesh.allVertices(false);
        while (vertices.hasMoreElements()) {
            Vertex vertex = (Vertex)vertices.nextElement();
            this.writeVector(vertex.point);
            if (vertices.hasMoreElements()) {
                this.w.print(",");
            }
            if (++i % 6 == 2) {
                this.w.println();
            }
            this.incProgressCount(100);
        }
        this.w.println();
    }

    public void writeStemFaces(boolean uv) throws MeshException {
        int j = 0;
        Enumeration faces = this.mesh.allFaces(0, uv, -1);
        while (faces.hasMoreElements()) {
            Face face = (Face)faces.nextElement();
            this.w.print("<" + face.points[0] + "," + face.points[1] + "," + face.points[2] + ">");
            if (faces.hasMoreElements()) {
                this.w.print(",");
            }
            if (j++ % 6 == 4) {
                this.w.println();
            }
            this.incProgressCount(100);
        }
    }

    private void writeStemNormals() {
        int i = 0;
        Enumeration parts = this.mesh.elements();
        while (parts.hasMoreElements()) {
            ((MeshPart)parts.nextElement()).setNormals(true);
        }
        Enumeration vertices = this.mesh.allVertices(false);
        while (vertices.hasMoreElements()) {
            Vertex vertex = (Vertex)vertices.nextElement();
            this.writeVector(vertex.normal);
            if (vertices.hasMoreElements()) {
                this.w.print(",");
            }
            if (++i % 6 == 2) {
                this.w.println();
            }
            this.incProgressCount(500);
        }
        this.w.println();
    }

    private void writeStemUVs() {
        int j = 0;
        Enumeration vertices = this.mesh.allVertices(true);
        while (vertices.hasMoreElements()) {
            UVVector vertex = (UVVector)vertices.nextElement();
            this.writeUVVector(vertex);
            if (vertices.hasMoreElements()) {
                this.w.print(",");
            }
            if (j++ % 6 != 2) continue;
            this.w.println();
        }
        this.w.println();
    }

    private void writeVector(Vector v) {
        this.w.print("<" + fmt.format(v.getX()) + "," + fmt.format(v.getZ()) + "," + fmt.format(v.getY()) + ">");
    }

    private void writeUVVector(UVVector uv) {
        this.w.print("<" + fmt.format(uv.u) + "," + fmt.format(uv.v) + ">");
    }
}

