/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.arbaro.export;

import java.text.NumberFormat;
import net.sourceforge.arbaro.export.AbstractExporter;
import net.sourceforge.arbaro.export.POVConeLeafWriter;
import net.sourceforge.arbaro.export.POVConeStemWriter;
import net.sourceforge.arbaro.params.FloatFormat;
import net.sourceforge.arbaro.tree.Tree;

class POVConeExporter
extends AbstractExporter {
    Tree tree;
    private String povrayDeclarationPrefix;

    public POVConeExporter(Tree tree) {
        this.tree = tree;
        this.povrayDeclarationPrefix = String.valueOf(tree.getSpecies()) + "_" + tree.getSeed() + "_";
    }

    public void doWrite() {
        NumberFormat frm = FloatFormat.getInstance();
        this.w.println("#declare " + this.povrayDeclarationPrefix + "height = " + frm.format(this.tree.getHeight()) + ";");
        if (this.tree.getLeafCount() != 0L) {
            this.writeLeafDeclaration();
        }
        this.progress.beginPhase("writing stem objects", this.tree.getStemCount());
        int level = 0;
        while (level < this.tree.getLevels()) {
            this.w.println("#declare " + this.povrayDeclarationPrefix + "stems_" + level + " = union {");
            POVConeStemWriter writer = new POVConeStemWriter(this, level);
            this.tree.traverseTree(writer);
            this.w.println("}");
            ++level;
        }
        if (this.tree.getLeafCount() != 0L) {
            this.progress.beginPhase("writing leaf objects", this.tree.getLeafCount());
            this.w.println("#declare " + this.povrayDeclarationPrefix + "leaves = union {");
            POVConeLeafWriter lexporter = new POVConeLeafWriter(this, this.tree);
            this.tree.traverseTree(lexporter);
            this.w.println("}");
        } else {
            this.w.println("#declare " + this.povrayDeclarationPrefix + "leaves = sphere {<0,0,0>,0}");
        }
        this.progress.endPhase();
        this.w.println("#declare " + this.povrayDeclarationPrefix + "stems = union {");
        level = 0;
        while (level < this.tree.getLevels()) {
            this.w.println("  object {" + this.povrayDeclarationPrefix + "stems_" + level + "}");
            ++level;
        }
        this.w.println("}");
        this.w.flush();
    }

    private void writeLeafDeclaration() {
        double length = this.tree.getLeafLength();
        double width = this.tree.getLeafWidth();
        this.w.println("#include \"arbaro.inc\"");
        this.w.println("#declare " + this.povrayDeclarationPrefix + "leaf = " + "object { Arb_leaf_" + (this.tree.getLeafShape().equals("0") ? "disc" : this.tree.getLeafShape()) + " translate " + (this.tree.getLeafStemLength() + 0.5) + "*y scale <" + width + "," + length + "," + width + "> }");
    }
}

