#!BPY

"""
Name: 'Select non manifold'
Blender: 234
Group: 'Object'
Tooltip: 'Select unusual non manifold'
"""

import Blender
from Blender.Draw import *
from Blender.BGL import *
from Blender import NMesh


def searchUNMF():

	listEdge = {}
	activeEdge = []

	num = 1
	
	obj = Blender.Object.GetSelected()[0]
	mesh = obj.getData()



	for f in mesh.faces:
		nedges = len(f)
		if nedges == 4:
			lista = [f.v[0].index , f.v[1].index, f.v[2].index]
			lista.sort()
			chiave =  str(lista)
			if listEdge.has_key(chiave):
				if listEdge[chiave] == num:
					activeEdge.append(f.v[0])
					activeEdge.append(f.v[1])
					activeEdge.append(f.v[2])
				listEdge[chiave] = listEdge[chiave] + 1
			else:
				listEdge[chiave] = 1

			lista = [f.v[1].index , f.v[2].index, f.v[3].index]
			lista.sort()
			chiave =  str(lista)
			if listEdge.has_key(chiave):
				if listEdge[chiave] == num:
					print "nonMnaifild 2"
					activeEdge.append(f.v[1])
					activeEdge.append(f.v[2])
					activeEdge.append(f.v[3])

				listEdge[chiave] = listEdge[chiave] + 1
			else:
				listEdge[chiave] = 1

			lista = [f.v[2].index , f.v[3].index, f.v[0].index]
			lista.sort()
			chiave =  str(lista)
			if listEdge.has_key(chiave):
				if listEdge[chiave] == num:
					activeEdge.append(f.v[2])
					activeEdge.append(f.v[3])
					activeEdge.append(f.v[0])

				listEdge[chiave] = listEdge[chiave] + 1
			else:
				listEdge[chiave] = 1

			lista = [f.v[3].index , f.v[0].index, f.v[1].index]
			lista.sort()
			chiave =  str(lista)
			if listEdge.has_key(chiave):
				if listEdge[chiave] == num:
					activeEdge.append(f.v[3])
					activeEdge.append(f.v[0])
					activeEdge.append(f.v[1])

				listEdge[chiave] = listEdge[chiave] + 1
			else:
				listEdge[chiave] = 1

	for v in activeEdge:
		v.sel = 1
		print v
		mesh.update()
	print "Found n: " , len(activeEdge)/2, " nonmanifold Edges" 
	Blender.Window.EditMode(1)


def draw():

	glColor3f(1.0,1.0,1.0)
	glRasterPos2i(15,55)
	Text("Copyright Paolo Colombo 2004")
	glRasterPos2i(15,40)
	Text("www.blender3d.it")

	Button("SELECT UNUSUAL NON MANIFOLD", 1, 10, 5, 180, 20,"Select Unusual non-manifold")
	Button("EXIT", 2, 190, 5, 80, 20)

def event(evt, val):	
	if (evt== QKEY and not val): Exit()

def bevent(evt):

	if (evt== 2): Exit()
	if (evt== 1): searchUNMF()

Register(draw, event, bevent)