#!BPY

""" Registration info for Blender menus
Name: 'Progressive Render'
Blender: 234
Group: 'Object'
Tip: 'Experimental Progressive Rendering Thingy'
"""

######################################################################
# Progressive Render v0.1 for Blender
#
# EXPERIMENTAL STUFF. USE AT YOUR OWN RISK AND SAVE YOUR WORK FIRST!
#
# When run, the script will thrigger four render passes, one after the
# other,in the 3D Window camera view, at increasing resolutions.
#
# First Pass: Here you can have a grasp of the lighting and specially
# the "color tinting" of the scene when using AO with full sky. Result
# is just a mess of pixels so is really fast.
#
# Second Pass: Things get a little clearer and you can check if shadows   
# are turning out right, and also you have a grasp of object placement
# in the framing, etc. This also completes quickly.
#
# Third Pass: This is a mid quality render, and pretty much what you get
# its a blurred version of the end result. Almost everything is visible
# with some detail, and you can choose now to go with the final pass or
# get back to blender to futher tweak you scene. :)
#
# Final Pass: This is a full quality render. The same thing you should get
# if you press F12.
#
#                              IMPORTANT
# DO NOT CANCEL THE FIRST AND SECOND PASSES. DOING SO WILL CRASH BLENDER!!!!
#
# I havent worked that out yet, but they are fast enough so just wait.
# You can cancel the third and final one thou, thats safe.
#
# Try it along with the border rendering option. You got yourself a nice
# elcheapo kind of IPR rendering :P
#   
# (c) 2005 Mariano Hidalgo a.k.a uselessdreamer
# released under Blender Artistic License
#
######################################################################

import Blender
from Blender import Scene,Draw

# Tweak here to suit your taste.
# The higher the faster of course.
firstPassPercent = 16
secondPassPercent = 8
thirdPassPercent = 2

#If you always render in 3D View change this to 0
backToWindowAfter = 1

scn=Scene.GetCurrent()
context = scn.getRenderingContext()
sizeX = context.imageSizeX()
sizeY = context.imageSizeY()
Scene.Render.EnableDispView()
context.enableCropping(1)


# First pass
context.imageSizeX(sizeX / firstPassPercent)
context.imageSizeY(sizeY / firstPassPercent)
context.render()

# Second pass
context.imageSizeX(sizeX / secondPassPercent)
context.imageSizeY(sizeY / secondPassPercent)
context.render()

# Third pass
context.imageSizeX(sizeX / thirdPassPercent)
context.imageSizeY(sizeY / thirdPassPercent)
context.render()

# Final pass
context.imageSizeX(sizeX)
context.imageSizeY(sizeY)
doFinal = Draw.PupMenu("Render full resolution?%t | YES | NO")
if doFinal == 1:
   context.render()
   Draw.PupMenu("Click to clear 3D View")
   
if backToWindowAfter == 1: Scene.Render.EnableDispWin()   
