# ##### BEGIN GPL LICENSE BLOCK #####
#
#  This program is free software; you can redistribute it and/or
#  modify it under the terms of the GNU General Public License
#  as published by the Free Software Foundation; either version 2
#  of the License, or (at your option) any later version.
#
#  This program is distributed in the hope that it will be useful,
#  but WITHOUT ANY WARRANTY; without even the implied warranty of
#  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#  GNU General Public License for more details.
#
#  You should have received a copy of the GNU General Public License
#  along with this program; if not, write to the Free Software Foundation,
#  Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
#
# ##### END GPL LICENSE BLOCK #####

bl_info = {
    "name": "Add Symmetrical Empty",
    "author": "Pablo Vazquez",			
    "version": (1,0,0),
    "blender": (2, 6, 4),
    "location": "View3D > Add > Mesh > Symmetrical Empty",
    "description": "Adds an Empty mesh with Mirror modifier",
    "warning": "",
    "wiki_url": "http://wiki.blender.org/index.php/Extensions:2.6/Py/"\
        "Scripts/Add_Mesh/Add_Symmetrical_Empty",
    "tracker_url": "",
    "category": "Add Mesh"}
'''
Adds an empty mesh with a mirror modifier.
'''    

import bpy

def Add_Symmetrical_Empty():

    bpy.ops.mesh.primitive_plane_add()

    sempty = bpy.context.object
    sempty.name = "Symmetrical Empty"

    bpy.context.active_object.location = [0, 0, 0]

    bpy.ops.object.modifier_add(type='MIRROR')

    mirror = sempty.modifiers['Mirror']
    mirror.use_clip = True  

    bpy.ops.object.editmode_toggle()

    # Delete all!
    bpy.ops.mesh.select_all(action='TOGGLE')
    bpy.ops.mesh.select_all(action='TOGGLE')
    bpy.ops.mesh.delete(type='VERT')

    # Going back to Object Mode doesn't make sense
    #bpy.ops.object.editmode_toggle()


class AddSymmetricalEmpty(bpy.types.Operator):
    
    bl_idname = "mesh.primitive_symmetrical_empty_add"
    bl_label = "Add Symmetrical Empty"
    bl_description = "Add an empty mesh with mirror modifier"
    bl_options = {'REGISTER', 'UNDO'}

    def execute(self, context):
        Add_Symmetrical_Empty()
        return {'FINISHED'}


#### REGISTER ###################################
def menu_func(self, context):
    self.layout.operator("mesh.primitive_symmetrical_empty_add",
        text="Symmetrical Empty", icon="EMPTY_DATA")

def register():
    bpy.utils.register_module(__name__)
    bpy.types.INFO_MT_mesh_add.prepend(menu_func)

def unregister():
    bpy.utils.unregister_module(__name__)
    bpy.types.INFO_MT_mesh_add.remove(menu_func)

if __name__ == "__main__":
    register()
