# This file is autogenerated. Instead of editing this file, please use the
# migrations feature of ActiveRecord to incrementally modify your database, and
# then regenerate this schema definition.

ActiveRecord::Schema.define(:version => 16) do

  create_table "categories", :force => true do |t|
    t.column "name", :string, :limit => 1024, :null => false
  end

  add_index "categories", ["name"], :name => "categories_name_key", :unique => true

  create_table "audio_categories", :force => true do |t|
    t.column "audio_id",    :integer
    t.column "category_id", :integer
  end

  create_table "audios", :force => true do |t|
    t.column "directory",  :string,   :limit => 1024,                   :null => false
    t.column "filename",   :string,   :limit => 256,                    :null => false
    t.column "stream",     :integer
    t.column "image_id",   :integer
    t.column "creator",    :string,   :limit => 20
    t.column "created_at", :datetime,                                   :null => false
    t.column "updated_at", :datetime,                                   :null => false
    t.column "disk_space", :integer,                  :default => 0
    t.column "date",       :datetime,                                   :null => false
    t.column "shot_id",    :integer
    t.column "codec",      :string,   :limit => 30,                     :null => false
    t.column "fourcc",     :string,   :limit => 30,                     :null => false
    t.column "channels",   :integer,                  :default => 1,    :null => false
    t.column "frequency",  :integer,                                    :null => false
    t.column "bitrate",    :integer
    t.column "start",      :float,                                      :null => false
    t.column "duration",   :float,                                      :null => false
    t.column "online",     :boolean,                  :default => true
    t.column "backup",     :string,   :limit => 10
  end

  add_index "audios", ["directory", "filename", "stream"], :name => "audios_idx", :unique => true


  create_table "icc_profiles", :force => true do |t|
    t.column "name",     :string, :limit => 256
    t.column "filename", :string, :limit => 1024
  end

  add_index "icc_profiles", ["filename"], :name => "icc_profiles_filename_key", :unique => true
  add_index "icc_profiles", ["name"], :name => "icc_profiles_name_key", :unique => true

  create_table "image_categories", :force => true do |t|
    t.column "image_id",    :integer
    t.column "category_id", :integer
  end

  create_table "images", :force => true do |t|
    t.column "directory",             :string,   :limit => 1024,                      :null => false
    t.column "filename",              :string,   :limit => 256,                       :null => false
    t.column "shot_id",               :integer
    t.column "frame_start",           :integer
    t.column "frame_end",             :integer
    t.column "creator",               :string,   :limit => 20
    t.column "created_at",            :datetime,                                      :null => false
    t.column "updated_at",            :datetime,                                      :null => false
    t.column "width",                 :integer,                                       :null => false
    t.column "height",                :integer,                                       :null => false
    t.column "pixel_ratio",           :float,                    :default => 1.0,     :null => false
    t.column "date",                  :datetime,                                      :null => false
    t.column "format",                :string,   :limit => 30
    t.column "fps",                   :float,                    :default => 24.0
    t.column "codec",                 :string,   :limit => 10
    t.column "disk_space",            :integer,                  :default => 1048576, :null => false
    t.column "icc_profile_id",        :integer
    t.column "render_transform_id",   :integer
    t.column "look_mod_transform_id", :integer
    t.column "depth",                 :integer,                  :default => 32,      :null => false
    t.column "pixel_format_id",       :integer
    t.column "num_channels",          :integer,                  :default => 4,       :null => false
    t.column "layers",                :string,   :limit => 1024,                      :null => false
    t.column "fstop",                 :float,                    :default => 8.0
    t.column "gamma",                 :float,                    :default => 1.0
    t.column "online",                :boolean,                  :default => true,    :null => false
    t.column "rating",                :integer
    t.column "backup",                :string,   :limit => 10
    t.column "label_color",           :string,   :limit => 6
    t.column "description",           :string,   :limit => 1024
    t.column "thumbnail_width",       :integer,                  :default => 0,       :null => false
    t.column "thumbnail_height",      :integer,                  :default => 0,       :null => false
    t.column "thumbnail",             :binary
  end

  add_index "images", ["directory", "filename"], :name => "images_idx", :unique => true

  create_table "look_mod_transforms", :force => true do |t|
    t.column "name", :string, :limit => 256, :null => false
  end

  add_index "look_mod_transforms", ["name"], :name => "look_mod_transforms_idx", :unique => true

  create_table "pixel_formats", :force => true do |t|
    t.column "name", :string, :limit => 256, :null => false
  end

  add_index "pixel_formats", ["name"], :name => "pixel_formats_idx", :unique => true

  create_table "render_transforms", :force => true do |t|
    t.column "name", :string, :limit => 256, :null => false
  end

  add_index "render_transforms", ["name"], :name => "render_transforms_idx", :unique => true

  create_table "sequences", :force => true do |t|
    t.column "name",        :string,  :limit => 4
    t.column "show_id",     :integer,              :null => false
    t.column "description", :text
  end

  add_index "sequences", ["name", "show_id"], :name => "sequences_show_id_key", :unique => true

  create_table "shots", :force => true do |t|
    t.column "name",        :string,  :limit => 8
    t.column "sequence_id", :integer,              :null => false
  end

  add_index "shots", ["name", "sequence_id"], :name => "shots_sequence_id_key", :unique => true

  create_table "shows", :force => true do |t|
    t.column "name",            :string, :limit => 8,   :null => false
    t.column "title",           :string, :limit => 120
    t.column "director",        :string, :limit => 120
    t.column "production_date", :date
    t.column "delivery_date",   :date
    t.column "studio",          :string, :limit => 120
    t.column "distributor",     :string, :limit => 120
  end

  add_index "shows", ["name"], :name => "shows_name_key", :unique => true

  create_table "users", :force => true do |t|
    t.column "login",                     :string
    t.column "email",                     :string
    t.column "crypted_password",          :string,   :limit => 40
    t.column "salt",                      :string,   :limit => 40
    t.column "created_at",                :datetime, :null => false
    t.column "updated_at",                :datetime, :null => false
    t.column "remember_token",            :string
    t.column "remember_token_expires_at", :datetime
  end

  create_table "video_categories", :force => true do |t|
    t.column "video_id",    :integer
    t.column "category_id", :integer
  end

  create_table "videos", :force => true do |t|
    t.column "image_id",     :integer,                :null => false
    t.column "stream",       :integer,                :null => false
    t.column "created_at",   :datetime,               :null => false
    t.column "updated_at",   :datetime,               :null => false
    t.column "codec",        :string,   :limit => 30
    t.column "fourcc",       :string,   :limit => 30
    t.column "pixel_format_id", :integer,   :limit => 30
    t.column "fps",          :float,                  :null => false
    t.column "start",        :float,                  :null => false
    t.column "duration",     :float,                  :null => false
  end

  add_index "videos", ["image_id", "stream"], :name => "videos_idx", :unique => true

end
