"""
Subjected under license GPL: http://www.gnu.org/licenses/gpl.txt
Author: Jordi Rubio
Email: sharek@catarsys.com
Web: http://catarsys.com/
----------------------------------------------------------------------------------
Position where it wishes the flowerpot and the sun and presses ALT+P
The parameters are "resolucion","secciones","enfarfullamiento","grosor_hiedra" and "raices"
This is an unfinished program, please be patient
"""
import Blender
from Blender import *
import math
from math import *

resolucion=3
secciones=10
enfarfullamiento = 1
grosor_hiedra = 1.0
grosor_hoja = 0.5
raices = 0

def segmento(objeto,xr,yr,zr,tamanyo):
    for i in range(0,resolucion):
        pi =3.1416 *  2 * i / resolucion
        x =  ( tamanyo * cos(pi) ) + xr
        y =  ( tamanyo * sin(pi) ) + yr
        z = 0 + zr
        vertice = NMesh.Vert(x,y,z)
        objeto.verts.append(vertice)

def construyecaras(objeto):
    pos = 0
    while pos < ( len(objeto.verts) - resolucion):
        for i in range(pos,(pos+resolucion -1 )):
            cara = NMesh.Face()
            cara.v.append(objeto.verts[i])
            cara.v.append(objeto.verts[i+1])
            cara.v.append(objeto.verts[i+resolucion+1])
            cara.v.append(objeto.verts[i+resolucion])
            cara.smooth = 1
            objeto.faces.append(cara)
        # la ultima cara con la primera
        pos = pos + resolucion
        cara = NMesh.Face()
        cara.v.append(objeto.verts[pos-1])
        cara.v.append(objeto.verts[pos-resolucion])
        cara.v.append(objeto.verts[pos])
        cara.v.append(objeto.verts[pos+resolucion-1])
        cara.smooth = 1
        objeto.faces.append(cara)
        

def rama(planta,origen,objetivo,grosor_hiedra,hijas):
    print "Dibujando una rama..."
    diff_x = objetivo[0] - origen[0]
    diff_y = objetivo[1] - origen[1]
    diff_z = objetivo[2] - origen[2]
    posz = 0
    posx = 0
    posy = 0
    segmento(planta,0.0,0.0,0.0,grosor_hiedra)
    lio = 0
    decremento = grosor_hiedra/secciones
    for basura in range(0,secciones):
        posz = posz + (diff_z / secciones)
        posx = posx + (diff_x / secciones)
        posy = posy + (diff_y / secciones)
        lio=lio+1
        if ( lio > enfarfullamiento ):
            lio=0
            ruidox = ( Blender.Noise.random()*5 ) -2.5
            ruidoy = ( Blender.Noise.random()*5 ) -2.5
            ruidoz = ( Blender.Noise.random()*5 ) -2.5
        else:
            ruidox = 0
            ruidoy = 0
            ruidoz = 0
        grosor_hiedra = grosor_hiedra - decremento 
        segmento(planta,posx +ruidox,posy+ruidoy,posz+ruidoz,grosor_hiedra)
        if ( hijas != 0 ):
            ruidox2 = ( Blender.Noise.random()*10 ) -5
            ruidoy2 = ( Blender.Noise.random()*10 ) -5
            ruidoz2 = ( Blender.Noise.random()*10 ) -5
            rama(planta,[posx +ruidox + origen[0],posy+ruidoy + origen[1],posz+ruidoz + origen[2]],[objetivo[0] + ruidox2,objetivo[1] + ruidoy2,objetivo[2] + ruidoz2],grosor_hiedra,0)
    construyecaras(planta)

def grados_a_radianes(grados):
    return grados * 3.1416 / 180

def crea_hojas(objeto,resolucion,coords):
    print "creando hojas..."
    hojas = NMesh.New()
    # creamos el material de la hoja
    material_hoja = Material.New('hoja')
    material_hoja.rgbCol = [0.0, 1.0, 0.0]
    material_hoja.setName('hoja')
    material_hoja.setRef(1.0)
    material_hoja.setSpec(0.5)
    material_hoja.setHardness(150)
    # le enchufamos el material en vena a la malla
    hojas.setMaterials([material_hoja])
    contador = 0
    # obtenemos los datos de la hoja madre y la duplicamos por la malla
    objeto_hoja_primigenia = Object.Get("hoja_madre")
    malla_hoja_primigenia = NMesh.GetRawFromObject(objeto_hoja_primigenia.name)
    for vertice in objeto.verts:
        contador=contador+1
        if ( contador > resolucion ):
            contador = 0
            for f in malla_hoja_primigenia.faces:
                lista_vertices = []
                for vertices_caras_hojas in f.v:
                    vert_hoja = NMesh.Vert(vertices_caras_hojas.co[0] +vertice.co[0] ,vertices_caras_hojas.co[1] +vertice.co[1],vertices_caras_hojas.co[2] +vertice.co[2])
                    hojas.verts.append(vert_hoja)
                    lista_vertices.append(vert_hoja)
                face_hoja = NMesh.Face(lista_vertices)
                face_hoja.smooth = 1
                hojas.faces.append(face_hoja)
                #hojas.rot(grados_a_radianes(20))

    # Pulimos las hojas
    hojas.setMode("SubSurf","Optimal")
    hojas.setSubDivLevels([3,3])
    hojas_obj = NMesh.PutRaw(hojas)
    hojas_obj.setName("hojas")
    #hojas_obj.setLocation(coords)

print "empecemos!"
objetivo = Object.Get("sol")
coordenadas_objetivo = objetivo.getLocation()
origen = Object.Get("maceta")
coordenadas_origen = origen.getLocation()

# creamos la planta
planta = NMesh.New()
# creamos el material de la hiedra
material_hiedra = Material.New('hiedra')
material_hiedra.rgbCol = [0.7, 0.6, 0.4]
material_hiedra.setName('hiedra')
material_hiedra.setRef(1.0)
material_hiedra.setSpec(0.5)
material_hiedra.setHardness(150)
# le enchufamos el material en vena a la malla
planta.setMaterials([material_hiedra])
# creamos la rama principal (el tronco)
rama(planta,coordenadas_origen,coordenadas_objetivo,grosor_hiedra,raices)
# Pulimos la hiedra
planta.setMode("SubSurf","Optimal")
planta.setSubDivLevels([3,3])
# mandamos a blender todo el curro
planta_obj = NMesh.PutRaw(planta)
planta_obj.setName("planta")

planta_obj.setLocation(coordenadas_origen[0],coordenadas_origen[1],coordenadas_origen[2])

# pegamos la planta a la maceta (no es util para nada, pero me estaba aburriendo...)
planta_obj = Object.Get("planta")
origen.makeParent([planta_obj],0,0)
#creamos las hojas
crea_hojas(NMesh.GetRawFromObject("planta"),resolucion*30,coordenadas_origen)

# pegamos las hojas a la planta
hoja_obj = Object.Get("hojas")
planta_obj.makeParent([hoja_obj],0,0)

Blender.Redraw()
print "fin!"
