////////////////////////////////////////////////////////////////////////////////////////////////////
//                                         E S E N T H E L                                        //
////////////////////////////////////////////////////////////////////////////////////////////////////


/******************************************************************************/
#include "stdafx.h"   // include precompiled header
#include "resource.h" // include resources (icon)
/******************************************************************************/

// Mallas
Mesh meshMalla1, meshMalla2, meshPlayer, meshDj, meshBiplano, meshDe;

// Matrix utilizados para manipular las mallas del mapa
Matrix matrixMalla1, matrixMalla2, temp;

// Pila disparos del jugador
Flt djTiempo(0);	// Crear un margen de tiempo entre cada disparo del jugador
I8 djPos(0);		// Posicion en la estructura matriz de disparos del jugador (jg)

// Pila biplano
I8 biplanoPos(0);	// Posicion en la estructura matriz del enemigo biplano

// Eventos
I8 djActivos(0), deActivos(0), biplanosActivos(0), eventoPos(0);	// Activos. Suma de elementos activos de cada tipo.
Flt Tiempo;   // Tiempo transcurrido. Utilizado para activar las acciones del juego
I16 Evento[7]={3,15,30,45,70,85,100};  // Matriz de margenes de tiempo entre cada accion del juego

// Explosion
Gfx        *main     , // Textura principal de la explosion
           *single   ; // Textura individual para la explosion
ExplosionFx explosion; // Efecto de explosion de particula



// Estructuras: DECLARACION
// ++++++++++++++++++++++++

struct Ejuego0 {  // Disparos del jugador

	Bool Inactivo;	// Variable booleana que indica si se esta ejecutando.

	Matrix matrix;	// Matrix (no es una matriz) para manipular la malla

	void Ejuego0::crear();			// Funcion constructora
	void Ejuego0::activar();		// Funcion que activa la estructura
	void Ejuego0::actualizar();		// Funcion que actualiza los parametros de la estructura
	void Ejuego0::dibujar();		// Funcion para dibujar en pantalla la malla

} dj[15];	// Creamos una copia matriz (con un indice) llamada dj (disparos jugador)


struct Ejuego1 {  // Jugador

	Bool loop;		// Variable booleana que indica si se esta llevando a cabo un 'loop' (Boton derecho del raton)

	I16 Vida;		// Variable tipo entero que guarda la vida del jugador
	
	Flt loopContador, altura;  // loopContador es utilizada para crear el 'loop' que modifica la 'altura' (eje y) de la malla

	Matrix matrix;  // matrix para manipular la malla

	void Ejuego1::crear();			// Funcion constructora
	void Ejuego1::actualizar();		// Funcion que actualiza los parametros de la estructura
	void Ejuego1::dibujar();		// Funcion que dibuja en pantalla la malla

} player;		// Creamos una unica copia llamada player (jugador)



struct Ejuego2 {  // Enemigo biplano

	Bool Activo;		// Variable booleana que indica si esta activa, es decir si esta en proceso de ejecucion.

	Flt IncX, IncY, localTiempo, Transcurso;  // Incrementos (IncX IncY) son las variaciones de posicion necesarias para obtener la siguiente posicion (Seguir una ruta o 'path')

	Vec2 pos[2];	// Vec2 es un tipo de dato del motor de juego que agrupa dos valores tipo float (x,y). Utilizado para crear la ruta o 'path'.
	//I8 Indice;	Se podria declarar una variable que guardara el indice de Vec2, si utilizamos mas de dos posiciones. En este caso, no es necesario ya que solo utilizo dos posiciones Vec2, la pos[0] que sera el punto inicial o de salida, y pos[1] que sera el punto de destino.
	I16 Vida;		// Variable tipo entero que guarda la vida del enemigo biplano.

	Matrix matrix;		// matrix para manipular la malla

	void Ejuego2::crear();
	void Ejuego2::activar();
	void Ejuego2::actualizar();
	void Ejuego2::dibujar();

} biplano[5];


 struct Ejuego3 {  // disparos enemigo

	Bool Inactivo;		// Variable booleana que indica si se esta ejecutando.

	Flt IncX, IncY;		// Incrementos (IncX IncY) necesarios para que el dispara alcance la posicion del jugador (player)

	Vec2 Pos;		// Guarda la posicion (x,y) del disparo. Solo modifico el valor de x(izquierda-derecha) , z(delante-detras) al estar situada la camara desde una vista superior. Por este motivo guardo la posicion en un Vec2(x,y) en lugar de una Vec(x,y,z)

	Matrix matrix;		// matrix para manipular la malla

	void Ejuego3::crear();
	void Ejuego3::activar(Flt x, Flt y);
	void Ejuego3::actualizar();
	void Ejuego3::dibujar();

} de[15];  // Creamos una copia matriz de la estructura llamada de (disparos enemigo)




// Funciones Generales
// +++++++++++++++++++

Flt Distancia(Vec pos1,Vec pos2) {		// Funcion que calcula la posicion entre las mallas. Utilizada para detectar colisiones.

return Sqrt(Sqr(pos1.x-pos2.x)+Sqr(pos1.y-pos2.y)+Sqr(pos1.z-pos2.z));

}


 void Disparar (Flt x, Flt y) {			// Funcion general que utilizarian todos los tipos de enemigo para disparar al jugador (player). Por ahora, solo he creado un tipo de enemigo.

	 static I8 Pos=0;		// La variable es tipo 'static' para conservar el valor de Pos cada vez que se llama a la funcion. Si no fuera 'static' se reiniciaria a 0 cada vez que se llama la funcion.

	 de[Pos].activar(x,y);		//  Activamos un elementos de la matriz estructura 'de' (disparo enemigo)

	 Pos++;		// Incrementamos el valor del indice de la matriz.

	 if (Pos==15) Pos=0;  // Reiniciamos a 0 si ha llegado al ultimo elemento de la matriz
 }


 void Explosion (Vec pos) {		// Funcion general que utilizarian todos los elementos del juego para recrear una explosion.

	 explosion.create(main,single,0x00600000,32,pos,0.2f); // Crear efecto explosion
	 QuakeFx.addShort();   // Aadir pequeo temblor

 }	




// Estructuras: CONSTRUCCION
// +++++++++++++++++++++++++


// Estructura Ejuego0 (disparos jugador o player)

void Ejuego0::crear() {

	Inactivo=true;

	matrix.setScale(1);

}


void Ejuego0::activar() {

	Inactivo=false;

	++djActivos;

	matrix.setPos(Vec(player.matrix.pos.x,1.5f,player.matrix.pos.z+0.1f));

}

void Ejuego0::actualizar() {

	if (Inactivo) return;

	matrix.move(Vec(0,0,0.05));

	if (matrix.pos.z>(Cam.matrix.pos.z+1)) {Inactivo=true; --djActivos;}

}

void Ejuego0::dibujar() {

		if (Inactivo) return;

		meshDj.draw(matrix);

}




// Estructura Ejuego1 (player)


void Ejuego1::crear() {

		loop=true;

		Vida=100;

		loopContador=1; altura=1.5f;

		matrix.setScale(1)
			  .move(Vec(0,altura,0));

}

void Ejuego1::actualizar() {

		if (loop==false) {

			altura+=(65-loopContador)/(Sqr(65-loopContador)+(10*loopContador)); loopContador++;
			if (altura<1.5f) {altura=1.5f; loopContador=1; loop=true;}

		}

		matrix.setPos(Vec(Ms.pos.x+Cam.matrix.pos.x,altura,Ms.pos.y+Cam.matrix.pos.z));

		if ((deActivos>0) && (loop)) {
			REPA (dj) if ((de[i].Inactivo==false)) {
				if (Distancia(matrix.pos,de[i].matrix.pos)<0.1f) {Vida-=20; de[i].Inactivo=true; --deActivos;}
			}
		}

		if (Vida<0) {Explosion(matrix.pos); Vida=100;}
}

void Ejuego1::dibujar() {
	
	meshPlayer.draw(matrix);

}


// Estructura Ejuego2 (Enemigo biplano)

void Ejuego2::crear() {

	Activo=false;

	Vida=0;

	IncX=0; IncY=0; localTiempo=0; Transcurso=0;

	pos[0].set(0);
	pos[1].set(0);

	matrix.setScale(1);

}

void Ejuego2::activar() {

	++biplanosActivos;

	Activo=true;

	Vida=100;

	localTiempo=Transcurso=Tm.time();

	pos[0].set(0,1);
	pos[1].set(Random(-1,1),0.3f);

	matrix.setPos(Vec(Cam.matrix.pos.x+pos[0].x,1.5f,Cam.matrix.pos.z+pos[0].y));

	IncX=(pos[1].x-pos[0].x)*Tm.d();
	IncY=(pos[1].y-pos[0].y)*Tm.d();
}

void Ejuego2::actualizar() {

	if (Activo==false) return;

	if ((Tm.time()-Transcurso)>15) {IncY=-0.02f; pos[1].set(pos[1].x,-3);}


	pos[0].x+=IncX; pos[0].y+=IncY;

	matrix.setPos(Vec(Cam.matrix.pos.x+pos[0].x,1.5f,Cam.matrix.pos.z+pos[0].y));

	if ((Tm.time()-localTiempo)>3) {Disparar(matrix.pos.x,matrix.pos.z); localTiempo=Tm.time();}
	if (matrix.pos.z<(Cam.matrix.pos.z-1)) {Activo=false; --biplanosActivos; return;}
	if ((matrix.pos.x>(Cam.matrix.pos.x+pos[1].x)) && (IncX>0)) {IncX=0;}
	if ((matrix.pos.x<(Cam.matrix.pos.x+pos[1].x)) && (IncX<0)) {IncX=0;}
	if ((matrix.pos.z<(Cam.matrix.pos.z+pos[1].y)) && (IncY<0)) {IncY=0;}

	if (djActivos>0) {
		REPA (dj) if ((dj[i].Inactivo==false)) {
			if (Distancia(matrix.pos,dj[i].matrix.pos)<0.1f) {Vida-=20; dj[i].Inactivo=true; --djActivos;}
		}
	}

	if ((Vida<0) || (Distancia(matrix.pos,player.matrix.pos)<0.2f)) {Explosion(matrix.pos); Activo=false; --biplanosActivos;}

}

void Ejuego2::dibujar() {

	if (Activo==false) return;

	meshBiplano.draw(matrix);

}


// Estructura Disparos Enemigo

void Ejuego3::crear() {

	Inactivo=true;

	IncX=0; IncY=0;

	Pos.set(0);

	matrix.setScale(1);

}


void Ejuego3::activar(Flt x, Flt y) {

	++deActivos;

	Inactivo=false;

	IncX=(player.matrix.pos.x-x)*Tm.d();
	IncY=(player.matrix.pos.z-y)*Tm.d();

	Pos.set(x-Cam.matrix.pos.x+IncX*3,y-Cam.matrix.pos.z+IncY*3);

	matrix.setPos(Vec(Cam.matrix.pos.x+Pos.x,1.5f,Cam.matrix.pos.z+Pos.y));

}

void Ejuego3::actualizar() {

	if (Inactivo) return;

	Pos.set(Pos.x+IncX,Pos.y+IncY);

	if ((Pos.x<-2) || (Pos.x>2) || (Pos.y<-1) || (Pos.y>1)) {Inactivo=true; --deActivos;return;}

	matrix.setPos(Vec(Cam.matrix.pos.x+Pos.x,1.5f,Cam.matrix.pos.z+Pos.y));

}

void Ejuego3::dibujar() {

	if (Inactivo) return;

	meshDe.draw(matrix);

}




////////////////////////////////////////////////////////////////////////////////////////////////////
//                                         E S E N T H E L                                        //
////////////////////////////////////////////////////////////////////////////////////////////////////





void InitPre() // init before engine inits
{
   // here you will have to setup initial engine settings
   // like application name, its options, screen resolution...

   App.name("Demo");            // application name
   App.icon=(Char*)IDI_ICON1;    // setup icon
   IOPath("../data/");
   PakAdd("../data/engine.pak"); // load engine data

   App.flag=APP_MS_EXCLUSIVE;  // setup mouse exclusive mode to hide cursor


   D.full(true).ambPower(1).hpRt(true).hwDepthBuffer(true).bumpMode(BUMP_PARALLAX).mtnMode(MTN_HIGH);

}
/******************************************************************************/
Bool Init() // init after engine inits
{
   // here when engine will be ready you can load your game data
   // return false when error occured


	// Cargar Mallas
	meshMalla1.load("LocalData/Obj/terreno/terreno.mesh");
	matrixMalla1.setScale(Vec(2.42f,1.5f,2.2f))
				.move(Vec(0.02f,-3.05f,-1.486f));
	meshMalla2.load("LocalData/Obj/terreno/terreno.mesh");
	meshMalla2.mirrorZ()
		      .setRender();
	matrixMalla2.setScale(Vec(2.42f,1.5f,2.2f))
				.move(Vec(0.02f,-3.05f,7.31f));
	meshPlayer.load("LocalData/Obj/mustang/mustang.mesh");
	meshDj.load("LocalData/Obj/disparo.mesh");
	meshBiplano.load("LocalData/Obj/biplano/biplano.mesh");
	meshDe.load("LocalData/Obj/edisparo.mesh");

	//Cargar imagenes para la Explosion
	main  =Gfxs("gfx/particle/explosion/0.gfx");
	single=Gfxs("gfx/particle/explosion/1.gfx");

	//Configurar Agua
	Water.set(*Gfxs("gfx/water/0.gfx"),*Gfxs("gfx/water/0.n.gfx"),Gfxs("gfx/fx/reflection.gfx"));
	Water.plane(Water.plane()+ Vec(0,-3.2f,0));
	Water.wave_scale=1;
	Water.reflect=1;
	Water.reflect_fake=1;


	// Configurar Sol
	Sun &sun=Suns.New();
	sun.set(*Gfxs("gfx/sky/sun.gfx")); // set image
    sun.pos=!Vec(1,1,1);               // set custom position


	// Establecer Cielo
	Sky.set();


	// Configurar Camara
	Cam.pitch=-1.57f; /* Inclinacion 90 grados */  Cam.matrix.setPos(Vec(0,3,0)); /*Elevacion, eje y */
	Cam.setAngle(Cam.matrix.pos,Cam.yaw,Cam.pitch,Cam.roll).set();  // Establecer (set) los cambios realizados en la camara


	//Construccion de las estructuras
	player.crear();
	REPA (dj) dj[i].crear();  // REPA (Repeat All-Repetir Todo) es una palabra reservada del motor de juego que genera un bucle que se repite tantas veces como el numero de elementos que forman el tipo que se encuentra entre parentesis, en este caso dj.
	REPA (biplano) biplano[i].crear();
	REPA (de) de[i].crear();

   return true;
}
/******************************************************************************/
void Shut() // shut at exit
{
   // this is called when the engine is about to exit
}
/******************************************************************************/
Bool Main() // main updating
{
   // here you have to process each frame update

	if(Kb.bp(KB_ESC))return false; // exit if escape on the keyboard pressed


	// Actualizar movimiento agua
	Water.update(Vec2(0.02f,0.02f));  // El vector Vec2 regula la velocidad del movimiento del agua.

	// Mover Camara
	Cam.matrix.move(Vec(0,0,0.01f));  // Movemos la camara a traves del eje z con un valor positivo (hacia delante)
	Cam.setAngle(Cam.matrix.pos,Cam.yaw,Cam.pitch).updateVelocities().set();  // Siempre debemos establecer (set) los cambios despues de una modificacion en la camara.

	// Actualizar posicion mallas del mapa. El mapa esta formado por dos mallas que se repiten y cambian su posicion en el transcurso del juego.
	if ((Cam.matrix.pos.z-matrixMalla1.pos.z)>12) {matrixMalla1.move(Vec(0,0,17.59f));}
	if ((Cam.matrix.pos.z-matrixMalla2.pos.z)>12) {matrixMalla2.move(Vec(0,0,17.59f));}

	// Actualizar jugador (player)
	player.actualizar();


	// Actualizar botones del raton. Boton izquierdo del raton (0) para disparar. Boton derecho (1) para realizar el loop. Durante el loop no te afectan los disparos del enemigo.
	if ((Ms.b(0)) && (player.loop) && ((Tm.time()-djTiempo)>0.15f)) {dj[djPos].activar(); djTiempo=Tm.time(); ++djPos;}		// Utilizamos djTiempo para crear un margen de tiempo entre cada disparo.
	if (djPos==15) {djPos=0;}  // Reiniciamos a 0 si hemos llegado al ultimo elemento de la matriz
	if (Ms.b(1)) player.loop=false;  // Llevar a cabo el loop. Modificamos a false el valor de la variable loop que se encuentra en la estructura player.


	// Actualizar eventos
	if ((Tm.time()-Tiempo)>Evento[eventoPos]) {biplano[biplanoPos].activar(); ++eventoPos; ++biplanoPos;}  // Aadimos elementos al juego con esta sentencia, comparando el tiempo transcurrido con los valores de la matriz Evento.
	if (eventoPos==7) {eventoPos=0; Tiempo=Tm.time();} // Reiniciamos a 0 el valor del indice de la matriz Evento (eventosPos) y Tiempo.
	if (biplanoPos==5) {biplanoPos=0;} // Reiniciamos a 0 si hemos llegado al ultimo elemento de la estructura matriz biplano.


	// Actualizar Elementos del Juego
	if (djActivos>0) REPA (dj) dj[i].actualizar();		// Si se encuentra algun elemento dj (disparo jugador) activo, entonces actualizamos los elementos dj.
	if (biplanosActivos>0) REPA (biplano) biplano[i].actualizar();	// Si se encuentra algun elemento biplano (enemigo biplano) activo, entonces actualizamos los elementos biplano.
	if (deActivos>0) REPA (de) de[i].actualizar();	// Si se encuentra algun elemento de (disparo enemigo) activo, entonces actualizamos los elementos de.

	// Actualizar Explosion
	explosion.update();

	// update Quake Effect
	QuakeFx.update();




	return true;                   // continue
}
/******************************************************************************/
void Render()
{
   switch(Renderer()) {

		case RM_SOLID : case RM_SOLID_M :  {////////////////              DIBUJAR MALLAS DEL JUEGO              /////////////////
											// Mallas del mapa
											meshMalla1.draw(matrixMalla1);
											meshMalla2.draw(matrixMalla2);
											if (matrixMalla2.pos.z>matrixMalla1.pos.z) {temp=matrixMalla1; temp.move(Vec(0,0,17.59f)); meshMalla1.draw(temp);}
												   else {temp=matrixMalla2; temp.move(Vec(0,0,17.59f)); meshMalla2.draw(temp);}
										    // Malla del jugador (player)
											player.dibujar();
											// Otros elementos del juego
											if (djActivos>0) REPA (dj) dj[i].dibujar();
											if (biplanosActivos>0) REPA (biplano) biplano[i].dibujar();
											if (deActivos>0) REPA (de) de[i].dibujar();
											break;
											}
   
		case RM_PALETTE:	{////////////////              DIBUJAR EXPLOSION               ////////////////
							explosion.draw(); // draw Explosion Effect in Color Palette mode
							break;
							}
   }
}


void Draw() // main drawing
{
	// here you have to tell engine what to draw on the screen

	Renderer(Render);


	// PUNTO DE CONTROL. Supervisar el valor de algunas variables del juego.
	D.text(0,-0.8,S+"djA: "+djActivos+"  deA: "+deActivos+"  VidaP: "+player.Vida+"  bActivos: "+biplanosActivos);
	REPA (biplano) D.text(-0.9+0.45*i,-0.9,S+biplano[i].Vida);


}
/******************************************************************************/