////////////////////////////////////////////////////////////////////////////////////////////////////
//                                         E S E N T H E L                                        //
////////////////////////////////////////////////////////////////////////////////////////////////////


/******************************************************************************/
#include "stdafx.h"   // include precompiled header
#include "resource.h" // include resources (icon)
/******************************************************************************/

// Meshes
Mesh meshMalla1, meshMalla2, meshPlayer, meshDj, meshBiplano, meshDe;

// Map Matrix
Matrix matrixMalla1, matrixMalla2, temp;

// Fire player variables (Time and position array)
Flt djTiempo(0);
I8 djPos(0);

// Position biplane array
I8 biplanoPos(0);

// Events Variables (Active events, Time, position event array)
I8 djActivos(0), deActivos(0), biplanosActivos(0), eventoPos(0);
Flt Tiempo;
I16 Evento[7]={3,15,30,45,70,85,100};  // seconds array

// Explosion Variables
Gfx        *main     , // main   explosion texture
           *single   ; // single explosion texture
ExplosionFx explosion; // explosion particle effect



// Structures: DECLARATION
// ++++++++++++++++++++++++

struct Ejuego0 {  // (Ejuego - Elemento del juego) Game Element zero. FIRE PLAYER

	Bool Inactivo;

	Matrix matrix;

	void Ejuego0::crear();			// Constructor function
	void Ejuego0::activar();		// Active function
	void Ejuego0::actualizar();		// Update function
	void Ejuego0::dibujar();		// Draw function

} dj[15];


struct Ejuego1 {  // PLAYER

	Bool loop;

	I16 Vida;
	
	Flt loopContador, altura;

	Matrix matrix;

	void Ejuego1::crear();
	void Ejuego1::actualizar();
	void Ejuego1::dibujar();

} player;



struct Ejuego2 {  // BIPLANE ENEMY

	Bool Activo;

	Flt IncX, IncY, localTiempo, Transcurso;

	Vec2 pos[2];
	I8 Indice;
	I16 Vida;

	Matrix matrix;

	void Ejuego2::crear();
	void Ejuego2::activar();
	void Ejuego2::actualizar();
	void Ejuego2::dibujar();

} biplano[5];


 struct Ejuego3 {  // FIRE ENEMY

	Bool Inactivo;

	Flt IncX, IncY;

	Vec2 Pos;

	Matrix matrix;

	void Ejuego3::crear();
	void Ejuego3::activar(Flt x, Flt y);
	void Ejuego3::actualizar();
	void Ejuego3::dibujar();

} de[15];




// Funciones Generales
// +++++++++++++++++++

Flt Distancia(Vec pos1,Vec pos2) {    // Distance function. TO DETECT COLLISIONS

return Sqrt(Sqr(pos1.x-pos2.x)+Sqr(pos1.y-pos2.y)+Sqr(pos1.z-pos2.z));

}


 void Disparar (Flt x, Flt y) {      // GLOBAL FIRE ENEMY FUNCTION

	 static I8 Pos=0;

	 de[Pos].activar(x,y);

	 Pos++;

	 if (Pos==15) Pos=0;
 }


 void Explosion (Vec pos) {			// GLOBAL EXPLOSION FUNCTION

	 explosion.create(main,single,0x00600000,32,pos,0.2f); // create explosion effect
	 QuakeFx.addShort();   // add medium earth quake

 }	




// Structures: CONSTRUCTION
// +++++++++++++++++++++++++


// Struct Ejuego0 (FIRE PLAYER)

void Ejuego0::crear() {

	Inactivo=true;

	matrix.setScale(1);

}


void Ejuego0::activar() {

	Inactivo=false;

	++djActivos;

	matrix.setPos(Vec(player.matrix.pos.x,1.5f,player.matrix.pos.z+0.1f));

}

void Ejuego0::actualizar() {

	if (Inactivo) return;

	matrix.move(Vec(0,0,0.05));

	if (matrix.pos.z>(Cam.matrix.pos.z+1)) {Inactivo=true; --djActivos;}

}

void Ejuego0::dibujar() {

		if (Inactivo) return;

		meshDj.draw(matrix);

}




// Struct Ejuego1 (PLAYER)


void Ejuego1::crear() {

		loop=true;

		Vida=100;

		loopContador=1; altura=1.5f;

		matrix.setScale(1)
			  .move(Vec(0,altura,0));

}

void Ejuego1::actualizar() {

		if (loop==false) {

			altura+=(65-loopContador)/(Sqr(65-loopContador)+(10*loopContador)); loopContador++;
			if (altura<1.5f) {altura=1.5f; loopContador=1; loop=true;}

		}

		matrix.setPos(Vec(Ms.pos.x+Cam.matrix.pos.x,altura,Ms.pos.y+Cam.matrix.pos.z));

		if ((deActivos>0) && (loop)) {
			REPA (dj) if ((de[i].Inactivo==false)) {
				if (Distancia(matrix.pos,de[i].matrix.pos)<0.1f) {Vida-=20; de[i].Inactivo=true; --deActivos;}
			}
		}

		if (Vida<0) {Explosion(matrix.pos); Vida=100;}
}

void Ejuego1::dibujar() {
	
	meshPlayer.draw(matrix);

}


// Struct Ejuego2 (BIPLANE ENEMY)

void Ejuego2::crear() {

	Activo=false;

	Vida=0;

	IncX=0; IncY=0; localTiempo=0; Transcurso=0;

	pos[0].set(0);
	pos[1].set(0);

	matrix.setScale(1);

}

void Ejuego2::activar() {

	++biplanosActivos;

	Activo=true;

	Vida=100;

	pos[0].set(0,1);
	pos[1].set(Random(-1,1),0.4f);

	localTiempo=Transcurso=Tm.time();

	matrix.setPos(Vec(Cam.matrix.pos.x+pos[0].x,1.5f,Cam.matrix.pos.z+pos[0].y));

	IncX=(pos[1].x-pos[0].x)*Tm.d();
	IncY=(pos[1].y-pos[0].y)*Tm.d();
}

void Ejuego2::actualizar() {

	if (Activo==false) return;

	if ((Tm.time()-Transcurso)>15) {IncY=-0.02f; pos[1].set(pos[1].x,-3);}


	pos[0].x+=IncX; pos[0].y+=IncY;

	matrix.setPos(Vec(Cam.matrix.pos.x+pos[0].x,1.5f,Cam.matrix.pos.z+pos[0].y));

	if ((Tm.time()-localTiempo)>3) {Disparar(matrix.pos.x,matrix.pos.z); localTiempo=Tm.time();}
	if (matrix.pos.z<(Cam.matrix.pos.z-1)) {Activo=false; --biplanosActivos; return;}
	if ((matrix.pos.x>(Cam.matrix.pos.x+pos[1].x)) && (IncX>0)) {IncX=0;}
	if ((matrix.pos.x<(Cam.matrix.pos.x+pos[1].x)) && (IncX<0)) {IncX=0;}
	if ((matrix.pos.z<(Cam.matrix.pos.z+pos[1].y)) && (IncY<0)) {IncY=0;}

	if (djActivos>0) {
		REPA (dj) if ((dj[i].Inactivo==false)) {
			if (Distancia(matrix.pos,dj[i].matrix.pos)<0.1f) {Vida-=20; dj[i].Inactivo=true; --djActivos;}
		}
	}

	if ((Vida<0) || (Distancia(matrix.pos,player.matrix.pos)<0.2f)) {Explosion(matrix.pos); Activo=false; --biplanosActivos;}

}

void Ejuego2::dibujar() {

	if (Activo==false) return;

	meshBiplano.draw(matrix);

}


// Struct Ejuego3 (FIRE ENEMY)

void Ejuego3::crear() {

	Inactivo=true;

	IncX=0; IncY=0;

	Pos.set(0);

	matrix.setScale(1);

}


void Ejuego3::activar(Flt x, Flt y) {

	++deActivos;

	Inactivo=false;

	IncX=(player.matrix.pos.x-x)*Tm.d();
	IncY=(player.matrix.pos.z-y)*Tm.d();

	Pos.set(x-Cam.matrix.pos.x+IncX*3,y-Cam.matrix.pos.z+IncY*3);

	matrix.setPos(Vec(Cam.matrix.pos.x+Pos.x,1.5f,Cam.matrix.pos.z+Pos.y));

}

void Ejuego3::actualizar() {

	if (Inactivo) return;

	Pos.set(Pos.x+IncX,Pos.y+IncY);

	if ((Pos.x<-2) || (Pos.x>2) || (Pos.y<-1) || (Pos.y>1)) {Inactivo=true; --deActivos;return;}

	matrix.setPos(Vec(Cam.matrix.pos.x+Pos.x,1.5f,Cam.matrix.pos.z+Pos.y));

}

void Ejuego3::dibujar() {

	if (Inactivo) return;

	meshDe.draw(matrix);

}




////////////////////////////////////////////////////////////////////////////////////////////////////
//                                         E S E N T H E L                                        //
////////////////////////////////////////////////////////////////////////////////////////////////////





void InitPre() // init before engine inits
{
   // here you will have to setup initial engine settings
   // like application name, its options, screen resolution...

   App.name("Demo");            // application name
   App.icon=(Char*)IDI_ICON1;    // setup icon
   IOPath("../data/");
   PakAdd("../data/engine.pak"); // load engine data

   App.flag=APP_MS_EXCLUSIVE;  // setup mouse exclusive mode to hide cursor


   D.full(true).ambPower(1).hpRt(true).hwDepthBuffer(true).bumpMode(BUMP_PARALLAX).mtnMode(MTN_HIGH);

}
/******************************************************************************/
Bool Init() // init after engine inits
{
   // here when engine will be ready you can load your game data
   // return false when error occured


	// Load Meshes
	meshMalla1.load("LocalData/Obj/terreno/terreno.mesh");
	matrixMalla1.setScale(Vec(2.42f,1.5f,2.2f))
				.move(Vec(0.02f,-3.05f,-1.486f));
	meshMalla2.load("LocalData/Obj/terreno/terreno.mesh");
	meshMalla2.mirrorZ()
		      .setRender();
	matrixMalla2.setScale(Vec(2.42f,1.5f,2.2f))
				.move(Vec(0.02f,-3.05f,7.31f));
	meshPlayer.load("LocalData/Obj/mustang/mustang.mesh");
	meshDj.load("LocalData/Obj/disparo.mesh");
	meshBiplano.load("LocalData/Obj/biplano/biplano.mesh");
	meshDe.load("LocalData/Obj/edisparo.mesh");

	// Explosion configuration
	main  =Gfxs("gfx/particle/explosion/0.gfx");
	single=Gfxs("gfx/particle/explosion/1.gfx");

	//Water configuration
	Water.set(*Gfxs("gfx/water/0.gfx"),*Gfxs("gfx/water/0.n.gfx"),Gfxs("gfx/fx/reflection.gfx"));
	Water.plane(Water.plane()+ Vec(0,-3.2f,0));
	Water.wave_scale=1;
	Water.reflect=1;
	Water.reflect_fake=1;


	//Sun configuration
	Sun &sun=Suns.New();
	sun.set(*Gfxs("gfx/sky/sun.gfx")); // set image
    sun.pos=!Vec(1,1,1);               // set custom position


	//Sky configuration
	Sky.set();


	//Camera configuration (TOP VIEW)
	Cam.pitch=-1.57f; Cam.matrix.setPos(Vec(0,3,0));
	Cam.setAngle(Cam.matrix.pos,Cam.yaw,Cam.pitch,Cam.roll).set();


	//Struct Construction Process
	player.crear();
	REPA (dj) dj[i].crear();
	REPA (biplano) biplano[i].crear();
	REPA (de) de[i].crear();

   return true;
}
/******************************************************************************/
void Shut() // shut at exit
{
   // this is called when the engine is about to exit
}
/******************************************************************************/
Bool Main() // main updating
{
   // here you have to process each frame update

	if(Kb.bp(KB_ESC))return false; // exit if escape on the keyboard pressed


	//Water Movement Update
	Water.update(Vec2(0.02f,0.02f));

	//Move Camera
	Cam.matrix.move(Vec(0,0,0.01f));
	Cam.setAngle(Cam.matrix.pos,Cam.yaw,Cam.pitch).updateVelocities().set();

	//Matrix Meshes Map Update
	if ((Cam.matrix.pos.z-matrixMalla1.pos.z)>12) {matrixMalla1.move(Vec(0,0,17.59f));}
	if ((Cam.matrix.pos.z-matrixMalla2.pos.z)>12) {matrixMalla2.move(Vec(0,0,17.59f));}

	//Player Update
	player.actualizar();


	//Mouse Update
	if ((Ms.b(0)) && (player.loop) && ((Tm.time()-djTiempo)>0.15f)) {dj[djPos].activar(); djTiempo=Tm.time(); ++djPos;}
	if (djPos==15) {djPos=0;}
	if (Ms.b(1)) player.loop=false;


	//Events Update
	if ((Tm.time()-Tiempo)>Evento[eventoPos]) {biplano[biplanoPos].activar(); ++eventoPos; ++biplanoPos;}
	if (eventoPos==7) {eventoPos=0; Tiempo=Tm.time();}
	if (biplanoPos==5) {biplanoPos=0;}


	//Other Game Elements Update
	if (djActivos>0) REPA (dj) dj[i].actualizar();
	if (biplanosActivos>0) REPA (biplano) biplano[i].actualizar();
	if (deActivos>0) REPA (de) de[i].actualizar();

	//Explosion Update
	explosion.update();

	// update Quake Effect
	QuakeFx.update();




	return true;                   // continue
}
/******************************************************************************/
void Render()
{
   switch(Renderer()) {

		case RM_SOLID : case RM_SOLID_M :    //////////    DRAW GAME MESHES      //////////////
											{
											// Map
											meshMalla1.draw(matrixMalla1);
											meshMalla2.draw(matrixMalla2);
											if (matrixMalla2.pos.z>matrixMalla1.pos.z) {temp=matrixMalla1; temp.move(Vec(0,0,17.59f)); meshMalla1.draw(temp);}
												   else {temp=matrixMalla2; temp.move(Vec(0,0,17.59f)); meshMalla2.draw(temp);}
										    // Player
											player.dibujar();
											// Other Game Elements
											if (djActivos>0) REPA (dj) dj[i].dibujar();
											if (biplanosActivos>0) REPA (biplano) biplano[i].dibujar();
											if (deActivos>0) REPA (de) de[i].dibujar();
											break;
											}
   
		case RM_PALETTE:	/////////   EXPLOSION DRAW     /////////
							{
							explosion.draw(); // draw Explosion Effect in Color Palette mode
							break;
							}
   }
}


void Draw() // main drawing
{
	// here you have to tell engine what to draw on the screen

	Renderer(Render);

	// View some variable values.
	D.text(0,-0.8,S+"djA: "+djActivos+"  deA: "+deActivos+"  VidaP: "+player.Vida+"  bActivos: "+biplanosActivos);
	REPA (biplano) D.text(-0.9+0.45*i,-0.9,S+biplano[i].Vida);


}
/******************************************************************************/