rollout rollTentacle "Tentacles"
(
 spinner UInBones "Number of Bones:" type:#integer range:[0,99999,5]
 spinner UIBonesLength "Bones Length:" type:#float range:[0,9999,30]
 button UICreate "Create"
 on UICreate pressed do
 (
  undo on
  (
  punto=point()
  punto.transform= matrix3 1
  prevNode=punto
  attributesIns=attributes TentaclesAttributes
  (
   parameters paramsTA rollout:rollTA
   (
    FWeightManual type:#float ui:UIWeightManual default:0
	FWeightProcedural type:#float ui:UIWeightProcedural default:100
    FFrec type:#float ui:uiFrec default:10
	FAmplitudeB type:#float ui:UIAmplitudeB default:1
	FAmplitudeE type:#float ui:UIAmplitudeE default:2
	FPhase type:#float ui:UIPhase
	FOffset type:#float ui:UIOffset
   )
   rollout rollTA "Tentacle_Parameters"
   (
    group "Wave Parameters"
	(
     spinner UIFrec "Frecuency:" range:[-9999,9999,0]
	 spinner UIAmplitudeB "Amplitude B:" range:[-360,360,0]
	 spinner UIAmplitudeE "Amplitude E:" range:[-360,360,0]
	 spinner UIPhase "Phase:" range:[-9999,9999,0]
	 spinner UIOffset "Offset:" range:[-9999,9999,0]
	)
	group "General Weights"
	(
	 slider UIWeightManual "Manual:" range:[0,100,0]
	 slider UIWeightProcedural "Procedural:" range:[0,100,0]
	)
   )
  )
  addmodifier punto (EmptyModifier())
  punto.modifiers[1].name="WaveControl"
  custattributes.add  punto.modifiers[1] attributesIns
  TAtt=punto.modifiers[1].TentaclesAttributes
  TAtt.FWeightManual.controller=bezier_float()
  TAtt.FWeightProcedural.controller=bezier_float()
  TAtt.FFrec.controller=bezier_float()
  TAtt.FAmplitudeB.controller=bezier_float()
  TAtt.FAmplitudeE.controller=bezier_float()
  TAtt.FPhase.controller=bezier_float()
  TAtt.FOffset.controller=bezier_float()
  n=UInBones.value
  for i=1 to n do
  (
   BoneVar=bonesys.createbone [(i-1)*UIBonesLength.value,0,0] [i*UIBonesLength.value,0,0] [0,0,1]
   BoneVar.parent=prevNode
   BoneVar.rotation.controller=rotation_list()
   ScriptVar=euler_xyz()
   BoneVar.rotation.controller.available.controller=ScriptVar
   
   ScriptVar.z_rotation.controller=float_expression()
   ScriptVar=ScriptVar.z_rotation.controller
   ScriptVar.addScalartarget "Frec" TAtt.FFrec.controller
   ScriptVar.addScalartarget "AB" TAtt.FAmplitudeB.controller
   ScriptVar.addScalartarget "AE" TAtt.FAmplitudeE.controller
   ScriptVar.addScalartarget "Phase" TAtt.FPhase.controller
   ScriptVar.addScalartarget "Offset" TAtt.FOffset.controller
   StringVar="degToRad(sin(F*Frec+Phase+Offset*"+(((i-1)/(n-1) as float) as string)+")*(AB*"+((1.0-(i/n as float)) as string)+"+AE*"+(((i/n as float)) as string)+"))"
   ScriptVar.SetExpression StringVar
   BoneVar.rotation.controller.weight[1].controller=float_expression()
   BoneVar.rotation.controller.weight[1].controller.addScalartarget "Weight" TAtt.FWeightManual.controller
   BoneVar.rotation.controller.weight[1].controller.setExpression "Weight/100"
   BoneVar.rotation.controller.weight[2].controller=float_expression()
   BoneVar.rotation.controller.weight[2].controller.addScalartarget "Weight" TAtt.FWeightProcedural.controller
   BoneVar.rotation.controller.weight[2].controller.setExpression "Weight/100"
   prevNode=BoneVar
  )
  )
 ) 
)
createdialog rollTentacle 180 80